/*
 * Decompiled with CFR 0.152.
 */
package contato.swing.list;

import contato.swing.list.ContatoListModel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JList;

public class ContatoListBehavior
implements MouseListener {
    private List itensListeners = new ArrayList();
    private JList list1;
    private JList list2;
    public final int LIST_1 = 1;
    public final int LIST_2 = 2;

    private ContatoListBehavior(JList list1, JList list2) {
        this.list1 = list1;
        this.list2 = list2;
        list1.setModel(new ContatoListModel());
        list2.setModel(new ContatoListModel());
        list1.addMouseListener(this);
        list2.addMouseListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            if (e.getSource().equals(this.list1)) {
                this.processTransferItem(this.list1, this.list2);
            } else {
                this.processTransferItem(this.list2, this.list1);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public void transferSelectItensList1ToList2() {
        this.processTransferItem(this.list1, this.list2);
    }

    public void transferSelectItensList2ToList1() {
        this.processTransferItem(this.list2, this.list1);
    }

    private void filtrarItensList(List itens, ContatoListModel model1, ContatoListModel model2) {
        model1.clear();
        for (Object obj : itens) {
            if (model2.contains(obj)) continue;
            model1.addElement(obj);
        }
    }

    private void invokeItemListenersChanged() {
        for (Object o : this.itensListeners) {
            ((ItemListChanged)o).itemListChanged();
        }
    }

    private void processTransferItem(JList list1, JList list2) {
        int[] index = list1.getSelectedIndices();
        ContatoListModel model2 = (ContatoListModel)list2.getModel();
        ContatoListModel model1 = (ContatoListModel)list1.getModel();
        Arrays.sort(index);
        for (int i = index.length - 1; i >= 0; --i) {
            model2.addElement(model1.remove(index[i]));
        }
        list1.repaint();
        this.invokeItemListenersChanged();
    }

    public void constructLists(List itensList1, List itensList2, boolean eliminate, int preference) {
        ContatoListModel model2 = (ContatoListModel)this.list2.getModel();
        ContatoListModel model1 = (ContatoListModel)this.list1.getModel();
        if (!eliminate) {
            model1.clear();
            model1.addObjects(itensList1, false);
            model2.clear();
            model2.addObjects(itensList1, false);
        } else if (preference == 1) {
            model1.addObjects(itensList1, false);
            this.filtrarItensList(itensList2, model2, model1);
        } else {
            model2.addObjects(itensList2, false);
            this.filtrarItensList(itensList1, model1, model2);
        }
    }

    public void constructLists(List itensList1, int preference) {
        ContatoListModel model2 = (ContatoListModel)this.list2.getModel();
        ContatoListModel model1 = (ContatoListModel)this.list1.getModel();
        if (preference == 1) {
            model1.addObjects(itensList1, false);
            this.list1.repaint();
        } else {
            model2.addObjects(itensList1, false);
            this.list2.repaint();
        }
    }

    public void addItemListChanged(ItemListChanged itemListener) {
        this.itensListeners.add(itemListener);
    }

    public void removeItemListChanged(ItemListChanged itemListener) {
        this.itensListeners.remove(itemListener);
    }

    public static ContatoListBehavior initBehavior(JList list1, JList list2) {
        return new ContatoListBehavior(list1, list2);
    }

    public static interface ItemListChanged {
        public void itemListChanged();
    }
}

