/*
 * Decompiled with CFR 0.152.
 */
package contato.swing.table.column;

import contato.swing.ContatoTable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class ContatoBooleanColumnHeader
implements TableCellRenderer {
    private final JCheckBox check = new JCheckBox();

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        TableCellRenderer r = table.getTableHeader().getDefaultRenderer();
        JLabel l = (JLabel)r.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        Dimension d = new Dimension(21, 17);
        this.check.setPreferredSize(d);
        this.check.setMaximumSize(d);
        this.check.setMinimumSize(d);
        CheckBoxIcon icon = new CheckBoxIcon(this.check);
        l.setIcon(icon);
        return l;
    }

    public ContatoBooleanColumnHeader(final ContatoTable contatoTable, final Integer columnIndex) {
        this.check.setOpaque(false);
        this.check.setFont(contatoTable.getTableHeader().getFont());
        contatoTable.getTableHeader().addMouseListener(new MouseAdapter(){
            Integer index;
            Boolean value;
            ContatoTable table;
            {
                this.index = columnIndex;
                this.value = false;
                this.table = contatoTable;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = this.table.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int modelColumn = this.table.convertColumnIndexToModel(viewColumn);
                if (this.table.isEnabled() && this.index == modelColumn) {
                    this.value = this.value == false;
                    for (int i = 0; i < this.table.getRowCount(); ++i) {
                        if (!this.table.isCellEditable(i, this.index)) continue;
                        this.table.setValueAt(this.value, i, this.index);
                    }
                    ContatoBooleanColumnHeader.this.check.setSelected(this.value);
                }
            }
        });
    }

    private static class CheckBoxIcon
    implements Icon {
        private final JCheckBox check;

        public CheckBoxIcon(JCheckBox check) {
            this.check = check;
        }

        @Override
        public int getIconWidth() {
            return this.check.getPreferredSize().width;
        }

        @Override
        public int getIconHeight() {
            return this.check.getPreferredSize().height;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            SwingUtilities.paintComponent(g, this.check, (Container)c, x, y, this.getIconWidth(), this.getIconHeight());
        }
    }
}

