/*
 * Decompiled with CFR 0.152.
 */
package contato.swing.table.column;

import contato.swing.ContatoButton;
import contato.swing.ContatoTable;
import contato.swing.table.column.ContatoButtonColumnListener;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ContatoButtonColumn
extends AbstractCellEditor
implements TableCellRenderer,
TableCellEditor,
ActionListener {
    private ContatoTable table;
    private ContatoButton renderButton;
    private ContatoButton editButton;
    private String text;
    private Integer column;
    private ContatoButtonColumnListener buttonColumnListener;

    public ContatoButtonColumn(ContatoTable table, int column, String text) {
        this.setText(text);
        this.table = table;
        this.column = column;
        this.renderButton = new ContatoButton(text);
        this.editButton = new ContatoButton(text);
        this.editButton.setFocusPainted(false);
        this.editButton.addActionListener(this);
        TableColumnModel columnModel = table.getColumnModel();
        TableColumn t = null;
        Enumeration<TableColumn> e = columnModel.getColumns();
        while (e.hasMoreElements()) {
            TableColumn ob = e.nextElement();
            if (ob.getModelIndex() != column) continue;
            t = ob;
            break;
        }
        if (t != null) {
            t.setCellRenderer(this);
            t.setCellEditor(this);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (hasFocus) {
            this.renderButton.setForeground(table.getForeground());
            this.renderButton.setBackground(UIManager.getColor("Button.background"));
        } else if (isSelected) {
            this.renderButton.setForeground(table.getSelectionForeground());
            this.renderButton.setBackground(table.getSelectionBackground());
        } else {
            this.renderButton.setForeground(table.getForeground());
            this.renderButton.setBackground(UIManager.getColor("Button.background"));
        }
        return this.renderButton;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.setText(value == null ? "" : value.toString());
        this.editButton.setText(this.getText());
        return this.editButton;
    }

    @Override
    public Object getCellEditorValue() {
        return this.getText();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.buttonColumnListener != null) {
            int selecionado = this.table.convertRowIndexToModel(this.table.getSelectedRow());
            this.buttonColumnListener.action(this.table, selecionado, this.column);
        }
        this.fireEditingStopped();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String toString() {
        return this.getText();
    }

    public ContatoButtonColumnListener getButtonColumnListener() {
        return this.buttonColumnListener;
    }

    public void setButtonColumnListener(ContatoButtonColumnListener buttonColumnListener) {
        this.buttonColumnListener = buttonColumnListener;
    }
}

