/*
 * Decompiled with CFR 0.152.
 */
package contato.swing.textutilities;

import contato.util.FindAndReplace;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class ContatoSwingTextUtilities {
    private static FindAndReplace findAndReplace;

    public static void initRedoAndUndo(JTextComponent comp) {
        final UndoManager undo = new UndoManager();
        Document doc = comp.getDocument();
        doc.addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent evt) {
                undo.addEdit(evt.getEdit());
            }
        });
        comp.getActionMap().put("Undo", new AbstractAction("Undo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (undo.canUndo()) {
                        undo.undo();
                    }
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
            }
        });
        comp.getInputMap().put(KeyStroke.getKeyStroke("control Z"), "Undo");
        comp.getActionMap().put("Redo", new AbstractAction("Redo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (undo.canRedo()) {
                        undo.redo();
                    }
                }
                catch (CannotRedoException cannotRedoException) {
                    // empty catch block
                }
            }
        });
        comp.getInputMap().put(KeyStroke.getKeyStroke("control Y"), "Redo");
        comp.getInputMap().put(KeyStroke.getKeyStroke("control L"), "Find");
    }
}

