/*
 * Decompiled with CFR 0.152.
 */
package contato.swing.wizard;

import com.touchcomp.basementormedia.ImageProviderFact;
import contato.dialog.ContatoDialogsHelper;
import contato.swing.ContatoButton;
import contato.swing.ContatoPanel;
import contato.swing.ContatoScrollPane;
import contato.swing.ContatoSeparator;
import contato.swing.wizard.ContatoWizardException;
import contato.swing.wizard.WizardInterface;
import contato.swing.wizard.WizardListener;
import contato.util.UtilEnterOnFocusLost;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class WizardPanel
extends JPanel
implements ActionListener {
    private List<WizardInterface> wizards;
    private int indice;
    private HashMap result;
    private List<WizardListener> listeners = new ArrayList<WizardListener>();
    private HashMap basic;
    private ContatoButton btnAnterior;
    private ContatoButton btnCancelar;
    private ContatoButton btnProximo;
    private ContatoPanel contatoPanel1;
    private ContatoPanel contatoPanel3;
    private ContatoSeparator contatoSeparator1;
    private ContatoScrollPane scrollPrincipal;

    public WizardPanel() {
        this.initComponents();
        this.btnAnterior.addActionListener(this);
        this.btnCancelar.addActionListener(this);
        this.btnProximo.addActionListener(this);
        this.enableDisableButtons();
        this.btnCancelar.setDontController();
        this.btnAnterior.setDontController();
        this.btnProximo.setDontController();
    }

    public WizardPanel(List compoL) {
        this();
        this.wizards = compoL;
    }

    private void initComponents() {
        this.contatoPanel1 = new ContatoPanel();
        this.scrollPrincipal = new ContatoScrollPane();
        this.contatoPanel3 = new ContatoPanel();
        this.btnAnterior = new ContatoButton();
        this.btnCancelar = new ContatoButton();
        this.btnProximo = new ContatoButton();
        this.contatoSeparator1 = new ContatoSeparator();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.contatoPanel1.add((Component)this.scrollPrincipal, gridBagConstraints);
        this.btnAnterior.setIcon(new ImageIcon(ImageProviderFact.get().getImagePrior()));
        this.btnAnterior.setText("Anterior");
        this.btnAnterior.setMinimumSize(new Dimension(110, 20));
        this.btnAnterior.setPreferredSize(new Dimension(110, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.contatoPanel3.add((Component)this.btnAnterior, gridBagConstraints);
        this.btnCancelar.setIcon(new ImageIcon(ImageProviderFact.get().getImageCancel()));
        this.btnCancelar.setText("Cancelar");
        this.btnCancelar.setMinimumSize(new Dimension(110, 20));
        this.btnCancelar.setPreferredSize(new Dimension(110, 20));
        this.btnCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WizardPanel.this.btnCancelarActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.contatoPanel3.add((Component)this.btnCancelar, gridBagConstraints);
        this.btnProximo.setIcon(new ImageIcon(ImageProviderFact.get().getImageNext()));
        this.btnProximo.setText("Pr\u00f3ximo");
        this.btnProximo.setMinimumSize(new Dimension(110, 20));
        this.btnProximo.setPreferredSize(new Dimension(110, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.contatoPanel3.add((Component)this.btnProximo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.contatoPanel1.add((Component)this.contatoPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.contatoPanel1.add((Component)this.contatoSeparator1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.contatoPanel1, gridBagConstraints);
    }

    private void btnCancelarActionPerformed(ActionEvent evt) {
        this.btnCancelarActionPerformed();
    }

    private void enableDisableButtons() {
        if (this.getIndice() == 0) {
            this.btnAnterior.setEnabled(false);
        } else {
            this.btnAnterior.setEnabled(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.processarEventos(e);
        }
        catch (ContatoWizardException ex) {
            Logger.getLogger(WizardPanel.class.getName()).log(Level.SEVERE, null, ex);
            ContatoDialogsHelper.showError(ex.getMessage());
        }
    }

    private void goBack() {
        try {
            WizardInterface wizard = this.getWizards().get(this.getIndice());
            if (wizard.isValidPrior()) {
                HashMap h = wizard.closePanel(0);
                this.setIndice(this.getIndice() - 1);
                wizard = this.getWizards().get(this.getIndice());
                wizard.showPanel(h, 0);
                this.panelToScreen(wizard);
                this.changeNextButtonText();
                this.enableDisableButtons();
                this.listenerGoPrevious(wizard, this.getIndice());
            }
        }
        catch (ContatoWizardException ex) {
            ex.printStackTrace();
            ContatoDialogsHelper.showError(ex.getMessage());
        }
    }

    private void panelToScreen(WizardInterface wizard) {
        this.scrollPrincipal.setViewportView(wizard.getViewComponent());
        this.scrollPrincipal.repaint();
        this.scrollPrincipal.revalidate();
    }

    private void goNext() throws ContatoWizardException {
        WizardInterface wizard = this.getWizards().get(this.getIndice());
        if (wizard.isValidNext()) {
            HashMap h = wizard.closePanel(1);
            this.setIndice(this.getIndice() + 1);
            wizard = this.getWizards().get(this.getIndice());
            wizard.showPanel(h, 1);
            this.panelToScreen(wizard);
            this.enableDisableButtons();
            this.changeNextButtonText();
            this.listenerGoNext(wizard, this.getIndice());
        }
    }

    private void changeNextButtonText() {
        if (this.getIndice() == this.getWizards().size() - 1) {
            this.btnProximo.setText("Finalizar");
        } else {
            this.btnProximo.setText("Pr\u00f3ximo");
        }
    }

    private void listenerGoPrevious(WizardInterface wizard, int counter) {
        for (WizardListener w : this.listeners) {
            w.goPrevious(wizard, counter);
        }
    }

    private void listenerGoNext(WizardInterface wizard, int counter) {
        for (WizardListener w : this.listeners) {
            w.goNext(wizard, counter);
        }
    }

    private void listenerEnd(WizardInterface wizard) {
        for (WizardListener w : this.listeners) {
            w.endWizard(wizard);
        }
    }

    public void addWizardListener(WizardListener w) {
        this.listeners.add(w);
    }

    public void removeWizardListener(WizardListener w) {
        this.listeners.remove(w);
    }

    public HashMap getResult() {
        return this.result;
    }

    private void setResult(HashMap result) {
        this.result = result;
    }

    public void startWizard(HashMap h) throws ContatoWizardException {
        this.basic = h;
        this.setIndice(0);
        this.openWizard(h);
    }

    public List<WizardInterface> getWizards() {
        return this.wizards;
    }

    public void setWizards(List<WizardInterface> wizards) {
        this.wizards = wizards;
        for (WizardInterface wizard : wizards) {
            if (!(wizard instanceof Component)) continue;
            UtilEnterOnFocusLost.setEnterOnFocusLost((Component)((Object)wizard));
        }
    }

    private boolean goEnd() {
        try {
            WizardInterface i = this.getWizards().get(this.getIndice());
            if (!i.isValidNext()) {
                return false;
            }
            this.setResult(i.closePanel(1));
            this.listenerEnd(i);
            this.startWizard(this.basic);
        }
        catch (ContatoWizardException ex) {
            ex.printStackTrace();
            ContatoDialogsHelper.showError(ex.getMessage());
            return false;
        }
        return true;
    }

    private void openWizard(HashMap h) throws ContatoWizardException {
        this.btnProximo.setText("Pr\u00f3ximo");
        this.panelToScreen(this.getWizards().get(this.getIndice()));
        WizardInterface i = this.getWizards().get(this.getIndice());
        i.showPanel(h, 2);
        this.listenerOpen(i);
    }

    private void listenerOpen(WizardInterface i) {
        for (WizardListener w : this.listeners) {
            w.openWizard(i);
        }
    }

    private void btnCancelarActionPerformed() {
        WizardInterface i = this.getWizards().get(this.getIndice());
        for (WizardListener w : this.listeners) {
            w.cancelWizard(i);
        }
        this.toBackDefaultWizards();
    }

    private void toBackDefaultWizards() {
        this.btnProximo.setText("Pr\u00f3ximo");
        this.setIndice(0);
    }

    private void processarEventos(ActionEvent e) throws ContatoWizardException {
        if (e.getSource().equals(this.btnAnterior)) {
            this.goBack();
        } else if (e.getSource().equals(this.btnProximo)) {
            if (this.getIndice() == this.getWizards().size() - 1) {
                this.goEnd();
            } else {
                this.goNext();
            }
        }
    }

    public int getIndice() {
        return this.indice;
    }

    public void setIndice(int index) {
        this.indice = index;
    }
}

