/*
 * Decompiled with CFR 0.152.
 */
package contato.util;

import contato.exception.ContatoOpenToolsException;
import contato.jasperreports.print.InfoPrintCommonFilesDialog;
import contato.jasperreports.print.InfoPrintDialog;
import java.awt.Desktop;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;

public class ContatoOpenToolsUtilities {
    public static void openEmail(String email) throws ContatoOpenToolsException {
        try {
            Desktop.getDesktop().mail(new URI("mailto", email, null));
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new ContatoOpenToolsException("Erro ao abrir o email.");
        }
        catch (URISyntaxException ex) {
            ex.printStackTrace();
            throw new ContatoOpenToolsException("Erro ao abrir o email.");
        }
    }

    public static void openSite(String site) throws ContatoOpenToolsException {
        try {
            Desktop.getDesktop().browse(new URI(site));
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new ContatoOpenToolsException("Erro ao abrir o site.");
        }
        catch (URISyntaxException ex) {
            ex.printStackTrace();
            throw new ContatoOpenToolsException("Erro ao abrir o site.");
        }
    }

    public static void printFile(File file) throws ContatoOpenToolsException {
        try {
            Desktop.getDesktop().print(file);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new ContatoOpenToolsException("Erro ao imprimir o arquivo.");
        }
    }

    public static void printFile(JasperPrint jasperPrint) throws ContatoOpenToolsException {
        try {
            InfoPrintDialog in = new InfoPrintDialog(jasperPrint, null);
            in.setSize(400, 200);
            in.setLocationRelativeTo(null);
            in.getBtnImprimir().requestFocus();
            in.setModal(true);
            in.setVisible(true);
        }
        catch (PrinterException ex) {
            Logger.getLogger(ContatoOpenToolsUtilities.class.getName()).log(Level.SEVERE, null, ex);
            throw new ContatoOpenToolsException(ex.getMessage());
        }
    }

    public static void initPrinterJobFields(PrinterJob job) {
        try {
            job.setPrintService(job.getPrintService());
        }
        catch (PrinterException printerException) {
            // empty catch block
        }
    }

    public static void printFileInPrinter(JasperPrint jasperPrint, String printerName) throws ContatoOpenToolsException {
        try {
            InfoPrintDialog inf = new InfoPrintDialog(jasperPrint, printerName);
            inf.setModal(true);
            inf.setTitle("Impress\u00e3o direta");
            inf.setSize(350, 200);
            inf.setLocationRelativeTo(null);
            inf.setVisible(true);
        }
        catch (PrinterException ex) {
            Logger.getLogger(ContatoOpenToolsUtilities.class.getName()).log(Level.SEVERE, null, ex);
            throw new ContatoOpenToolsException("Erro ao iniciar as impressoras.");
        }
    }

    public static void printFileInPrinterDuasVias(JasperPrint jasperPrint, JasperPrint jasperPrint2, String printerName) throws ContatoOpenToolsException {
        try {
            InfoPrintDialog inf = new InfoPrintDialog(jasperPrint, jasperPrint2, printerName);
            inf.setModal(true);
            inf.setTitle("Impress\u00e3o direta");
            inf.setSize(350, 200);
            inf.setLocationRelativeTo(null);
            inf.setVisible(true);
        }
        catch (PrinterException ex) {
            Logger.getLogger(ContatoOpenToolsUtilities.class.getName()).log(Level.SEVERE, null, ex);
            throw new ContatoOpenToolsException("Erro ao iniciar as impressoras.");
        }
    }

    public static void printFileInPrinterDirect(JasperPrint jasperPrint, String printerName) throws ContatoOpenToolsException {
        try {
            InfoPrintDialog inf = new InfoPrintDialog(jasperPrint, printerName);
            inf.print(jasperPrint);
        }
        catch (PrinterException ex) {
            Logger.getLogger(ContatoOpenToolsUtilities.class.getName()).log(Level.SEVERE, null, ex);
            throw new ContatoOpenToolsException("Erro ao iniciar as impressoras.", ex);
        }
        catch (JRException ex) {
            Logger.getLogger(ContatoOpenToolsUtilities.class.getName()).log(Level.SEVERE, null, ex);
            throw new ContatoOpenToolsException("Erro ao iniciar as impressoras.", ex);
        }
    }

    public static void openFile(String file) throws ContatoOpenToolsException {
        try {
            Desktop.getDesktop().open(new File(file));
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new ContatoOpenToolsException("Erro ao abrir o arquivo.");
        }
    }

    public static void editFile(String file) throws ContatoOpenToolsException {
        try {
            Desktop.getDesktop().edit(new File(file));
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new ContatoOpenToolsException("Erro ao editar o arquivo.");
        }
    }

    public static void executeScanner(String scannerPath) throws ContatoOpenToolsException {
        try {
            if (scannerPath == null || scannerPath.trim().length() <= 0) {
                throw new ContatoOpenToolsException("Erro ao executar o aplicativo.");
            }
            Runtime.getRuntime().exec(scannerPath);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ContatoOpenToolsException("Erro ao executar o aplicativo.");
        }
    }

    public static void printData(byte[] bytes) throws ContatoOpenToolsException {
        try {
            InfoPrintCommonFilesDialog inf = new InfoPrintCommonFilesDialog(bytes, null);
            inf.setModal(true);
            inf.setTitle("Impress\u00e3o direta");
            inf.setSize(350, 200);
            inf.setLocationRelativeTo(null);
            inf.setVisible(true);
        }
        catch (Exception ex) {
            Logger.getLogger(ContatoOpenToolsUtilities.class.getName()).log(Level.SEVERE, null, ex);
            throw new ContatoOpenToolsException("Erro ao iniciar as impressoras.");
        }
    }
}

