/*
 * Decompiled with CFR 0.152.
 */
package datechooser.beans.editor.border.types;

import datechooser.beans.editor.border.SimpleBorderEditor;
import datechooser.beans.editor.border.types.AbstractBorderEditor;
import datechooser.beans.editor.font.SimpleFontEditor;
import datechooser.beans.editor.utils.ColorChooseAction;
import datechooser.beans.editor.utils.ColorHolder;
import datechooser.beans.editor.utils.EditorDialog;
import datechooser.beans.editor.utils.NamedInt;
import datechooser.beans.locale.LocaleUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TitledBorderEditor
extends AbstractBorderEditor
implements PropertyChangeListener {
    private static String SAMPLE_TEXT = LocaleUtils.getEditorLocaleString("sample");
    private String title;
    private int titleJustification;
    private int titlePosition;
    private Font titleFont;
    private ColorHolder titleColor;
    private Border titledBorder;
    private Dimension comboDim = new Dimension(100, 20);
    private JComboBox comboPos;
    private JComboBox comboJust;
    private EditorDialog borderEditorDialog;
    private EditorDialog fontEditorDialog;

    public TitledBorderEditor() {
        this.initialize();
        this.titleColor = new ColorHolder();
        this.borderEditorDialog = new EditorDialog((Frame)this.getParent(), new SimpleBorderEditor());
        this.fontEditorDialog = new EditorDialog((Frame)this.getParent(), new SimpleFontEditor());
        this.setCaption(LocaleUtils.getEditorLocaleString("Titled"));
        this.assignValueToParameters();
        this.setLayout(new BorderLayout());
        JPanel pControls = new JPanel(new GridLayout(3, 1));
        pControls.add(this.createCaptionField());
        JPanel buttons = this.getCenteredPane(null);
        buttons.add(this.createFontChooseButton());
        buttons.add(this.createBorderChooseButton());
        buttons.add(this.createColorChooseButton());
        pControls.add(buttons);
        JPanel selectors = this.getCenteredPane(null);
        selectors.add(this.createTitlePositionSelector());
        selectors.add(this.createTitleJustifySelector());
        pControls.add(selectors);
        this.add((Component)pControls, "North");
        this.refreshInterface();
    }

    private void setText(String text) {
        this.title = text;
        this.fireChange();
    }

    private JPanel createCaptionField() {
        final JTextField field = new JTextField(15);
        field.setText(SAMPLE_TEXT);
        field.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                TitledBorderEditor.this.setText(field.getText());
            }

            public void insertUpdate(DocumentEvent e) {
                TitledBorderEditor.this.setText(field.getText());
            }

            public void removeUpdate(DocumentEvent e) {
                TitledBorderEditor.this.setText(field.getText());
            }
        });
        return this.getCenteredPane(field);
    }

    private JPanel createBorderChooseButton() {
        JButton bBorder = new JButton(LocaleUtils.getEditorLocaleString("Border"));
        bBorder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Border newBorder = (Border)TitledBorderEditor.this.borderEditorDialog.showDialog(TitledBorderEditor.this.titledBorder, LocaleUtils.getEditorLocaleString("Select_border"));
                if (!TitledBorderEditor.this.borderEditorDialog.isCanceled()) {
                    TitledBorderEditor.this.titledBorder = newBorder;
                    TitledBorderEditor.this.fireChange();
                }
            }
        });
        return this.getCenteredPane(bBorder);
    }

    private JPanel createColorChooseButton() {
        JButton bColor = new JButton(LocaleUtils.getEditorLocaleString("Color"));
        ColorChooseAction colorChooseAction = new ColorChooseAction(this.titleColor, LocaleUtils.getEditorLocaleString("Title_color"), this);
        colorChooseAction.addPropertyChangeListener(this);
        bColor.addActionListener(colorChooseAction);
        return this.getCenteredPane(bColor);
    }

    private JPanel createTitleJustifySelector() {
        NamedInt[] data = new NamedInt[]{new NamedInt(LocaleUtils.getEditorLocaleString("left"), 1), new NamedInt(LocaleUtils.getEditorLocaleString("center"), 2), new NamedInt(LocaleUtils.getEditorLocaleString("right"), 3), new NamedInt(LocaleUtils.getEditorLocaleString("leading"), 4), new NamedInt(LocaleUtils.getEditorLocaleString("trailing"), 5)};
        this.comboJust = new JComboBox<NamedInt>(data);
        this.comboJust.setPreferredSize(this.comboDim);
        this.setSelectedInt(this.comboJust, this.titleJustification);
        this.comboJust.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TitledBorderEditor.this.titleJustification = ((NamedInt)TitledBorderEditor.this.comboJust.getSelectedItem()).getValue();
                TitledBorderEditor.this.fireChange();
            }
        });
        return this.getCenteredPane(this.comboJust);
    }

    private JPanel createTitlePositionSelector() {
        NamedInt[] data = new NamedInt[]{new NamedInt(LocaleUtils.getEditorLocaleString("above_top"), 1), new NamedInt(LocaleUtils.getEditorLocaleString("top"), 2), new NamedInt(LocaleUtils.getEditorLocaleString("below_top"), 3), new NamedInt(LocaleUtils.getEditorLocaleString("above_bottom"), 4), new NamedInt(LocaleUtils.getEditorLocaleString("bottom"), 5), new NamedInt(LocaleUtils.getEditorLocaleString("below_bottom"), 6)};
        this.comboPos = new JComboBox<NamedInt>(data);
        this.setSelectedInt(this.comboPos, this.titlePosition);
        this.comboPos.setPreferredSize(this.comboDim);
        this.comboPos.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TitledBorderEditor.this.titlePosition = ((NamedInt)TitledBorderEditor.this.comboPos.getSelectedItem()).getValue();
                TitledBorderEditor.this.fireChange();
            }
        });
        return this.getCenteredPane(this.comboPos);
    }

    private void setSelectedInt(JComboBox combo, int intValue) {
        int items = combo.getItemCount();
        for (int i = 0; i < items; ++i) {
            if (((NamedInt)combo.getItemAt(i)).getValue() != intValue) continue;
            combo.setSelectedIndex(i);
            break;
        }
    }

    private JPanel createFontChooseButton() {
        JButton bFont = new JButton(LocaleUtils.getEditorLocaleString("Font"));
        bFont.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Font newFont = (Font)TitledBorderEditor.this.fontEditorDialog.showDialog(TitledBorderEditor.this.titleFont, LocaleUtils.getEditorLocaleString("Select_font"));
                if (!TitledBorderEditor.this.fontEditorDialog.isCanceled()) {
                    TitledBorderEditor.this.titleFont = newFont;
                    TitledBorderEditor.this.fireChange();
                }
            }
        });
        return this.getCenteredPane(bFont);
    }

    protected void prepareSelection() {
        this.setValue(new TitledBorder(this.titledBorder, this.title, this.titleJustification, this.titlePosition, this.titleFont, this.titleColor.getColor()));
    }

    private void assignValueToParameters() {
        this.titledBorder = this.getValue().getBorder();
        this.title = this.getValue().getTitle();
        this.titleJustification = this.getValue().getTitleJustification();
        this.titlePosition = this.getValue().getTitlePosition();
        this.titleFont = this.getValue().getTitleFont();
        this.titleColor.setColor(this.getValue().getTitleColor());
    }

    protected TitledBorder getValue() {
        return (TitledBorder)this.value;
    }

    public void refreshInterface() {
        this.assignValueToParameters();
        this.setSelectedInt(this.comboPos, this.titlePosition);
        this.setSelectedInt(this.comboJust, this.titleJustification);
    }

    protected Border getDefaultValue() {
        return new TitledBorder(BorderFactory.createEtchedBorder(), SAMPLE_TEXT);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (!"color".equals(evt.getPropertyName())) {
            return;
        }
        this.fireChange();
    }
}

