/*
 * Decompiled with CFR 0.152.
 */
package datechooser.beans.editor.locale;

import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Locale;

public class LocaleSet {
    private Locale[] locales;
    private String[] names;
    private Locale current = Locale.getDefault();

    public LocaleSet() {
        this.locales = Calendar.getAvailableLocales();
        DateFormatSymbols dfs = new DateFormatSymbols();
        this.names = new String[this.getLocales().length];
        this.initLocaleNames();
    }

    private void initLocaleNames() {
        for (int i = 0; i < this.getLocales().length; ++i) {
            this.getNames()[i] = this.getLocales()[i].getDisplayName() + " [" + this.getLocales()[i].getDisplayName(this.getLocales()[i]) + "]";
        }
    }

    public String[] getNames() {
        return this.names;
    }

    public void setCurrent(String name) {
        for (int i = 0; i < this.getNames().length; ++i) {
            if (!name.equals(this.getNames()[i])) continue;
            this.current = this.getLocales()[i];
            return;
        }
        this.current = Locale.getDefault();
    }

    public int getIndex(Locale locale) {
        for (int i = 0; i < this.getLocales().length; ++i) {
            if (!locale.equals(this.getLocales()[i])) continue;
            return i;
        }
        return 0;
    }

    public Locale getCurrent() {
        return this.current;
    }

    public Locale[] getLocales() {
        return this.locales;
    }

    public int size() {
        return this.getLocales().length;
    }
}

