/*
 * Decompiled with CFR 0.152.
 */
package cteapplication2.certificate;

import com.touchcomp.basementorclientwebservices.certificado.CertificadoConfClienteWebservice;
import com.touchcomp.basementorclientwebservices.constants.EnumTipoCertificado;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CteSignature {
    public String assinarXMLCTe(String xmlEnt) throws Exception {
        CertificadoConfClienteWebservice se = CertificadoConfClienteWebservice.getConfiguracaoCertificado();
        if (ToolMethods.isEquals((Object)se.getParams().getTipoCertificado(), (Object)EnumTipoCertificado.CERTIFICADO_A1) || ToolMethods.isEquals((Object)se.getParams().getTipoCertificado(), (Object)EnumTipoCertificado.CERTIFICADO_A3)) {
            return this.assinarXMLProviderEnvCTe(xmlEnt, "CTe", "infCte");
        }
        if (ToolMethods.isEquals((Object)se.getParams().getTipoCertificado(), (Object)EnumTipoCertificado.CERTIFICADO_WINDOWS)) {
            return this.assinarXMLWindowsProviderEnvCTe(xmlEnt, "CTe", "infCte");
        }
        throw new Exception("Opcao de certificado invalida.");
    }

    private String assinarXMLProviderEnvCTe(String xml, String elementPrincipal, String elementToSignature) throws Exception {
        KeyStore ks;
        CertificadoConfClienteWebservice se = CertificadoConfClienteWebservice.getConfiguracaoCertificado();
        Provider p = se.getProvider();
        if (ToolMethods.isEquals((Object)se.getParams().getTipoCertificado(), (Object)EnumTipoCertificado.CERTIFICADO_A3)) {
            ks = KeyStore.getInstance("pkcs11", p);
            ks.load(null, se.getParams().getSenhaCertificado().toCharArray());
        } else {
            ks = KeyStore.getInstance("PKCS12");
            ks.load(new FileInputStream(this.getCaminhoCertificado(se.getParams().getPathCertificadoA1())), se.getParams().getSenhaCertificado().toCharArray());
        }
        KeyStore.PrivateKeyEntry pkEntry = null;
        Enumeration<String> aliasesEnum = ks.aliases();
        while (aliasesEnum.hasMoreElements()) {
            String alias = aliasesEnum.nextElement();
            System.out.println(alias);
            if (!ks.isKeyEntry(alias)) continue;
            pkEntry = (KeyStore.PrivateKeyEntry)ks.getEntry(alias, new KeyStore.PasswordProtection(se.getParams().getSenhaCertificado().toCharArray()));
            break;
        }
        return this.signature(xml, pkEntry, elementPrincipal, elementToSignature);
    }

    private String assinarXMLWindowsProviderEnvCTe(String xml, String elementPrincipal, String elementToSignature) throws Exception {
        KeyStore ks = null;
        CertificadoConfClienteWebservice se = CertificadoConfClienteWebservice.getConfiguracaoCertificado();
        ks = KeyStore.getInstance("Windows-MY", "SunMSCAPI");
        ks.load(null, null);
        KeyStore.PrivateKeyEntry pkEntry = (KeyStore.PrivateKeyEntry)ks.getEntry(se.getParams().getAliasCertificado(), new KeyStore.PasswordProtection(se.getParams().getSenhaCertificado().toCharArray()));
        return this.signature(xml, pkEntry, elementPrincipal, elementToSignature);
    }

    private String signature(String xml, KeyStore.PrivateKeyEntry pkEntry, String elementPrincipal, String elementToSignature) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document doc = factory.newDocumentBuilder().parse(new ByteArrayInputStream(xml.getBytes()));
        XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
        ArrayList<Transform> transformList = new ArrayList<Transform>();
        TransformParameterSpec tps = null;
        Transform envelopedTransform = fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", tps);
        Transform c14NTransform = fac.newTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", tps);
        transformList.add(envelopedTransform);
        transformList.add(c14NTransform);
        PrivateKey privateKey = pkEntry.getPrivateKey();
        X509Certificate cert = (X509Certificate)pkEntry.getCertificate();
        KeyInfoFactory kif = fac.getKeyInfoFactory();
        ArrayList<X509Certificate> x509Content = new ArrayList<X509Certificate>();
        x509Content.add(cert);
        X509Data xd = kif.newX509Data(x509Content);
        KeyInfo ki = kif.newKeyInfo(Collections.singletonList(xd));
        for (int i = 0; i < doc.getElementsByTagName(elementPrincipal).getLength(); ++i) {
            this.signatureSubElement(fac, transformList, privateKey, ki, doc, i, elementToSignature, elementPrincipal);
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer trans = tf.newTransformer();
        trans.transform(new DOMSource(doc), new StreamResult(os));
        return os.toString();
    }

    private void signatureSubElement(XMLSignatureFactory fac, ArrayList transformList, PrivateKey privateKey, KeyInfo ki, Document doc, int i, String elementToSignature, String elementFatherSig) throws Exception {
        NodeList elements = doc.getElementsByTagName(elementToSignature);
        Element el = (Element)elements.item(i);
        el.setIdAttribute("Id", true);
        String id = el.getAttribute("Id");
        Reference ref = fac.newReference("#" + id, fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), transformList, null, null);
        SignedInfo si = fac.newSignedInfo(fac.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (C14NMethodParameterSpec)null), fac.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null), Collections.singletonList(ref));
        XMLSignature signature = fac.newXMLSignature(si, ki);
        DOMSignContext dsc = new DOMSignContext(privateKey, doc.getElementsByTagName(elementFatherSig).item(i));
        signature.sign(dsc);
    }

    public String assinarCancelamentoCTe(String xmlEnt) throws Exception {
        CertificadoConfClienteWebservice se = CertificadoConfClienteWebservice.getConfiguracaoCertificado();
        if (ToolMethods.isEquals((Object)se.getParams().getTipoCertificado(), (Object)EnumTipoCertificado.CERTIFICADO_A1) || ToolMethods.isEquals((Object)se.getParams().getTipoCertificado(), (Object)EnumTipoCertificado.CERTIFICADO_A3)) {
            return this.assinarXMLProviderEnvCTe(xmlEnt, "eventoCTe", "infEvento");
        }
        if (ToolMethods.isEquals((Object)se.getParams().getTipoCertificado(), (Object)EnumTipoCertificado.CERTIFICADO_WINDOWS)) {
            return this.assinarXMLWindowsProviderEnvCTe(xmlEnt, "eventoCTe", "infEvento");
        }
        throw new Exception("Opcao de certificado invalida.");
    }

    public String assinarInutilizacaoCTe(String xmlEnt) throws Exception {
        CertificadoConfClienteWebservice se = CertificadoConfClienteWebservice.getConfiguracaoCertificado();
        if (ToolMethods.isEquals((Object)se.getParams().getTipoCertificado(), (Object)EnumTipoCertificado.CERTIFICADO_A1) || ToolMethods.isEquals((Object)se.getParams().getTipoCertificado(), (Object)EnumTipoCertificado.CERTIFICADO_A3)) {
            return this.assinarXMLProviderEnvCTe(xmlEnt, "inutCTe", "infInut");
        }
        if (ToolMethods.isEquals((Object)se.getParams().getTipoCertificado(), (Object)EnumTipoCertificado.CERTIFICADO_WINDOWS)) {
            return this.assinarXMLWindowsProviderEnvCTe(xmlEnt, "inutCTe", "infInut");
        }
        throw new Exception("Opcao de certificado invalida.");
    }

    private String getCaminhoCertificado(byte[] pathCertificadoA1) throws IOException {
        String pathFile = null;
        if (pathCertificadoA1 != null) {
            pathFile = this.getPathFile(pathCertificadoA1, "certificado.pfx");
        }
        return pathFile;
    }

    private String getPathFile(byte[] arquivoPFX, String string) throws FileNotFoundException, IOException {
        Object dir = System.getProperty("user.dir");
        dir = (String)dir + "/";
        File f = new File((String)dir + string);
        FileOutputStream out = new FileOutputStream(f);
        out.write(arquivoPFX);
        out.flush();
        out.close();
        return f.getAbsolutePath();
    }
}

