/*
 * Decompiled with CFR 0.152.
 */
package cteapplication2.versao300.service;

import com.touchcomp.basementorlogger.TLogger;
import cteapplication2.certificate.CteSignature;
import cteapplication2.exception.CteException;
import cteapplication2.versao300.model.TEvento;
import cteapplication2.versao300.model.TRetEvento;
import cteapplication2.versao300.service.cterecepcaoevento.RecepcaoEventoStub;
import cteapplication2.versao300.util.CteFileUtil;
import cteapplication2.versao300.validacao.exceptions.ValidateException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.bind.JAXBException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import utilities.MarshallerUtil;

public class CteCancelamento {
    private static final TLogger logger = TLogger.get(CteCancelamento.class);
    private final String versao = "3.00";

    public void cancelamentoCte(EncapsuledMessageRec e) throws MalformedURLException, JAXBException, CteException, ValidateException {
        TRetEvento ret;
        new CteFileUtil().beforeCancelamentoCTe(e.getXmlSend());
        String result = this.sendMessage(e.getUrlToSend(), e.getXmlSend(), e.getCodUf());
        new CteFileUtil().afterCancelamentoCTe(result);
        e.toReceive = ret = (TRetEvento)MarshallerUtil.umarshall(result, TRetEvento.class);
        e.xmlReceive = result;
    }

    public EncapsuledMessageRec prepareMessage(TEvento t, String url, int codUf) throws MalformedURLException, JAXBException, CteException, ValidateException {
        URL u = new URL(url);
        String xml = MarshallerUtil.mashall(t);
        try {
            xml = new CteSignature().assinarCancelamentoCTe(xml);
        }
        catch (Exception ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            throw new CteException("Erro ao assinar o XML de envio.");
        }
        xml = xml.replaceAll("\r", "");
        xml = xml.replaceAll("\t", "");
        xml = xml.replaceAll("\n", "");
        EncapsuledMessageRec e = new EncapsuledMessageRec();
        e.codUf = codUf;
        e.toSend = t;
        e.urlToSend = u;
        e.xmlSend = xml;
        return e;
    }

    private String sendMessage(URL u, String xml, int codUf) throws CteException {
        try {
            RecepcaoEventoStub stub = new RecepcaoEventoStub(u.toString());
            RecepcaoEventoStub.CteDadosMsg dados = new RecepcaoEventoStub.CteDadosMsg();
            OMElement el = AXIOMUtil.stringToOM((String)xml);
            dados.setExtraElement(el);
            RecepcaoEventoStub.CteCabecMsg cab = new RecepcaoEventoStub.CteCabecMsg();
            cab.setVersaoDados("3.00");
            cab.setCUF(String.valueOf(codUf));
            RecepcaoEventoStub.CteCabecMsgE cabE = new RecepcaoEventoStub.CteCabecMsgE();
            cabE.setCteCabecMsg(cab);
            return stub.cteRecepcaoEvento(dados, cabE).getExtraElement().toString();
        }
        catch (Exception e) {
            throw new CteException("| WsCTeRecepcao.execute(): " + e.toString());
        }
    }

    public static class EncapsuledMessageRec {
        private String xmlSend;
        private String xmlReceive;
        private Integer codUf;
        private URL urlToSend;
        private TEvento toSend;
        private TRetEvento toReceive;
        private String msgProcessada;
        private Object auxiliar;

        public String getXmlSend() {
            return this.xmlSend;
        }

        public String getXmlReceive() {
            return this.xmlReceive;
        }

        public Integer getCodUf() {
            return this.codUf;
        }

        public URL getUrlToSend() {
            return this.urlToSend;
        }

        public TEvento getToSend() {
            return this.toSend;
        }

        public TRetEvento getToReceive() {
            return this.toReceive;
        }

        public String getMsgProcessada() {
            return this.msgProcessada;
        }

        public void setMsgProcessada(String msgProcessada) {
            this.msgProcessada = msgProcessada;
        }

        public Object getAuxiliar() {
            return this.auxiliar;
        }

        public void setAuxiliar(Object auxiliar) {
            this.auxiliar = auxiliar;
        }
    }
}

