/*
 * Decompiled with CFR 0.152.
 */
package cteapplication2.versao300.service;

import cteapplication2.exception.CteException;
import cteapplication2.versao300.model.TConsSitCTe;
import cteapplication2.versao300.model.TRetConsSitCTe;
import cteapplication2.versao300.service.cteconsulta.CteConsultaStub;
import cteapplication2.versao300.util.CteFileUtil;
import cteapplication2.versao300.validacao.exceptions.ValidateException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.bind.JAXBException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import utilities.MarshallerUtil;

public class CteConsultaCte {
    private String versao = "3.00";

    public void consultaSituacaoCte(EncapsuledMessageRec e) throws MalformedURLException, JAXBException, CteException, ValidateException {
        TRetConsSitCTe ret;
        new CteFileUtil().beforeConsRetRecepcaoLoteCTe(e.getXmlSend());
        String result = this.sendMessage(e.getUrlToSend(), e.getXmlSend(), e.getCodUf());
        new CteFileUtil().afterConsRetRecepcaoLoteCTe(result);
        e.toReceive = ret = (TRetConsSitCTe)MarshallerUtil.umarshall(result, TRetConsSitCTe.class);
        e.xmlReceive = result;
    }

    public EncapsuledMessageRec prepareMessage(TConsSitCTe t, String url, int codUF) throws MalformedURLException, JAXBException, CteException, ValidateException {
        URL u = new URL(url);
        String xml = MarshallerUtil.mashall(t);
        EncapsuledMessageRec e = new EncapsuledMessageRec();
        e.codUf = codUF;
        e.toSend = t;
        e.urlToSend = u;
        e.xmlSend = xml;
        return e;
    }

    private String sendMessage(URL u, String xml, int codUf) throws CteException {
        try {
            CteConsultaStub stub = new CteConsultaStub(u.toString());
            CteConsultaStub.CteDadosMsg dados = new CteConsultaStub.CteDadosMsg();
            OMElement el = AXIOMUtil.stringToOM((String)xml);
            dados.setExtraElement(el);
            CteConsultaStub.CteCabecMsg cab = new CteConsultaStub.CteCabecMsg();
            cab.setVersaoDados(this.versao);
            cab.setCUF(String.valueOf(codUf));
            CteConsultaStub.CteCabecMsgE cabE = new CteConsultaStub.CteCabecMsgE();
            cabE.setCteCabecMsg(cab);
            return stub.cteConsultaCT(dados, cabE).getExtraElement().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CteException("| WsCTeRecepcao.execute(): " + e.toString());
        }
    }

    public static class EncapsuledMessageRec {
        private String xmlSend;
        private String xmlReceive;
        private Integer codUf;
        private URL urlToSend;
        private TConsSitCTe toSend;
        private TRetConsSitCTe toReceive;
        private String msgProcessada;
        private Object auxiliar;

        public String getXmlSend() {
            return this.xmlSend;
        }

        public String getXmlReceive() {
            return this.xmlReceive;
        }

        public Integer getCodUf() {
            return this.codUf;
        }

        public URL getUrlToSend() {
            return this.urlToSend;
        }

        public TConsSitCTe getToSend() {
            return this.toSend;
        }

        public TRetConsSitCTe getToReceive() {
            return this.toReceive;
        }

        public String getMsgProcessada() {
            return this.msgProcessada;
        }

        public void setMsgProcessada(String msgProcessada) {
            this.msgProcessada = msgProcessada;
        }

        public Object getAuxiliar() {
            return this.auxiliar;
        }

        public void setAuxiliar(Object auxiliar) {
            this.auxiliar = auxiliar;
        }
    }
}

