/*
 * Decompiled with CFR 0.152.
 */
package cteapplication2.versao300.service;

import com.touchcomp.basementorlogger.TLogger;
import cteapplication2.certificate.CteSignature;
import cteapplication2.exception.CteException;
import cteapplication2.versao300.model.TInutCTe;
import cteapplication2.versao300.model.TRetInutCTe;
import cteapplication2.versao300.service.cteinutilizacao.CteInutilizacaoStub;
import cteapplication2.versao300.util.CteFileUtil;
import cteapplication2.versao300.validacao.exceptions.ValidateException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.bind.JAXBException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import utilities.MarshallerUtil;

public class CteInutilizacao {
    private static TLogger logger = TLogger.get(CteInutilizacao.class);
    private String versao = "3.00";

    public void inutilizacaoCte(EncapsuledMessageRec e) throws MalformedURLException, JAXBException, CteException, ValidateException {
        TRetInutCTe ret;
        new CteFileUtil().beforeinutilizaCTe(e.getXmlSend());
        String result = this.sendMessage(e.getUrlToSend(), e.getXmlSend(), e.getCodUf());
        new CteFileUtil().afterInutilizaCTe(result);
        e.toReceive = ret = (TRetInutCTe)MarshallerUtil.umarshall(result, TRetInutCTe.class);
        e.xmlReceive = result;
    }

    public EncapsuledMessageRec prepareMessage(TInutCTe t, String url, int codUf) throws MalformedURLException, JAXBException, CteException, ValidateException {
        URL u = new URL(url);
        String xml = MarshallerUtil.mashall(t);
        try {
            xml = new CteSignature().assinarInutilizacaoCTe(xml);
        }
        catch (Exception ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            throw new CteException("Erro ao assinar o XML de envio.");
        }
        xml = xml.replaceAll("\r", "");
        xml = xml.replaceAll("\t", "");
        xml = xml.replaceAll("\n", "");
        EncapsuledMessageRec e = new EncapsuledMessageRec();
        e.codUf = codUf;
        e.toSend = t;
        e.urlToSend = u;
        e.xmlSend = xml;
        return e;
    }

    private String sendMessage(URL u, String xml, int codUf) throws CteException {
        try {
            CteInutilizacaoStub stub = new CteInutilizacaoStub(u.toString());
            CteInutilizacaoStub.CteDadosMsg dados = new CteInutilizacaoStub.CteDadosMsg();
            OMElement el = AXIOMUtil.stringToOM((String)xml);
            dados.setExtraElement(el);
            CteInutilizacaoStub.CteCabecMsg cab = new CteInutilizacaoStub.CteCabecMsg();
            cab.setVersaoDados(this.versao);
            cab.setCUF(String.valueOf(codUf));
            CteInutilizacaoStub.CteCabecMsgE cabE = new CteInutilizacaoStub.CteCabecMsgE();
            cabE.setCteCabecMsg(cab);
            return stub.cteInutilizacaoCT(dados, cabE).getExtraElement().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CteException("| WsCTeRecepcao.execute(): " + e.toString());
        }
    }

    public static class EncapsuledMessageRec {
        private String xmlSend;
        private String xmlReceive;
        private Integer codUf;
        private URL urlToSend;
        private TInutCTe toSend;
        private TRetInutCTe toReceive;
        private String msgProcessada;
        private Object auxiliar;

        public String getXmlSend() {
            return this.xmlSend;
        }

        public String getXmlReceive() {
            return this.xmlReceive;
        }

        public Integer getCodUf() {
            return this.codUf;
        }

        public URL getUrlToSend() {
            return this.urlToSend;
        }

        public TInutCTe getToSend() {
            return this.toSend;
        }

        public TRetInutCTe getToReceive() {
            return this.toReceive;
        }

        public String getMsgProcessada() {
            return this.msgProcessada;
        }

        public void setMsgProcessada(String msgProcessada) {
            this.msgProcessada = msgProcessada;
        }

        public Object getAuxiliar() {
            return this.auxiliar;
        }

        public void setAuxiliar(Object auxiliar) {
            this.auxiliar = auxiliar;
        }
    }
}

