/*
 * Decompiled with CFR 0.152.
 */
package cteapplication2.versao300.service;

import cteapplication2.certificate.CteSignature;
import cteapplication2.exception.CteException;
import cteapplication2.versao300.model.TCTe;
import cteapplication2.versao300.model.TEnviCTe;
import cteapplication2.versao300.model.TRetEnviCTe;
import cteapplication2.versao300.service.cterecepcao.CteRecepcaoStub;
import cteapplication2.versao300.util.CteFileUtil;
import cteapplication2.versao300.validacao.EnvCTeValidate;
import cteapplication2.versao300.validacao.exceptions.ValidateException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.bind.JAXBException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import utilities.MarshallerUtil;

public class CteRecepcao {
    private String versao = "3.00";

    public void recepcaoLote(EncapsuledMessageRec e) throws MalformedURLException, JAXBException, CteException, ValidateException {
        TRetEnviCTe ret;
        new CteFileUtil().beforeSendLoteCTe(e.getXmlSend(), e.getToSend().getIdLote());
        String result = this.sendMessage(e.getUrlToSend(), e.getXmlSend(), e.getCodUf());
        new CteFileUtil().afterSendLoteCTe(result, e.getToSend().getIdLote());
        e.toReceive = ret = (TRetEnviCTe)MarshallerUtil.umarshall(result, TRetEnviCTe.class);
        e.xmlReceive = result;
    }

    public String gerarXMLSemValidade(TEnviCTe t) throws MalformedURLException, JAXBException, CteException, ValidateException {
        String xml = MarshallerUtil.mashall(t);
        xml = xml.replaceAll(" xmlns:ns2=\"http://www.w3.org/2000/09/xmldsig#\"", "");
        try {
            xml = new CteSignature().assinarXMLCTe(xml);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new CteException("Erro ao assinar o arquivo XML. Verifique seu certificado.");
        }
        return xml;
    }

    public String gerarXMLSemValidade(TCTe t) throws MalformedURLException, JAXBException, CteException, ValidateException {
        String xml = MarshallerUtil.mashall(t);
        xml = xml.replaceAll(" xmlns:ns2=\"http://www.w3.org/2000/09/xmldsig#\"", "");
        try {
            xml = new CteSignature().assinarXMLCTe(xml);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new CteException("Erro ao assinar o arquivo XML. Verifique seu certificado.");
        }
        return xml;
    }

    public EncapsuledMessageRec prepareMessage(TEnviCTe t, String url, int codUf) throws MalformedURLException, JAXBException, CteException, ValidateException {
        URL u = new URL(url);
        String xml = MarshallerUtil.mashall(t);
        xml = xml.replaceAll(" xmlns:ns2=\"http://www.w3.org/2000/09/xmldsig#\"", "");
        try {
            xml = new CteSignature().assinarXMLCTe(xml);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new CteException("Erro ao assinar o arquivo XML. Verifique seu certificado.");
        }
        xml = xml.replaceAll("\r", "");
        xml = xml.replaceAll("\t", "");
        xml = xml.replaceAll("\n", "");
        new EnvCTeValidate().validarXML(xml);
        EncapsuledMessageRec e = new EncapsuledMessageRec();
        e.codUf = codUf;
        e.toSend = t;
        e.urlToSend = u;
        e.xmlSend = xml;
        return e;
    }

    private String sendMessage(URL u, String xml, int codUf) throws CteException {
        try {
            CteRecepcaoStub stub = new CteRecepcaoStub(u.toString());
            CteRecepcaoStub.CteDadosMsg dados = new CteRecepcaoStub.CteDadosMsg();
            OMElement el = AXIOMUtil.stringToOM((String)xml);
            dados.setExtraElement(el);
            CteRecepcaoStub.CteCabecMsg cab = new CteRecepcaoStub.CteCabecMsg();
            cab.setVersaoDados(this.versao);
            cab.setCUF(String.valueOf(codUf));
            System.out.println("Enviando aqui o lote");
            CteRecepcaoStub.CteCabecMsgE cabE = new CteRecepcaoStub.CteCabecMsgE();
            cabE.setCteCabecMsg(cab);
            return stub.cteRecepcaoLote(dados, cabE).getExtraElement().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CteException("| WsCTeRecepcao.execute(): " + e.toString(), e);
        }
    }

    public static class EncapsuledMessageRec {
        private String xmlSend;
        private String xmlReceive;
        private Integer codUf;
        private URL urlToSend;
        private TEnviCTe toSend;
        private TRetEnviCTe toReceive;
        private String msgProcesada;
        private Object auxiliar;

        public String getXmlSend() {
            return this.xmlSend;
        }

        public String getXmlReceive() {
            return this.xmlReceive;
        }

        public Integer getCodUf() {
            return this.codUf;
        }

        public URL getUrlToSend() {
            return this.urlToSend;
        }

        public TEnviCTe getToSend() {
            return this.toSend;
        }

        public TRetEnviCTe getToReceive() {
            return this.toReceive;
        }

        public String getMsgProcesada() {
            return this.msgProcesada;
        }

        public void setMsgProcesada(String msgProcesada) {
            this.msgProcesada = msgProcesada;
        }

        public Object getAuxiliar() {
            return this.auxiliar;
        }

        public void setAuxiliar(Object auxiliar) {
            this.auxiliar = auxiliar;
        }
    }
}

