/*
 * Decompiled with CFR 0.152.
 */
package cteapplication2.versao300.validacao;

import com.touchcomp.basementorlogger.TLogger;
import cteapplication2.versao300.validacao.exceptions.ValidateException;
import java.io.ByteArrayInputStream;
import javax.swing.JOptionPane;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.TypeInfoProvider;
import javax.xml.validation.ValidatorHandler;
import org.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSModelGroupImpl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.xs.XSAnnotation;
import org.apache.xerces.xs.XSObjectList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class EnvEventoValidate
extends DefaultHandler {
    private static TLogger logger = TLogger.get(EnvEventoValidate.class);
    private TypeInfoProvider provider;
    private XSSimpleTypeDecl currentInfoSimpleElement;
    private XSComplexTypeDecl currentInfoComplexElement;
    private String currentTag;

    public void validarXMLEventoCartaCorrecao(String xml) throws ValidateException {
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = factory.newSchema(this.getClass().getResource("/cteapplication2/versao300/validacao/schemas/evCCeCTe_v3.00.xsd"));
            ValidatorHandler vHandler = schema.newValidatorHandler();
            this.provider = vHandler.getTypeInfoProvider();
            vHandler.setContentHandler(this);
            XMLReader parser = XMLReaderFactory.createXMLReader();
            parser.setContentHandler(vHandler);
            parser.parse(new InputSource(new ByteArrayInputStream(xml.getBytes())));
        }
        catch (SAXException ex) {
            ex.printStackTrace();
            this.trataMensagem(ex);
        }
        catch (Throwable ex) {
            logger.error(ex.getClass(), ex);
            JOptionPane.showMessageDialog(null, "Erro ao validar o arquivo. Sera feita uma tentativa de envio do mesmo, porem pode haver falha na estrutura.");
        }
    }

    public void validarXMLEventoCancelamento(String xml) throws ValidateException {
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = factory.newSchema(this.getClass().getResource("/cteapplication2/versao300/validacao/schemas/evCancCTe_v3.00.xsd"));
            ValidatorHandler vHandler = schema.newValidatorHandler();
            this.provider = vHandler.getTypeInfoProvider();
            vHandler.setContentHandler(this);
            XMLReader parser = XMLReaderFactory.createXMLReader();
            parser.setContentHandler(vHandler);
            parser.parse(new InputSource(new ByteArrayInputStream(xml.getBytes())));
        }
        catch (SAXException ex) {
            ex.printStackTrace();
            this.trataMensagem(ex);
        }
        catch (Throwable ex) {
            logger.error(ex.getClass(), ex);
            JOptionPane.showMessageDialog(null, "Erro ao validar o arquivo. Sera feita uma tentativa de envio do mesmo, porem pode haver falha na estrutura.");
        }
    }

    private void trataMensagem(SAXException ex) throws ValidateException {
        Object msg = "Erro ao validar o XML do lote de notas fiscais. Verifique as seguintes Observa\u00e7\u00f5es nas NFs:\n ";
        if (this.currentInfoComplexElement != null) {
            XSObjectList x = this.currentInfoComplexElement.getAnnotations();
            msg = (String)msg + this.getFormattedAnnotation(x);
            XSParticleDecl part = (XSParticleDecl)this.currentInfoComplexElement.getParticle();
            XSModelGroupImpl modelGroup = (XSModelGroupImpl)part.fValue;
            for (int i = 0; i < modelGroup.fParticles.length; ++i) {
                XSParticleDecl particle = modelGroup.fParticles[i];
                if (particle.getTerm().getName() == null || !particle.getTerm().getName().equalsIgnoreCase(this.currentTag)) continue;
                msg = (String)msg + this.getFormattedAnnotation(particle.getAnnotations());
            }
        }
        throw new ValidateException((String)msg);
    }

    private String getFormattedAnnotation(XSObjectList ann) {
        Object msg = "";
        for (int j = 0; j < ann.getLength(); ++j) {
            msg = (String)msg + this.clearMensagem(((XSAnnotation)ann.item(j)).getAnnotationString());
            msg = (String)msg + "\n";
        }
        return msg;
    }

    private String clearMensagem(String msg) {
        if (msg == null) {
            return "";
        }
        int indexStart = msg.indexOf("<xs:documentation>");
        int indexEnd = msg.indexOf("</xs:documentation>");
        if (indexStart > -1) {
            msg = msg.substring(indexStart + 18, indexEnd);
        }
        return msg;
    }

    @Override
    public void startElement(String namespace, String localName, String qualifiedName, Attributes atts) throws SAXException {
        if (this.provider.getElementTypeInfo() instanceof XSSimpleTypeDecl) {
            this.currentInfoSimpleElement = (XSSimpleTypeDecl)this.provider.getElementTypeInfo();
        } else if (this.provider.getElementTypeInfo() instanceof XSComplexTypeDecl) {
            this.currentInfoComplexElement = (XSComplexTypeDecl)this.provider.getElementTypeInfo();
        }
        this.currentTag = qualifiedName;
        String type = this.provider.getElementTypeInfo().getTypeName();
        System.out.println(qualifiedName + ": " + type);
    }
}

