/*
 * Decompiled with CFR 0.152.
 */
package guiagnre.certificate;

import guiagnre.exception.ExceptionGuiaGnre;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GnreConfSecurity {
    private Provider provider;
    private String senha;
    private String caminhoCertificado;
    private int tipoCertificado;
    private boolean configure = false;
    private String aliasCertificate;
    private static GnreConfSecurity instance;

    public static GnreConfSecurity getInstance() {
        if (instance == null) {
            instance = new GnreConfSecurity();
        }
        return instance;
    }

    public void setSecurity(HashMap parametros) throws ExceptionGuiaGnre {
        if (!this.configure) {
            this.informadoParametros(parametros);
            if ((Integer)parametros.get("tipoCertificado") == 1) {
                this.tipoCertificado = 1;
                Security.addProvider(this.provider);
                System.setProperty("javax.net.ssl.keyStore", "NONE");
                System.setProperty("javax.net.ssl.keyStoreProvider", this.provider.getName());
            } else {
                this.tipoCertificado = 0;
                this.caminhoCertificado = (String)parametros.get("pathFileCFX");
                Security.addProvider(this.provider);
                System.setProperty("javax.net.ssl.keyStore", this.getCaminhoCertificado());
            }
            this.senha = (String)parametros.get("senhaCertificado");
            System.setProperty("javax.net.ssl.keyStoreType", (String)parametros.get("formatoCertificado"));
            System.setProperty("javax.net.ssl.keyStorePassword", this.senha);
            System.setProperty("javax.net.ssl.trustStoreType", "JKS");
            System.setProperty("javax.net.ssl.trustStore", (String)parametros.get("pathFileKeystore"));
            this.configure = true;
        }
    }

    private void informadoParametros(HashMap parametros) throws ExceptionGuiaGnre {
        Integer token = (Integer)parametros.get("tipoCertificado");
        if (token == null) {
            throw new ExceptionGuiaGnre("Informe o tipo de certificado, A1 ou A3. Passe como parametro.");
        }
        String pathKeystore = (String)parametros.get("pathFileKeystore");
        if (pathKeystore == null || pathKeystore.trim().length() == 0 && new File(pathKeystore).exists()) {
            throw new ExceptionGuiaGnre("Informe o caminho do arquivo keystore. O caminho informado pode se referir a um arquivo inexistente.");
        }
        String senha = (String)parametros.get("senhaCertificado");
        if (senha == null || senha.trim().length() == 0) {
            throw new ExceptionGuiaGnre("Informe a senha do certificado.");
        }
        String tipoCertificado = (String)parametros.get("formatoCertificado");
        if (tipoCertificado == null || tipoCertificado.trim().length() == 0) {
            throw new ExceptionGuiaGnre("Informe o tipo de certificado.");
        }
        if (token == 0) {
            String pathPFX = (String)parametros.get("pathFileCFX");
            if (pathPFX == null || pathPFX.trim().length() == 0 && new File(pathPFX).exists()) {
                throw new ExceptionGuiaGnre("Informe o caminho do arquivo PFX. O caminho informado pode se referir a um arquivo inexistente.");
            }
        } else {
            String pathCFGToken = (String)parametros.get("pathFileCfgToken");
            if (pathCFGToken == null || pathCFGToken.trim().length() == 0 && new File(pathCFGToken).exists()) {
                throw new ExceptionGuiaGnre("Informe o caminho do arquivo de configuracao do token. O caminho informado pode se referir a um arquivo inexistente.");
            }
        }
    }

    public Provider getProvider() {
        return this.provider;
    }

    public void setProvider(Provider provider) {
        this.provider = provider;
    }

    public String getSenha() {
        return this.senha;
    }

    public void setSenha(String senha) {
        this.senha = senha;
    }

    public int getTipoCertificado() {
        return this.tipoCertificado;
    }

    public void setTipoCertificado(int tipoCertificado) {
        this.tipoCertificado = tipoCertificado;
    }

    public boolean isConfigure() {
        return this.configure;
    }

    public void setConfigure(boolean configure) {
        this.configure = configure;
    }

    public String getAliasCertificate() {
        return this.aliasCertificate;
    }

    public void setAliasCertificate(String aliasCertificate) {
        this.aliasCertificate = aliasCertificate;
    }

    public String getCaminhoCertificado() {
        return this.caminhoCertificado;
    }

    public void setCaminhoCertificado(String caminhoCertificado) {
        this.caminhoCertificado = caminhoCertificado;
    }

    public Date checarValidadeCertificado() throws ExceptionGuiaGnre {
        try {
            if (this.configure) {
                KeyStore ks;
                GnreConfSecurity se = GnreConfSecurity.getInstance();
                Provider p = se.getProvider();
                if (se.getTipoCertificado() == 1) {
                    ks = KeyStore.getInstance("pkcs11", p);
                    ks.load(null, se.getSenha().toCharArray());
                } else {
                    ks = KeyStore.getInstance("PKCS12");
                    ks.load(new FileInputStream(se.getCaminhoCertificado()), se.getSenha().toCharArray());
                }
                KeyStore.PrivateKeyEntry pkEntry = null;
                Enumeration<String> aliasesEnum = ks.aliases();
                while (aliasesEnum.hasMoreElements()) {
                    String alias = aliasesEnum.nextElement();
                    System.out.println(alias);
                    if (!ks.isKeyEntry(alias)) continue;
                    pkEntry = (KeyStore.PrivateKeyEntry)ks.getEntry(alias, new KeyStore.PasswordProtection(se.getSenha().toCharArray()));
                    break;
                }
                X509Certificate cert = (X509Certificate)pkEntry.getCertificate();
                Date d = cert.getNotAfter();
                return d;
            }
            throw new ExceptionGuiaGnre("Primeiro configure o certificado.");
        }
        catch (UnrecoverableEntryException ex) {
            Logger.getLogger(GnreConfSecurity.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionGuiaGnre("Erro ao descriptografar certificado. ", ex);
        }
        catch (IOException ex) {
            Logger.getLogger(GnreConfSecurity.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionGuiaGnre("Erro Permiss\u00e3o leitura/escrita no certificado. ", ex);
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(GnreConfSecurity.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionGuiaGnre("Nenhum certificado encontrado. ", ex);
        }
        catch (CertificateException ex) {
            Logger.getLogger(GnreConfSecurity.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionGuiaGnre("Erro no certificado. ", ex);
        }
        catch (KeyStoreException ex) {
            Logger.getLogger(GnreConfSecurity.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionGuiaGnre("keystore n\u00e3o encontrado. ", ex);
        }
    }
}

