/*
 * Decompiled with CFR 0.152.
 */
package guiagnre.services;

import guiagnre.certificate.GnreConfSecurity;
import guiagnre.exception.ExceptionGuiaGnre;
import guiagnre.model.TConfigUf;
import guiagnre.model.TConsultaConfigUf;
import guiagnre.services.homologacao.gnreconfiguf.GnreConfigUFStub;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.bind.JAXBException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import utilities.MarshallerUtil;

public class ServiceGnreConsultaConfigUF {
    private String versao = "1.00";

    public EncapsuledMessageRec prepareMessage(TConsultaConfigUf t) throws MalformedURLException, JAXBException, ExceptionGuiaGnre {
        String xml = MarshallerUtil.mashall(t);
        EncapsuledMessageRec e = new EncapsuledMessageRec();
        e.toSend = t;
        e.xmlSend = xml;
        return e;
    }

    public TConfigUf consultaStatusServico(TConsultaConfigUf t) throws MalformedURLException, JAXBException, ExceptionGuiaGnre {
        if (!GnreConfSecurity.getInstance().isConfigure()) {
            throw new ExceptionGuiaGnre("Primeiro, configure o GnreSecurity.");
        }
        String xml = MarshallerUtil.mashall(t);
        String result = this.sendMessage(xml);
        TConfigUf ret = (TConfigUf)MarshallerUtil.umarshall(result, TConfigUf.class);
        return ret;
    }

    private String sendMessage(String xml) throws ExceptionGuiaGnre {
        try {
            GnreConfigUFStub stub = new GnreConfigUFStub();
            GnreConfigUFStub.GnreDadosMsg dados = new GnreConfigUFStub.GnreDadosMsg();
            OMElement el = AXIOMUtil.stringToOM((String)xml);
            dados.setExtraElement(el);
            GnreConfigUFStub.GnreCabecMsg cab = new GnreConfigUFStub.GnreCabecMsg();
            cab.setVersaoDados(this.versao);
            GnreConfigUFStub.GnreRespostaMsg resp = stub.consultar(dados, cab);
            return resp.getExtraElement().toString();
        }
        catch (Exception e) {
            throw new ExceptionGuiaGnre("| Erro: " + e.toString(), e);
        }
    }

    public static class EncapsuledMessageRec {
        private String xmlSend;
        private String xmlReceive;
        private Integer codUf;
        private URL urlToSend;
        private TConsultaConfigUf toSend;
        private TConfigUf toReceive;
        private String msgProcessada;
        private Object auxiliar;

        public String getXmlSend() {
            return this.xmlSend;
        }

        public String getXmlReceive() {
            return this.xmlReceive;
        }

        public Integer getCodUf() {
            return this.codUf;
        }

        public URL getUrlToSend() {
            return this.urlToSend;
        }

        public TConsultaConfigUf getToSend() {
            return this.toSend;
        }

        public TConfigUf getToReceive() {
            return this.toReceive;
        }

        public String getMsgProcessada() {
            return this.msgProcessada;
        }

        public void setMsgProcessada(String msgProcessada) {
            this.msgProcessada = msgProcessada;
        }

        public Object getAuxiliar() {
            return this.auxiliar;
        }

        public void setAuxiliar(Object auxiliar) {
            this.auxiliar = auxiliar;
        }
    }
}

