/*
 * Decompiled with CFR 0.152.
 */
package manifestocteeletronico.services;

import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.bind.JAXBException;
import manifestocteeletronico.exception.ManifestoCteException;
import manifestocteeletronico.model.TConsSitMDFe;
import manifestocteeletronico.model.TRetConsSitMDFe;
import manifestocteeletronico.services.mdfeconsulta.MDFeConsultaStub;
import manifestocteeletronico.util.ManifestoCteFileUtil;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import utilities.MarshallerUtil;

public class ManifestoCteConsulta {
    String versao = "3.00";

    public EncapsuledMessageRec prepareMessage(TConsSitMDFe t, String url, int codUF) throws ManifestoCteException, MalformedURLException, JAXBException {
        URL u = new URL(url);
        String xml = MarshallerUtil.mashall(t);
        EncapsuledMessageRec e = new EncapsuledMessageRec();
        e.codUf = codUF;
        e.toSend = t;
        e.urlToSend = u;
        e.xmlSend = xml;
        return e;
    }

    public void consutaSituacaoMDFe(EncapsuledMessageRec e) throws ManifestoCteException, JAXBException {
        TRetConsSitMDFe ret;
        new ManifestoCteFileUtil().beforeConsManfiesto(e.getXmlSend());
        String result = this.sendMessage(e.getUrlToSend(), e.getXmlSend(), e.getCodUf());
        new ManifestoCteFileUtil().afterConsManifesto(result);
        e.toReceive = ret = (TRetConsSitMDFe)MarshallerUtil.umarshall(result, TRetConsSitMDFe.class);
        e.xmlReceive = result;
    }

    private String sendMessage(URL u, String xml, Integer codUf) throws ManifestoCteException {
        try {
            MDFeConsultaStub stub = new MDFeConsultaStub(u.toString());
            MDFeConsultaStub.MdfeDadosMsg dados = new MDFeConsultaStub.MdfeDadosMsg();
            OMElement el = AXIOMUtil.stringToOM((String)xml);
            dados.setExtraElement(el);
            MDFeConsultaStub.MdfeCabecMsg cab = new MDFeConsultaStub.MdfeCabecMsg();
            cab.setVersaoDados(this.versao);
            cab.setCUF(String.valueOf(codUf));
            MDFeConsultaStub.MdfeCabecMsgE cabE = new MDFeConsultaStub.MdfeCabecMsgE();
            cabE.setMdfeCabecMsg(cab);
            return stub.mdfeConsultaMDF(dados, cabE).getExtraElement().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ManifestoCteException("| WsCTeRecepcao.execute(): " + e.toString(), e);
        }
    }

    public static class EncapsuledMessageRec {
        private String xmlSend;
        private String xmlReceive;
        private Integer codUf;
        private URL urlToSend;
        private TConsSitMDFe toSend;
        private TRetConsSitMDFe toReceive;
        private String msgProcessada;
        private Object auxiliar;

        public String getXmlSend() {
            return this.xmlSend;
        }

        public void setXmlSend(String xmlSend) {
            this.xmlSend = xmlSend;
        }

        public String getXmlReceive() {
            return this.xmlReceive;
        }

        public void setXmlReceive(String xmlReceive) {
            this.xmlReceive = xmlReceive;
        }

        public Integer getCodUf() {
            return this.codUf;
        }

        public void setCodUf(Integer codUf) {
            this.codUf = codUf;
        }

        public URL getUrlToSend() {
            return this.urlToSend;
        }

        public void setUrlToSend(URL urlToSend) {
            this.urlToSend = urlToSend;
        }

        public TConsSitMDFe getToSend() {
            return this.toSend;
        }

        public void setToSend(TConsSitMDFe toSend) {
            this.toSend = toSend;
        }

        public TRetConsSitMDFe getToReceive() {
            return this.toReceive;
        }

        public void setToReceive(TRetConsSitMDFe toReceive) {
            this.toReceive = toReceive;
        }

        public String getMsgProcessada() {
            return this.msgProcessada;
        }

        public void setMsgProcessada(String msgProcessada) {
            this.msgProcessada = msgProcessada;
        }

        public Object getAuxiliar() {
            return this.auxiliar;
        }

        public void setAuxiliar(Object auxiliar) {
            this.auxiliar = auxiliar;
        }
    }
}

