/*
 * Decompiled with CFR 0.152.
 */
package manifestocteeletronico.services;

import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.bind.JAXBException;
import manifestocteeletronico.certificate.ManifestoCteSignature;
import manifestocteeletronico.exception.ManifestoCteException;
import manifestocteeletronico.model.TEnviMDFe;
import manifestocteeletronico.model.TMDFe;
import manifestocteeletronico.model.TRetEnviMDFe;
import manifestocteeletronico.services.mdferecepcao.MDFeRecepcaoStub;
import manifestocteeletronico.util.ManifestoCteFileUtil;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import utilities.MarshallerUtil;

public class ManifestoCteRecepcao {
    private String versao = "3.00";

    public EncapsuledMessageRec prepareMessage(TEnviMDFe t, String url, int codUf, String chave) throws MalformedURLException, JAXBException, ManifestoCteException {
        URL u = null;
        if (url != null && url.trim().length() > 0) {
            u = new URL(url);
        }
        String xml = MarshallerUtil.mashall(t);
        xml = xml.replaceAll(" xmlns:ns2=\"http://www.w3.org/2000/09/xmldsig#\"", "");
        try {
            xml = new ManifestoCteSignature().assinarXMLMDFe(xml);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ManifestoCteException("Erro ao assinar o arquivo XML. Verifique seu certificado.", ex);
        }
        EncapsuledMessageRec e = new EncapsuledMessageRec();
        e.codUf = codUf;
        e.toSend = t;
        e.urlToSend = u;
        e.xmlSend = xml;
        return e;
    }

    public void recepcaoLote(EncapsuledMessageRec e) throws ManifestoCteException, JAXBException {
        TRetEnviMDFe ret;
        new ManifestoCteFileUtil().beforeSendLoteManifestoCTe(e.getXmlSend(), e.getToSend().getIdLote());
        String result = this.sendMessage(e.getUrlToSend(), e.getXmlSend(), e.getCodUf());
        new ManifestoCteFileUtil().afterSendLoteManifestoCte(result, e.getToSend().getIdLote());
        e.toReceive = ret = (TRetEnviMDFe)MarshallerUtil.umarshall(result, TRetEnviMDFe.class);
        e.xmlReceive = result;
    }

    private String sendMessage(URL u, String xml, Integer codUf) throws ManifestoCteException {
        try {
            MDFeRecepcaoStub stub = new MDFeRecepcaoStub(u.toString());
            MDFeRecepcaoStub.MdfeDadosMsg dados = new MDFeRecepcaoStub.MdfeDadosMsg();
            OMElement el = AXIOMUtil.stringToOM((String)xml);
            dados.setExtraElement(el);
            MDFeRecepcaoStub.MdfeCabecMsg cab = new MDFeRecepcaoStub.MdfeCabecMsg();
            cab.setVersaoDados(this.versao);
            cab.setCUF(String.valueOf(codUf));
            System.out.println("Enviando aqui o lote");
            MDFeRecepcaoStub.MdfeCabecMsgE cabE = new MDFeRecepcaoStub.MdfeCabecMsgE();
            cabE.setMdfeCabecMsg(cab);
            return stub.mdfeRecepcaoLote(dados, cabE).getExtraElement().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ManifestoCteException("| WsManifestoCTeRecepcao.execute(): " + e.toString(), e);
        }
    }

    public String gerarXMLSemValidade(TEnviMDFe t) throws ManifestoCteException, JAXBException {
        String xml = MarshallerUtil.mashall(t);
        try {
            xml = new ManifestoCteSignature().assinarXMLMDFe(xml);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ManifestoCteException("Erro ao assinar o arquivo XML. Verifique seu certificado.");
        }
        return xml;
    }

    public String gerarXMLSemValidade(TMDFe t) throws ManifestoCteException, JAXBException {
        String xml = MarshallerUtil.mashall(t);
        try {
            xml = new ManifestoCteSignature().assinarXMLMDFe(xml);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ManifestoCteException("Erro ao assinar o arquivo XML. Verifique seu certificado.");
        }
        return xml;
    }

    public static class EncapsuledMessageRec {
        private String xmlSend;
        private String xmlReceive;
        private Integer codUf;
        private URL urlToSend;
        private TEnviMDFe toSend;
        private TRetEnviMDFe toReceive;
        private String msgProcesada;
        private Object auxiliar;

        public String getXmlSend() {
            return this.xmlSend;
        }

        public void setXmlSend(String xmlSend) {
            this.xmlSend = xmlSend;
        }

        public String getXmlReceive() {
            return this.xmlReceive;
        }

        public void setXmlReceive(String xmlReceive) {
            this.xmlReceive = xmlReceive;
        }

        public Integer getCodUf() {
            return this.codUf;
        }

        public void setCodUf(Integer codUf) {
            this.codUf = codUf;
        }

        public URL getUrlToSend() {
            return this.urlToSend;
        }

        public void setUrlToSend(URL urlToSend) {
            this.urlToSend = urlToSend;
        }

        public String getMsgProcesada() {
            return this.msgProcesada;
        }

        public void setMsgProcesada(String msgProcesada) {
            this.msgProcesada = msgProcesada;
        }

        public Object getAuxiliar() {
            return this.auxiliar;
        }

        public void setAuxiliar(Object auxiliar) {
            this.auxiliar = auxiliar;
        }

        public TEnviMDFe getToSend() {
            return this.toSend;
        }

        public void setToSend(TEnviMDFe toSend) {
            this.toSend = toSend;
        }

        public TRetEnviMDFe getToReceive() {
            return this.toReceive;
        }

        public void setToReceive(TRetEnviMDFe toReceive) {
            this.toReceive = toReceive;
        }
    }
}

