/*
 * Decompiled with CFR 0.152.
 */
package manifestocteeletronico.services;

import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.bind.JAXBException;
import manifestocteeletronico.certificate.ManifestoCteSignature;
import manifestocteeletronico.exception.ManifestoCteException;
import manifestocteeletronico.model.TEvento;
import manifestocteeletronico.model.TRetEvento;
import manifestocteeletronico.services.mdferecepcaoevento.MDFeRecepcaoEventoStub;
import manifestocteeletronico.util.ManifestoCteFileUtil;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import utilities.MarshallerUtil;

public class ManifestoCteRecepcaoEventos {
    public static final String VERSAO = "3.00";

    public EncapsuledMessageRec prepareMessage(TEvento t, String url, int codUF) throws ManifestoCteException, MalformedURLException, JAXBException {
        URL u = new URL(url);
        String xml = MarshallerUtil.mashall(t);
        try {
            xml = new ManifestoCteSignature().assinarXMLEventoMDFe(xml);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ManifestoCteException("Erro ao assinar o arquivo XML. Verifique seu ");
        }
        EncapsuledMessageRec e = new EncapsuledMessageRec();
        e.codUf = codUF;
        e.toSend = t;
        e.urlToSend = u;
        e.xmlSend = xml;
        return e;
    }

    public void recepcaoLoteEventos(EncapsuledMessageRec e, Long id) throws ManifestoCteException, JAXBException {
        TRetEvento ret;
        new ManifestoCteFileUtil().beforeSendLoteEventosManifestoCte(e.getXmlSend(), id.toString());
        String result = this.sendMessage(e.getUrlToSend(), e.getXmlSend(), e.getCodUf());
        new ManifestoCteFileUtil().afterSendLoteEventosManifestoCte(result, id.toString());
        e.toReceive = ret = (TRetEvento)MarshallerUtil.umarshall(result, TRetEvento.class);
        e.xmlReceive = result;
    }

    private String sendMessage(URL u, String xml, Integer codUf) throws ManifestoCteException {
        try {
            MDFeRecepcaoEventoStub stub = new MDFeRecepcaoEventoStub(u.toString());
            MDFeRecepcaoEventoStub.MdfeDadosMsg dados = new MDFeRecepcaoEventoStub.MdfeDadosMsg();
            OMElement el = AXIOMUtil.stringToOM((String)xml);
            dados.setExtraElement(el);
            MDFeRecepcaoEventoStub.MdfeCabecMsg cab = new MDFeRecepcaoEventoStub.MdfeCabecMsg();
            cab.setVersaoDados(VERSAO);
            cab.setCUF(String.valueOf(codUf));
            System.out.println("Enviando aqui o lote");
            MDFeRecepcaoEventoStub.MdfeCabecMsgE cabE = new MDFeRecepcaoEventoStub.MdfeCabecMsgE();
            cabE.setMdfeCabecMsg(cab);
            return stub.mdfeRecepcaoEvento(dados, cabE).getExtraElement().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ManifestoCteException("| WsManifestoCTeRecepcao.execute(): " + e.toString(), e);
        }
    }

    public static class EncapsuledMessageRec {
        private String xmlSend;
        private String xmlReceive;
        private Integer codUf;
        private URL urlToSend;
        private TEvento toSend;
        private TRetEvento toReceive;
        private String msgProcesada;
        private Object auxiliar;

        public String getXmlSend() {
            return this.xmlSend;
        }

        public void setXmlSend(String xmlSend) {
            this.xmlSend = xmlSend;
        }

        public String getXmlReceive() {
            return this.xmlReceive;
        }

        public void setXmlReceive(String xmlReceive) {
            this.xmlReceive = xmlReceive;
        }

        public Integer getCodUf() {
            return this.codUf;
        }

        public void setCodUf(Integer codUf) {
            this.codUf = codUf;
        }

        public URL getUrlToSend() {
            return this.urlToSend;
        }

        public void setUrlToSend(URL urlToSend) {
            this.urlToSend = urlToSend;
        }

        public TEvento getToSend() {
            return this.toSend;
        }

        public void setToSend(TEvento toSend) {
            this.toSend = toSend;
        }

        public TRetEvento getToReceive() {
            return this.toReceive;
        }

        public void setToReceive(TRetEvento toReceive) {
            this.toReceive = toReceive;
        }

        public String getMsgProcesada() {
            return this.msgProcesada;
        }

        public void setMsgProcesada(String msgProcesada) {
            this.msgProcesada = msgProcesada;
        }

        public Object getAuxiliar() {
            return this.auxiliar;
        }

        public void setAuxiliar(Object auxiliar) {
            this.auxiliar = auxiliar;
        }
    }
}

