/*
 * Decompiled with CFR 0.152.
 */
package manifestocteeletronico.services;

import com.touchcomp.basementorexceptions.exceptions.impl.jaxb.ExceptionJaxb;
import com.touchcomp.basementortools.tools.jaxb.ToolJaxb;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.rmi.RemoteException;
import java.util.Base64;
import java.util.zip.GZIPOutputStream;
import lombok.Generated;
import manifestocteeletronico.certificate.ManifestoCteSignature;
import manifestocteeletronico.exception.ManifestoCteException;
import manifestocteeletronico.model.TMDFe;
import manifestocteeletronico.model.TRetMDFe;
import manifestocteeletronico.services.mdferecepcaosinc.MDFeRecepcaoSincStub;
import manifestocteeletronico.util.ManifestoCteFileUtil;

public class ManifestoCteRecepcaoSinc {
    public static EncapsuledMessageRec prepareMessage(TMDFe tMdfe, String url) throws ManifestoCteException {
        try {
            EncapsuledMessageRec encapsuledMessageRec = new EncapsuledMessageRec();
            encapsuledMessageRec.setUrlToSend(url);
            encapsuledMessageRec.setXmlSend(ManifestoCteRecepcaoSinc.getXmlSend(tMdfe));
            encapsuledMessageRec.setToSend(tMdfe);
            return encapsuledMessageRec;
        }
        catch (ExceptionJaxb ex) {
            throw new ManifestoCteException("Erro ao converter o objeto para XML.", ex);
        }
        catch (Exception ex) {
            throw new ManifestoCteException("Erro ao assinar o arquivo XML. Verifique seu certificado.", ex);
        }
    }

    private static String getXmlSend(TMDFe tMdfe) throws Exception {
        String xml = ToolJaxb.toXMl((Object)tMdfe);
        return new ManifestoCteSignature().assinarXMLMDFe(xml);
    }

    public static void recepcaoSinc(EncapsuledMessageRec e) throws ManifestoCteException {
        try {
            new ManifestoCteFileUtil().beforeSendLoteManifestoCTe(e.getXmlSend(), e.getToSend().getInfMDFe().getIde().getNMDF());
            String result = ManifestoCteRecepcaoSinc.sendMessage(e.getUrlToSend(), e.getXmlSend());
            new ManifestoCteFileUtil().afterSendLoteManifestoCte(result, e.getToSend().getInfMDFe().getIde().getNMDF());
            TRetMDFe tRetMdfe = (TRetMDFe)ToolJaxb.toObject((String)result, TRetMDFe.class);
            e.setXmlReceive(result);
            e.setToReceive(tRetMdfe);
        }
        catch (ExceptionJaxb | IOException ex) {
            throw new ManifestoCteException("Erro ao converter o objeto para XML.", ex);
        }
    }

    private static String sendMessage(String urlToSend, String xmlSend) throws ManifestoCteException, IOException {
        try {
            MDFeRecepcaoSincStub stub = new MDFeRecepcaoSincStub(urlToSend);
            MDFeRecepcaoSincStub.MdfeDadosMsg dados = new MDFeRecepcaoSincStub.MdfeDadosMsg();
            dados.setMdfeDadosMsg(ManifestoCteRecepcaoSinc.codeXml(xmlSend));
            return stub.mdfeRecepcao(dados).getExtraElement().toString();
        }
        catch (RemoteException ex) {
            throw new ManifestoCteException("| WsManifestoCTeRecepcao.execute(): " + ex.toString(), ex);
        }
    }

    private static String codeXml(String xml) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);){
                gzipOutputStream.write(xml.getBytes(StandardCharsets.UTF_8));
            }
            String string = Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray());
            return string;
        }
    }

    public static class EncapsuledMessageRec {
        private String urlToSend;
        private String xmlSend;
        private TMDFe toSend;
        private String xmlReceive;
        private TRetMDFe toReceive;
        private String msgProcessada;
        private Object auxiliar;

        @Generated
        public EncapsuledMessageRec() {
        }

        @Generated
        public String getUrlToSend() {
            return this.urlToSend;
        }

        @Generated
        public String getXmlSend() {
            return this.xmlSend;
        }

        @Generated
        public TMDFe getToSend() {
            return this.toSend;
        }

        @Generated
        public String getXmlReceive() {
            return this.xmlReceive;
        }

        @Generated
        public TRetMDFe getToReceive() {
            return this.toReceive;
        }

        @Generated
        public String getMsgProcessada() {
            return this.msgProcessada;
        }

        @Generated
        public Object getAuxiliar() {
            return this.auxiliar;
        }

        @Generated
        public void setUrlToSend(String urlToSend) {
            this.urlToSend = urlToSend;
        }

        @Generated
        public void setXmlSend(String xmlSend) {
            this.xmlSend = xmlSend;
        }

        @Generated
        public void setToSend(TMDFe toSend) {
            this.toSend = toSend;
        }

        @Generated
        public void setXmlReceive(String xmlReceive) {
            this.xmlReceive = xmlReceive;
        }

        @Generated
        public void setToReceive(TRetMDFe toReceive) {
            this.toReceive = toReceive;
        }

        @Generated
        public void setMsgProcessada(String msgProcessada) {
            this.msgProcessada = msgProcessada;
        }

        @Generated
        public void setAuxiliar(Object auxiliar) {
            this.auxiliar = auxiliar;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EncapsuledMessageRec)) {
                return false;
            }
            EncapsuledMessageRec other = (EncapsuledMessageRec)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$urlToSend = this.getUrlToSend();
            String other$urlToSend = other.getUrlToSend();
            if (this$urlToSend == null ? other$urlToSend != null : !this$urlToSend.equals(other$urlToSend)) {
                return false;
            }
            String this$xmlSend = this.getXmlSend();
            String other$xmlSend = other.getXmlSend();
            if (this$xmlSend == null ? other$xmlSend != null : !this$xmlSend.equals(other$xmlSend)) {
                return false;
            }
            TMDFe this$toSend = this.getToSend();
            TMDFe other$toSend = other.getToSend();
            if (this$toSend == null ? other$toSend != null : !this$toSend.equals(other$toSend)) {
                return false;
            }
            String this$xmlReceive = this.getXmlReceive();
            String other$xmlReceive = other.getXmlReceive();
            if (this$xmlReceive == null ? other$xmlReceive != null : !this$xmlReceive.equals(other$xmlReceive)) {
                return false;
            }
            TRetMDFe this$toReceive = this.getToReceive();
            TRetMDFe other$toReceive = other.getToReceive();
            if (this$toReceive == null ? other$toReceive != null : !this$toReceive.equals(other$toReceive)) {
                return false;
            }
            String this$msgProcessada = this.getMsgProcessada();
            String other$msgProcessada = other.getMsgProcessada();
            if (this$msgProcessada == null ? other$msgProcessada != null : !this$msgProcessada.equals(other$msgProcessada)) {
                return false;
            }
            Object this$auxiliar = this.getAuxiliar();
            Object other$auxiliar = other.getAuxiliar();
            return !(this$auxiliar == null ? other$auxiliar != null : !this$auxiliar.equals(other$auxiliar));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof EncapsuledMessageRec;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $urlToSend = this.getUrlToSend();
            result = result * 59 + ($urlToSend == null ? 43 : $urlToSend.hashCode());
            String $xmlSend = this.getXmlSend();
            result = result * 59 + ($xmlSend == null ? 43 : $xmlSend.hashCode());
            TMDFe $toSend = this.getToSend();
            result = result * 59 + ($toSend == null ? 43 : $toSend.hashCode());
            String $xmlReceive = this.getXmlReceive();
            result = result * 59 + ($xmlReceive == null ? 43 : $xmlReceive.hashCode());
            TRetMDFe $toReceive = this.getToReceive();
            result = result * 59 + ($toReceive == null ? 43 : $toReceive.hashCode());
            String $msgProcessada = this.getMsgProcessada();
            result = result * 59 + ($msgProcessada == null ? 43 : $msgProcessada.hashCode());
            Object $auxiliar = this.getAuxiliar();
            result = result * 59 + ($auxiliar == null ? 43 : $auxiliar.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ManifestoCteRecepcaoSinc.EncapsuledMessageRec(urlToSend=" + this.getUrlToSend() + ", xmlSend=" + this.getXmlSend() + ", toSend=" + String.valueOf(this.getToSend()) + ", xmlReceive=" + this.getXmlReceive() + ", toReceive=" + String.valueOf(this.getToReceive()) + ", msgProcessada=" + this.getMsgProcessada() + ", auxiliar=" + String.valueOf(this.getAuxiliar()) + ")";
        }
    }
}

