/*
 * Decompiled with CFR 0.152.
 */
package manifestocteeletronico.services;

import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.bind.JAXBException;
import manifestocteeletronico.exception.ManifestoCteException;
import manifestocteeletronico.model.TConsReciMDFe;
import manifestocteeletronico.model.TRetConsReciMDFe;
import manifestocteeletronico.services.mdferetrecepcao.MDFeRetRecepcaoStub;
import manifestocteeletronico.util.ManifestoCteFileUtil;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import utilities.MarshallerUtil;

public class ManifestoCteRetRecepcaoLote {
    private String versao = "3.00";

    public EncapsuledMessageRec prepareMessage(TConsReciMDFe t, String url, int codUF) throws ManifestoCteException, MalformedURLException, JAXBException {
        URL u = new URL(url);
        String xml = MarshallerUtil.mashall(t);
        EncapsuledMessageRec e = new EncapsuledMessageRec();
        e.codUf = codUF;
        e.toSend = t;
        e.urlToSend = u;
        e.xmlSend = xml;
        return e;
    }

    public void consultaRecepcaoLote(EncapsuledMessageRec e) throws ManifestoCteException, JAXBException {
        TRetConsReciMDFe ret;
        new ManifestoCteFileUtil().beforeConsRetRecepcaoLoteNFe(e.getXmlSend());
        String result = this.sendMessage(e.getUrlToSend(), e.getXmlSend(), e.getCodUf());
        new ManifestoCteFileUtil().afterConsRetRecepcaoLoteNFe(result);
        e.toReceive = ret = (TRetConsReciMDFe)MarshallerUtil.umarshall(result, TRetConsReciMDFe.class);
        e.xmlReceive = result;
    }

    private String sendMessage(URL u, String xml, Integer codUf) throws ManifestoCteException {
        try {
            MDFeRetRecepcaoStub stub = new MDFeRetRecepcaoStub(u.toString());
            MDFeRetRecepcaoStub.MdfeDadosMsg dados = new MDFeRetRecepcaoStub.MdfeDadosMsg();
            OMElement el = AXIOMUtil.stringToOM((String)xml);
            dados.setExtraElement(el);
            MDFeRetRecepcaoStub.MdfeCabecMsg cab = new MDFeRetRecepcaoStub.MdfeCabecMsg();
            cab.setVersaoDados(this.versao);
            cab.setCUF(String.valueOf(codUf));
            MDFeRetRecepcaoStub.MdfeCabecMsgE cabE = new MDFeRetRecepcaoStub.MdfeCabecMsgE();
            cabE.setMdfeCabecMsg(cab);
            return stub.mdfeRetRecepcao(dados, cabE).getExtraElement().toString();
        }
        catch (Exception e) {
            throw new ManifestoCteException("| WsManifestoCTeRecepcao.execute(): " + e.toString(), e);
        }
    }

    public static class EncapsuledMessageRec {
        private String xmlSend;
        private String xmlReceive;
        private Integer codUf;
        private URL urlToSend;
        private TConsReciMDFe toSend;
        private TRetConsReciMDFe toReceive;
        private String msgProcesada;
        private Object auxiliar;

        public String getXmlSend() {
            return this.xmlSend;
        }

        public void setXmlSend(String xmlSend) {
            this.xmlSend = xmlSend;
        }

        public String getXmlReceive() {
            return this.xmlReceive;
        }

        public void setXmlReceive(String xmlReceive) {
            this.xmlReceive = xmlReceive;
        }

        public Integer getCodUf() {
            return this.codUf;
        }

        public void setCodUf(Integer codUf) {
            this.codUf = codUf;
        }

        public URL getUrlToSend() {
            return this.urlToSend;
        }

        public void setUrlToSend(URL urlToSend) {
            this.urlToSend = urlToSend;
        }

        public TConsReciMDFe getToSend() {
            return this.toSend;
        }

        public void setToSend(TConsReciMDFe toSend) {
            this.toSend = toSend;
        }

        public TRetConsReciMDFe getToReceive() {
            return this.toReceive;
        }

        public void setToReceive(TRetConsReciMDFe toReceive) {
            this.toReceive = toReceive;
        }

        public String getMsgProcesada() {
            return this.msgProcesada;
        }

        public void setMsgProcesada(String msgProcesada) {
            this.msgProcesada = msgProcesada;
        }

        public Object getAuxiliar() {
            return this.auxiliar;
        }

        public void setAuxiliar(Object auxiliar) {
            this.auxiliar = auxiliar;
        }
    }
}

