/*
 * Decompiled with CFR 0.152.
 */
package manifestocteeletronico.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import manifestocteeletronico.exception.ManifestoCteException;

public class ManifestoCteFileUtil {
    private String getPathLoteMDFeEnv() {
        return System.getProperty("user.dir") + "/versao100/manifesto_lote_fat/";
    }

    private String getPathConsMDFe() {
        return System.getProperty("user.dir") + "/versao100/manifesto_cons/";
    }

    private String getPathEvtMDFe() {
        return System.getProperty("user.dir") + "/versao100/manifesto_evt/";
    }

    private String dateToString(Date date, String format) {
        SimpleDateFormat simple = new SimpleDateFormat(format);
        return simple.format(date);
    }

    private void writeInFileResult(String xml, String file) throws FileNotFoundException {
        File f = new File(file);
        f.getParentFile().mkdirs();
        PrintWriter p = new PrintWriter(f);
        p.write(xml);
        p.flush();
        p.close();
    }

    public void beforeSendLoteManifestoCTe(String texto, String idLote) throws ManifestoCteException {
        try {
            this.writeInFileResult(texto, this.getPathLoteMDFeEnv() + idLote + "-env-lot.xml");
        }
        catch (FileNotFoundException ex) {
            throw new ManifestoCteException("Nao foi poss\u00edvel escrever o arquivo/backup de envio de mdfe.", ex);
        }
    }

    public void afterSendLoteManifestoCte(String texto, String idLote) throws ManifestoCteException {
        try {
            this.writeInFileResult(texto, this.getPathLoteMDFeEnv() + idLote + "-rec.xml");
        }
        catch (FileNotFoundException ex) {
            throw new ManifestoCteException("Nao foi poss\u00edvel escrever o arquivo/backup de envio de mdfe.", ex);
        }
    }

    public void beforeConsRetRecepcaoLoteNFe(String texto) throws ManifestoCteException {
        try {
            this.writeInFileResult(texto, this.getPathLoteMDFeEnv() + this.dateToString(new Date(), "yyyyMMdd") + "T" + this.dateToString(new Date(), "hhmmss") + "-ped-sit-lot.xml");
        }
        catch (FileNotFoundException ex) {
            throw new ManifestoCteException("Nao foi poss\u00edvel escrever o arquivo/backup de envio de mdfe.", ex);
        }
    }

    public void afterConsRetRecepcaoLoteNFe(String texto) throws ManifestoCteException {
        try {
            this.writeInFileResult(texto, this.getPathLoteMDFeEnv() + this.dateToString(new Date(), "yyyyMMdd") + "T" + this.dateToString(new Date(), "hhmmss") + "-sit-lot.xml");
        }
        catch (FileNotFoundException ex) {
            throw new ManifestoCteException("Nao foi poss\u00edvel escrever o arquivo/backup de envio de mdfe.", ex);
        }
    }

    public void beforeConsManfiesto(String texto) throws ManifestoCteException {
        try {
            this.writeInFileResult(texto, this.getPathConsMDFe() + this.dateToString(new Date(), "yyyyMMdd") + "T" + this.dateToString(new Date(), "hhmmss") + "-ped-cons-sefaz.xml");
        }
        catch (FileNotFoundException ex) {
            throw new ManifestoCteException("Nao foi poss\u00edvel escrever o arquivo/backup de envio de mdfe.", ex);
        }
    }

    public void afterConsManifesto(String texto) throws ManifestoCteException {
        try {
            this.writeInFileResult(texto, this.getPathConsMDFe() + this.dateToString(new Date(), "yyyyMMdd") + "T" + this.dateToString(new Date(), "hhmmss") + "-sit-cons-sefaz.xml");
        }
        catch (FileNotFoundException ex) {
            throw new ManifestoCteException("Nao foi poss\u00edvel escrever o arquivo/backup de envio de mdfe.", ex);
        }
    }

    public void beforeSendLoteEventosManifestoCte(String texto, String idLote) throws ManifestoCteException {
        try {
            this.writeInFileResult(texto, this.getPathEvtMDFe() + idLote + "-env-lot-evt.xml");
        }
        catch (FileNotFoundException ex) {
            throw new ManifestoCteException("Nao foi poss\u00edvel escrever o arquivo/backup de envio de mdfe.", ex);
        }
    }

    public void afterSendLoteEventosManifestoCte(String texto, String idLote) throws ManifestoCteException {
        try {
            this.writeInFileResult(texto, this.getPathEvtMDFe() + idLote + "-ret-lot-evt.xml");
        }
        catch (FileNotFoundException ex) {
            throw new ManifestoCteException("N\u00e3o foi poss\u00edvel escrever o arquivo/backup de envio de mdfe.", ex);
        }
    }
}

