/*
 * Decompiled with CFR 0.152.
 */
package nfe.certificate;

import com.touchcomp.basementorclientwebservices.certificado.CertificadoConfClienteWebservice;
import com.touchcomp.basementorclientwebservices.constants.EnumTipoCertificado;
import com.touchcomp.basementorexceptions.exceptions.impl.certificado.ExceptionCertificado;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Signature;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DFAssinaturaDigital {
    private static final String C14N_TRANSFORM_METHOD = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    private static final String[] ELEMENTOS_ASSINAVEIS = new String[]{"infEvento", "infCanc", "infNFe", "infInut", "infMDFe", "infCte"};

    public boolean isValida(InputStream xmlStream) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        Document document = dbf.newDocumentBuilder().parse(xmlStream);
        NodeList nodeList = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nodeList.getLength() == 0) {
            throw new IllegalStateException("Nao foi encontrada a assinatura do XML.");
        }
        String providerName = System.getProperty("jsr105Provider", "org.jcp.xml.dsig.internal.dom.XMLDSigRI");
        XMLSignatureFactory signatureFactory = XMLSignatureFactory.getInstance("DOM", (Provider)Class.forName(providerName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        DOMValidateContext validateContext = new DOMValidateContext(new DFKeySelector(), nodeList.item(0));
        for (String tag : ELEMENTOS_ASSINAVEIS) {
            NodeList elements = document.getElementsByTagName(tag);
            if (elements.getLength() <= 0) continue;
            validateContext.setIdAttributeNS((Element)elements.item(0), null, "Id");
        }
        return signatureFactory.unmarshalXMLSignature(validateContext).validate(validateContext);
    }

    public String assinarDocumento(String conteudoXml) throws Exception {
        return this.assinarDocumento(conteudoXml, ELEMENTOS_ASSINAVEIS);
    }

    public String assinarDocumento(String conteudoXml, String ... elementosAssinaveis) throws Exception {
        try (StringReader reader = new StringReader(conteudoXml);){
            String string;
            try (StringWriter writer = new StringWriter();){
                this.assinarDocumento(reader, writer, elementosAssinaveis);
                string = writer.toString();
            }
            return string;
        }
    }

    public void assinarDocumento(Reader xmlReader, Writer xmlAssinado, String ... elementosAssinaveis) throws Exception {
        KeyStore.PrivateKeyEntry keyEntry = this.getPrivateKeyEntry();
        XMLSignatureFactory signatureFactory = XMLSignatureFactory.getInstance("DOM");
        ArrayList<Transform> transforms = new ArrayList<Transform>(2);
        transforms.add(signatureFactory.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null));
        transforms.add(signatureFactory.newTransform(C14N_TRANSFORM_METHOD, (TransformParameterSpec)null));
        KeyInfoFactory keyInfoFactory = signatureFactory.getKeyInfoFactory();
        X509Data x509Data = keyInfoFactory.newX509Data(Collections.singletonList((X509Certificate)keyEntry.getCertificate()));
        KeyInfo keyInfo = keyInfoFactory.newKeyInfo(Collections.singletonList(x509Data));
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        Document document = documentBuilderFactory.newDocumentBuilder().parse(new InputSource(xmlReader));
        for (String elementoAssinavel : elementosAssinaveis) {
            NodeList elements = document.getElementsByTagName(elementoAssinavel);
            for (int i = 0; i < elements.getLength(); ++i) {
                Element element = (Element)elements.item(i);
                String id = element.getAttribute("Id");
                element.setIdAttribute("Id", true);
                Reference reference = signatureFactory.newReference("#" + id, signatureFactory.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), transforms, null, null);
                SignedInfo signedInfo = signatureFactory.newSignedInfo(signatureFactory.newCanonicalizationMethod(C14N_TRANSFORM_METHOD, (C14NMethodParameterSpec)null), signatureFactory.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null), Collections.singletonList(reference));
                XMLSignature signature = signatureFactory.newXMLSignature(signedInfo, keyInfo);
                signature.sign(new DOMSignContext(keyEntry.getPrivateKey(), element.getParentNode()));
            }
        }
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.transform(new DOMSource(document), new StreamResult(xmlAssinado));
    }

    private KeyStore.PrivateKeyEntry getPrivateKeyEntry() throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException, IOException, CertificateException, ExceptionCertificado {
        KeyStore ks;
        CertificadoConfClienteWebservice config = CertificadoConfClienteWebservice.getConfiguracaoCertificado();
        if (ToolMethods.isEquals((Object)config.getParams().getTipoCertificado(), (Object)EnumTipoCertificado.CERTIFICADO_A3)) {
            ks = KeyStore.getInstance("pkcs11", config.getProvider());
            ks.load(null, config.getParams().getSenhaCertificado().toCharArray());
        } else {
            ks = KeyStore.getInstance("PKCS12");
            ks.load(new FileInputStream(this.getCaminhoCertificado(config.getParams().getPathCertificadoA1())), config.getParams().getSenhaCertificado().toCharArray());
        }
        String certificateAlias = config.getParams().getAliasCertificado() != null ? config.getParams().getAliasCertificado() : ks.aliases().nextElement();
        System.out.println("\n\n\nAliases Certificado: " + certificateAlias);
        KeyStore.PasswordProtection passwordProtection = new KeyStore.PasswordProtection(config.getParams().getSenhaCertificado().toCharArray());
        return (KeyStore.PrivateKeyEntry)ks.getEntry(certificateAlias, passwordProtection);
    }

    public String assinarString(String _string) throws Exception {
        byte[] buffer = _string.getBytes();
        Signature signatureProvider = Signature.getInstance("SHA1withRSA");
        signatureProvider.initSign(this.getPrivateKeyEntry().getPrivateKey());
        signatureProvider.update(buffer, 0, buffer.length);
        byte[] signature = signatureProvider.sign();
        System.out.println(this.getPrivateKeyEntry().getPrivateKey().getFormat());
        return Base64.getEncoder().encodeToString(signature);
    }

    private String getCaminhoCertificado(byte[] pathCertificadoA1) throws IOException {
        String pathFile = null;
        if (pathCertificadoA1 != null) {
            pathFile = this.getPathFile(pathCertificadoA1, "certificado.pfx");
        }
        return pathFile;
    }

    private String getPathFile(byte[] arquivoPFX, String string) throws FileNotFoundException, IOException {
        Object dir = System.getProperty("user.dir");
        dir = (String)dir + "/";
        File f = new File((String)dir + string);
        FileOutputStream out = new FileOutputStream(f);
        out.write(arquivoPFX);
        out.flush();
        out.close();
        return f.getAbsolutePath();
    }

    static class DFKeySelector
    extends KeySelector {
        DFKeySelector() {
        }

        @Override
        public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod method, XMLCryptoContext context) throws KeySelectorException {
            for (XMLStructure object : keyInfo.getContent()) {
                XMLStructure info = object;
                if (!(info instanceof X509Data)) continue;
                X509Data x509Data = (X509Data)info;
                for (Object certificado : x509Data.getContent()) {
                    if (!(certificado instanceof X509Certificate)) continue;
                    X509Certificate x509Certificate = (X509Certificate)certificado;
                    if (!this.algEquals(method.getAlgorithm(), x509Certificate.getPublicKey().getAlgorithm())) continue;
                    return (KeySelectorResult)((Object)x509Certificate.getPublicKey());
                }
            }
            throw new KeySelectorException("Nao foi localizada a chave do certificado.");
        }

        private boolean algEquals(String algURI, String algName) {
            return algName.equalsIgnoreCase("DSA") && algURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#dsa-sha1") || algName.equalsIgnoreCase("RSA") && algURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        }
    }
}

