/*
 * Decompiled with CFR 0.152.
 */
package nfe.versao400.services;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import nfe.certificate.NFeSignature;
import nfe.exception.NFeException;
import nfe.exception.NFeValidateException;
import nfe.util.NFeFileUtil;
import nfe.versao400.model.TInutNFe;
import nfe.versao400.model.TRetInutNFe;
import nfe.versao400.services.nfeinutilizacao4.NFeInutilizacao4Stub;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import utilities.MarshallerUtil;

public class NFeInutilizacao {
    public static String versao = "4.00";

    public void inutilizacaoNFe(EncapsuledMessageRec e) throws MalformedURLException, JAXBException, NFeException, NFeValidateException {
        TRetInutNFe ret;
        new NFeFileUtil().beforeinutilizaNFe(e.getXmlSend());
        String result = this.sendMessage(e.getUrlToSend(), e.getXmlSend(), e.getCodUf());
        new NFeFileUtil().afterInutilizaNFe(result);
        e.toReceive = ret = (TRetInutNFe)MarshallerUtil.umarshall(result, TRetInutNFe.class);
        e.xmlReceive = result;
    }

    public EncapsuledMessageRec prepareMessage(TInutNFe t, String url, int codUf) throws MalformedURLException, JAXBException, NFeException, NFeValidateException {
        URL u = new URL(url);
        String xml = MarshallerUtil.mashall(t);
        try {
            xml = new NFeSignature().assinarInutilizacaoNFe(xml);
        }
        catch (Exception ex) {
            Logger.getLogger(NFeInutilizacao.class.getName()).log(Level.SEVERE, null, ex);
            throw new NFeException("Erro ao assinar o XML de envio.", ex);
        }
        EncapsuledMessageRec e = new EncapsuledMessageRec();
        e.codUf = codUf;
        e.toSend = t;
        e.urlToSend = u;
        e.xmlSend = xml;
        return e;
    }

    private String sendMessage(URL u, String xml, int codUf) throws NFeException {
        try {
            NFeInutilizacao4Stub stub = new NFeInutilizacao4Stub(u.toString());
            NFeInutilizacao4Stub.NfeDadosMsg dados = new NFeInutilizacao4Stub.NfeDadosMsg();
            OMElement el = AXIOMUtil.stringToOM((String)xml);
            dados.setExtraElement(el);
            return stub.nfeInutilizacaoNF(dados).getExtraElement().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NFeException("| WsCTeRecepcao.execute(): " + e.toString(), e);
        }
    }

    public static class EncapsuledMessageRec {
        private String xmlSend;
        private String xmlReceive;
        private Integer codUf;
        private URL urlToSend;
        private TInutNFe toSend;
        private TRetInutNFe toReceive;
        private String msgProcessada;
        private Object auxiliar;

        public String getXmlSend() {
            return this.xmlSend;
        }

        public String getXmlReceive() {
            return this.xmlReceive;
        }

        public Integer getCodUf() {
            return this.codUf;
        }

        public URL getUrlToSend() {
            return this.urlToSend;
        }

        public TInutNFe getToSend() {
            return this.toSend;
        }

        public TRetInutNFe getToReceive() {
            return this.toReceive;
        }

        public String getMsgProcessada() {
            return this.msgProcessada;
        }

        public void setMsgProcessada(String msgProcessada) {
            this.msgProcessada = msgProcessada;
        }

        public Object getAuxiliar() {
            return this.auxiliar;
        }

        public void setAuxiliar(Object auxiliar) {
            this.auxiliar = auxiliar;
        }
    }
}

