/*
 * Decompiled with CFR 0.152.
 */
package nfe.versao400.services;

import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.bind.JAXBException;
import nfe.certificate.DFAssinaturaDigital;
import nfe.certificate.NFeSignature;
import nfe.exception.NFeException;
import nfe.exception.NFeValidateException;
import nfe.util.NFeFileUtil;
import nfe.versao400.model.TEnviNFe;
import nfe.versao400.model.TNFe;
import nfe.versao400.model.TRetEnviNFe;
import nfe.versao400.services.nfeautorizacao4.NFeAutorizacao4Stub;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import utilities.MarshallerUtil;

public class NFeRecepcao {
    private String versao = "3.10";

    public void recepcaoLote(EncapsuledMessageRec e) throws MalformedURLException, JAXBException, NFeException, NFeValidateException {
        TRetEnviNFe ret;
        new NFeFileUtil().beforeSendLoteNFe(e.getXmlSend(), e.getToSend().getIdLote());
        String result = this.sendMessage(e.getUrlToSend(), e.getXmlSend(), e.getCodUf());
        new NFeFileUtil().afterSendLoteNFe(result, e.getToSend().getIdLote());
        e.toReceive = ret = (TRetEnviNFe)MarshallerUtil.umarshall(result, TRetEnviNFe.class);
        e.xmlReceive = result;
    }

    public String gerarXMLSemValidade(TEnviNFe t) throws MalformedURLException, JAXBException, NFeException, NFeValidateException {
        String xml = MarshallerUtil.mashall(t);
        try {
            xml = new NFeSignature().assinarXMLNFe(xml);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new NFeException("Erro ao assinar o arquivo XML. Verifique seu certificado.");
        }
        return xml;
    }

    public String gerarXMLSemValidade(TNFe t) throws MalformedURLException, JAXBException, NFeException, NFeValidateException {
        String xml = MarshallerUtil.mashall(t);
        xml = xml.replaceAll(" xmlns:ns2=\"http://www.w3.org/2000/09/xmldsig#\"", "");
        return xml;
    }

    public EncapsuledMessageRec prepareMessage(TEnviNFe t, String url, int codUf) throws MalformedURLException, JAXBException, NFeException, NFeValidateException {
        URL u = null;
        if (url != null && url.trim().length() > 0) {
            u = new URL(url);
        }
        String xml = MarshallerUtil.mashall(t);
        xml = xml.replaceAll(" xmlns:ns2=\"http://www.w3.org/2000/09/xmldsig#\"", "");
        try {
            xml = new DFAssinaturaDigital().assinarDocumento(xml);
        }
        catch (Exception ex) {
            throw new NFeException("Erro ao assinar o arquivo XML. Verifique seu certificado.", ex);
        }
        EncapsuledMessageRec e = new EncapsuledMessageRec();
        e.codUf = codUf;
        e.toSend = t;
        e.urlToSend = u;
        e.xmlSend = xml;
        return e;
    }

    private String sendMessage(URL u, String xml, int codUf) throws NFeException {
        try {
            NFeAutorizacao4Stub stub = new NFeAutorizacao4Stub(u.toString());
            NFeAutorizacao4Stub.NfeDadosMsg dados = new NFeAutorizacao4Stub.NfeDadosMsg();
            OMElement el = AXIOMUtil.stringToOM((String)xml);
            dados.setExtraElement(el);
            System.out.println("Enviando aqui o lote");
            return stub.nfeAutorizacaoLote(dados).getExtraElement().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NFeException("| WsNFeRecepcao.execute(): " + e.toString(), e);
        }
    }

    public static class EncapsuledMessageRec {
        private String xmlSend;
        private String xmlReceive;
        private Integer codUf;
        private URL urlToSend;
        private TEnviNFe toSend;
        private TRetEnviNFe toReceive;
        private String msgProcesada;
        private Object auxiliar;
        private Boolean sincrono = false;

        public String getXmlSend() {
            return this.xmlSend;
        }

        public String getXmlReceive() {
            return this.xmlReceive;
        }

        public Integer getCodUf() {
            return this.codUf;
        }

        public URL getUrlToSend() {
            return this.urlToSend;
        }

        public TEnviNFe getToSend() {
            return this.toSend;
        }

        public TRetEnviNFe getToReceive() {
            return this.toReceive;
        }

        public String getMsgProcesada() {
            return this.msgProcesada;
        }

        public void setMsgProcesada(String msgProcesada) {
            this.msgProcesada = msgProcesada;
        }

        public Object getAuxiliar() {
            return this.auxiliar;
        }

        public void setAuxiliar(Object auxiliar) {
            this.auxiliar = auxiliar;
        }

        public Boolean getSincrono() {
            return this.sincrono;
        }

        public void setSincrono(Boolean sincrono) {
            this.sincrono = sincrono;
        }
    }
}

