/*
 * Decompiled with CFR 0.152.
 */
package nfe.versao400.services;

import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.bind.JAXBException;
import nfe.certificate.NFeSignature;
import nfe.exception.NFeException;
import nfe.exception.NFeValidateException;
import nfe.util.NFeFileUtil;
import nfe.versao400.model.TEnvEvento;
import nfe.versao400.model.TRetEnvEvento;
import nfe.versao400.services.nferecepcaoevento4.NFeRecepcaoEvento4Stub;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import utilities.MarshallerUtil;

public class NFeRecepcaoEventos {
    public static final String VERSAO = "1.00";

    public void recepcaoLoteEventos(EncapsuledMessageRec e) throws MalformedURLException, JAXBException, NFeException, NFeValidateException {
        TRetEnvEvento ret;
        new NFeFileUtil().beforeSendLoteEventosNFe(e.getXmlSend(), e.getToSend().getIdLote());
        String result = this.sendMessage(e.getUrlToSend(), e.getXmlSend(), e.getCodUf());
        e.toReceive = ret = (TRetEnvEvento)MarshallerUtil.umarshall(result, TRetEnvEvento.class);
        e.xmlReceive = result;
    }

    public String gerarXMLSemValidade(TEnvEvento t) throws MalformedURLException, JAXBException, NFeException, NFeValidateException {
        String xml = MarshallerUtil.mashall(t);
        try {
            xml = new NFeSignature().assinarXMLNFe(xml);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new NFeException("Erro ao assinar o arquivo XML. Verifique seu certificado.", ex);
        }
        return xml;
    }

    public EncapsuledMessageRec prepareMessage(TEnvEvento t, String url, int codUf) throws MalformedURLException, JAXBException, NFeException, NFeValidateException {
        URL u = new URL(url);
        String xml = MarshallerUtil.mashall(t);
        try {
            xml = new NFeSignature().assinarXMLEvento(xml);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new NFeException("Erro ao assinar o arquivo XML. Verifique seu certificado.", ex);
        }
        EncapsuledMessageRec e = new EncapsuledMessageRec();
        e.codUf = codUf;
        e.toSend = t;
        e.urlToSend = u;
        e.xmlSend = xml;
        return e;
    }

    private String sendMessage(URL u, String xml, int codUf) throws NFeException {
        try {
            NFeRecepcaoEvento4Stub stub = new NFeRecepcaoEvento4Stub(u.toString());
            NFeRecepcaoEvento4Stub.NfeDadosMsg dados = new NFeRecepcaoEvento4Stub.NfeDadosMsg();
            OMElement el = AXIOMUtil.stringToOM((String)xml);
            dados.setExtraElement(el);
            return stub.nfeRecepcaoEventoNF(dados).getExtraElement().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NFeException("| WsNFeRecepcao.execute(): " + e.toString(), e);
        }
    }

    public static class EncapsuledMessageRec {
        private String xmlSend;
        private String xmlReceive;
        private Integer codUf;
        private URL urlToSend;
        private TEnvEvento toSend;
        private TRetEnvEvento toReceive;
        private String msgProcesada;
        private Object auxiliar;

        public String getXmlSend() {
            return this.xmlSend;
        }

        public String getXmlReceive() {
            return this.xmlReceive;
        }

        public Integer getCodUf() {
            return this.codUf;
        }

        public URL getUrlToSend() {
            return this.urlToSend;
        }

        public TEnvEvento getToSend() {
            return this.toSend;
        }

        public TRetEnvEvento getToReceive() {
            return this.toReceive;
        }

        public String getMsgProcesada() {
            return this.msgProcesada;
        }

        public void setMsgProcesada(String msgProcesada) {
            this.msgProcesada = msgProcesada;
        }

        public Object getAuxiliar() {
            return this.auxiliar;
        }

        public void setAuxiliar(Object auxiliar) {
            this.auxiliar = auxiliar;
        }
    }
}

