/*
 * Decompiled with CFR 0.152.
 */
package nfse.nfsev_enfs.service;

import java.io.File;
import java.io.FileOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import javax.xml.bind.JAXBException;
import nfse.exception.NFseException;
import nfse.nfsev_enfs.certificate.NFSeSignature;
import nfse.nfsev_enfs.model.ConsultarLoteRpsEnvio;
import nfse.nfsev_enfs.model.ConsultarLoteRpsResposta;
import nfse.util.NFSeFileUtil;
import org.apache.axis2.AxisFault;
import utilities.MarshallerUtil;
import utilities.StringUtil;

public class NFSeConsultaLote {
    public void recepcaoLote(EncapsuledMessageRec e) throws MalformedURLException, JAXBException, RemoteException, NFseException {
        ConsultarLoteRpsResposta ret;
        new NFSeFileUtil().beforeConsultaLoteNFSe(e.getToSend().getProtocolo());
        String result = this.enviarConsultaEnvioLoteRPS(e.getUrlToSend(), e.getXmlSend());
        new NFSeFileUtil().afterConsultaEnvioLoteNFSe(result);
        result = result.replaceAll("xmlns=\"http://www.abrasf.org.br/nfse\"", "");
        e.toReceive = ret = (ConsultarLoteRpsResposta)MarshallerUtil.umarshall(result, ConsultarLoteRpsResposta.class);
        e.xmlReceive = result;
    }

    public void consultaLoteV3(EncapsuledMessageRecV3 e) throws MalformedURLException, JAXBException, RemoteException, NFseException {
        new NFSeFileUtil().beforeConsultaLoteNFSe(e.getToSend().getProtocolo());
        String result = this.enviarConsultaEnvioLoteRPSV3(e.getUrlToSend(), e.getXmlSend());
        System.out.println(result);
        new NFSeFileUtil().afterConsultaEnvioLoteNFSe(result);
        result = this.corrigeXMLRecepcaoV3(StringUtil.clearStringXml(result));
        this.saveArquivo("RETORNO.xml", result);
        ConsultarLoteRpsResposta ret = null;
        e.toReceive = ret = (ConsultarLoteRpsResposta)MarshallerUtil.umarshall(result, ConsultarLoteRpsResposta.class);
        e.xmlReceive = result;
    }

    private String corrigeXMLRecepcaoV3(String result) {
        result = result.replaceAll("<ConsultarSituacaoLoteRpsResposta  >", "<ConsultarSituacaoLoteRpsResposta>");
        return StringUtil.clearStringXml(result);
    }

    public EncapsuledMessageRec prepareMessage(ConsultarLoteRpsEnvio t, String url) throws MalformedURLException, JAXBException, NFseException {
        URL u = new URL(url);
        String xml = MarshallerUtil.mashall(t);
        this.corrigeXMLConsultaEnvioV3(xml);
        EncapsuledMessageRec e = new EncapsuledMessageRec();
        e.toSend = t;
        e.urlToSend = u;
        e.xmlSend = xml;
        return e;
    }

    public EncapsuledMessageRecV3 prepareMessageV3(ConsultarLoteRpsEnvio t, String url) throws MalformedURLException, JAXBException, NFseException {
        URL u = new URL(url);
        String xml = MarshallerUtil.mashall(t);
        EncapsuledMessageRecV3 e = new EncapsuledMessageRecV3();
        xml = this.corrigeXMLConsultaEnvioV3(StringUtil.clearStringXml(xml));
        try {
            xml = new NFSeSignature().assinarXMLConsultaLoteRPSNFSe(xml);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new NFseException(ex);
        }
        this.saveArquivo("CONSULTA.xml", xml);
        e.toSend = t;
        e.urlToSend = u;
        e.xmlSend = xml;
        return e;
    }

    private String corrigeXMLConsultaEnvioV3(String xml) {
        xml = xml.replaceAll("xmlns=\"http://www.w3.org/2000/09/xmldsig#\"", "xmlns=\"http://www.abrasf.org.br/nfse.xsd\"");
        xml = xml.replaceAll("Cnpj", "tipos:Cnpj");
        xml = xml.replaceAll("InscricaoMunicipal", "tipos:InscricaoMunicipal");
        return xml;
    }

    private void saveArquivo(String name, String xml) {
        try {
            File f = new File(name);
            f.createNewFile();
            FileOutputStream bos = new FileOutputStream(f);
            bos.write(xml.getBytes());
            bos.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String enviarConsultaEnvioLoteRPS(URL u, String xmlEnvio) throws AxisFault, RemoteException, NFseException {
        return null;
    }

    private String enviarConsultaEnvioLoteRPSV3(URL u, String xmlEnvio) throws AxisFault, RemoteException, NFseException {
        return null;
    }

    public static class EncapsuledMessageRec {
        private String xmlSend;
        private String xmlReceive;
        private URL urlToSend;
        private ConsultarLoteRpsEnvio toSend;
        private ConsultarLoteRpsResposta toReceive;
        private String msgProcesada;
        private Object auxiliar;

        public String getXmlSend() {
            return this.xmlSend;
        }

        public String getXmlReceive() {
            return this.xmlReceive;
        }

        public URL getUrlToSend() {
            return this.urlToSend;
        }

        public ConsultarLoteRpsEnvio getToSend() {
            return this.toSend;
        }

        public ConsultarLoteRpsResposta getToReceive() {
            return this.toReceive;
        }

        public String getMsgProcesada() {
            return this.msgProcesada;
        }

        public void setMsgProcesada(String msgProcesada) {
            this.msgProcesada = msgProcesada;
        }

        public Object getAuxiliar() {
            return this.auxiliar;
        }

        public void setAuxiliar(Object auxiliar) {
            this.auxiliar = auxiliar;
        }
    }

    public static class EncapsuledMessageRecV3 {
        private String xmlSend;
        private String xmlReceive;
        private URL urlToSend;
        private ConsultarLoteRpsEnvio toSend;
        private ConsultarLoteRpsResposta toReceive;
        private String msgProcesada;
        private Object auxiliar;

        public String getXmlSend() {
            return this.xmlSend;
        }

        public String getXmlReceive() {
            return this.xmlReceive;
        }

        public URL getUrlToSend() {
            return this.urlToSend;
        }

        public ConsultarLoteRpsEnvio getToSend() {
            return this.toSend;
        }

        public ConsultarLoteRpsResposta getToReceive() {
            return this.toReceive;
        }

        public String getMsgProcesada() {
            return this.msgProcesada;
        }

        public void setMsgProcesada(String msgProcesada) {
            this.msgProcesada = msgProcesada;
        }

        public Object getAuxiliar() {
            return this.auxiliar;
        }

        public void setAuxiliar(Object auxiliar) {
            this.auxiliar = auxiliar;
        }
    }
}

