/*
 * Decompiled with CFR 0.152.
 */
package nfse.nfsev_goiania.service;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import nfse.exception.NFseException;
import nfse.nfsev_goiania.model.ConsultarLoteRpsEnvio;
import nfse.nfsev_goiania.model.ConsultarLoteRpsResposta;
import nfse.nfsev_goiania.model.ListaMensagemRetorno;
import nfse.nfsev_goiania.model.TcCompNfse;
import nfse.nfsev_goiania.model.TcIdentificacaoRps;
import nfse.nfsev_goiania.model.TcInfNfse;
import nfse.nfsev_goiania.model.TcMensagemRetorno;
import nfse.nfsev_goiania.model.TcNfse;
import nfse.util.NFSeFileUtil;
import org.apache.axis2.AxisFault;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import utilities.MarshallerUtil;
import utilities.StringUtil;

public class NFSeConsultaLote {
    public void recepcaoLote(EncapsuledMessageRec e) throws MalformedURLException, JAXBException, RemoteException, NFseException {
        ConsultarLoteRpsResposta ret;
        new NFSeFileUtil().beforeConsultaLoteNFSe(e.getToSend().getProtocolo());
        String result = this.enviarConsultaEnvioLoteRPS(e.getUrlToSend(), e.getXmlSend());
        new NFSeFileUtil().afterConsultaEnvioLoteNFSe(result);
        result = result.replace("<tc:", "<");
        result = result.replace("</tc:", "</");
        e.toReceive = ret = this.transformerResultEmXML(result);
        e.xmlReceive = result;
        System.out.println("RESULTADO CONSULTA: " + result);
    }

    public void consultaLoteV3(EncapsuledMessageRecV3 e) throws MalformedURLException, JAXBException, RemoteException, NFseException {
        new NFSeFileUtil().beforeConsultaLoteNFSe(e.getToSend().getProtocolo());
        String result = this.enviarConsultaEnvioLoteRPSV3(e.getUrlToSend(), e.getXmlSend());
        System.out.println(result);
        new NFSeFileUtil().afterConsultaEnvioLoteNFSe(result);
        result = this.corrigeXMLRecepcaoV3(StringUtil.clearStringXml(result));
        this.saveArquivo("RETORNO.xml", result);
        ConsultarLoteRpsResposta ret = null;
        e.toReceive = ret = (ConsultarLoteRpsResposta)MarshallerUtil.umarshall(result, ConsultarLoteRpsResposta.class);
        e.xmlReceive = result;
    }

    private String corrigeXMLRecepcaoV3(String result) {
        result = result.replaceAll("ns3:", "");
        result = result.replaceAll("ns2:", "");
        result = result.replaceAll("ns4:", "");
        result = result.replaceAll("ns5:", "");
        result = result.replaceAll("xmlns:ns2=\"http://www.ginfes.com.br/tipos_v03.xsd\"", "");
        result = result.replaceAll("xmlns:tipos=\"http://www.ginfes.com.br/tipos_v03.xsd\"", "");
        result = result.replaceAll("xmlns:ns2=\"http://www.ginfes.com.br/tipos_v03.xsd\"", "");
        result = result.replaceAll("xmlns:ns3=\"http://www.ginfes.com.br/servico_consultar_lote_rps_resposta_v03.xsd\"", "xmlns=\"http://www.w3.org/2000/09/xmldsig#\"");
        result = result.replaceAll("tipos:", "");
        result = result.replaceAll("<ConsultarSituacaoLoteRpsResposta  >", "<ConsultarSituacaoLoteRpsResposta>");
        return StringUtil.clearStringXml(result);
    }

    public EncapsuledMessageRec prepareMessage(ConsultarLoteRpsEnvio t, String url) throws MalformedURLException, JAXBException, NFseException {
        URL u = new URL(url);
        String xml = MarshallerUtil.mashall(t);
        xml = this.corrigeXMLConsultaEnvioV3(xml);
        EncapsuledMessageRec e = new EncapsuledMessageRec();
        e.toSend = t;
        e.urlToSend = u;
        e.xmlSend = xml;
        System.out.println("teste");
        return e;
    }

    public EncapsuledMessageRecV3 prepareMessageV3(ConsultarLoteRpsEnvio t, String url) throws MalformedURLException, JAXBException, NFseException {
        URL u = new URL(url);
        String xml = MarshallerUtil.mashall(t);
        EncapsuledMessageRecV3 e = new EncapsuledMessageRecV3();
        xml = this.corrigeXMLConsultaEnvioV3(StringUtil.clearStringXml(xml));
        this.saveArquivo("CONSULTA.xml", xml);
        e.toSend = t;
        e.urlToSend = u;
        e.xmlSend = xml;
        return e;
    }

    private String corrigeXMLConsultaEnvioV3(String xml) {
        xml = xml.replaceAll("xmlns=\"http://www.w3.org/2000/09/xmldsig#\"", " xmlns:ts=\"http://www.issnetonline.com.br/webserviceabrasf/vsd/tipos_simples.xsd\" xmlns:tc=\"http://www.issnetonline.com.br/webserviceabrasf/vsd/tipos_complexos.xsd\"");
        xml = xml.replaceAll("<CpfCnpj>", "<tc:CpfCnpj>");
        xml = xml.replaceAll("</CpfCnpj>", "</tc:CpfCnpj>");
        xml = xml.replaceAll("<Cpf>", "<tc:Cpf>");
        xml = xml.replaceAll("</Cpf>", "</tc:Cpf>");
        xml = xml.replaceAll("<Cnpj>", "<tc:Cnpj>");
        xml = xml.replaceAll("</Cnpj>", "</tc:Cnpj>");
        xml = xml.replaceAll("InscricaoMunicipal", "tc:InscricaoMunicipal");
        return xml;
    }

    private void saveArquivo(String name, String xml) {
        try {
            File f = new File(name);
            f.createNewFile();
            FileOutputStream bos = new FileOutputStream(f);
            bos.write(xml.getBytes());
            bos.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String enviarConsultaEnvioLoteRPS(URL u, String conteudo) throws AxisFault, RemoteException, NFseException {
        return null;
    }

    private String enviarConsultaEnvioLoteRPSV3(URL u, String conteudo) throws AxisFault, RemoteException, NFseException {
        return null;
    }

    private ConsultarLoteRpsResposta transformerResultEmXML(String result) {
        try {
            Namespace namespace = Namespace.getNamespace((String)"http://nfse.goiania.go.gov.br/xsd/nfse_gyn_v02.xsd");
            SAXBuilder sb = new SAXBuilder();
            Document d = null;
            d = sb.build((InputStream)new ByteArrayInputStream(StringUtil.clearStringXml(result).getBytes()));
            List listaRejeicao = d.getRootElement().getChildren("ListaMensagemRetorno", namespace);
            List listaNfse = d.getRootElement().getChildren("ListaNfse", namespace);
            ConsultarLoteRpsResposta c = new ConsultarLoteRpsResposta();
            this.getListaMensagemRetornoRPS(listaRejeicao, namespace, c);
            this.getListaNfse(listaNfse, namespace, c);
            return c;
        }
        catch (JDOMException namespace) {
        }
        catch (IOException ex) {
            Logger.getLogger(NFSeConsultaLote.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    private TcIdentificacaoRps getIdentificacaoRps(Element eee, Namespace n) {
        TcIdentificacaoRps t = new TcIdentificacaoRps();
        eee.getAttribute("Numero");
        String numero = eee.getChild("Numero", n).getText();
        t.setNumero(new BigInteger(numero));
        String serie = eee.getChild("Serie", n).getText();
        t.setSerie(serie);
        String tipo = eee.getChild("Tipo", n).getText();
        t.setTipo(new Byte(tipo));
        return t;
    }

    private void getListaMensagemRetornoRPS(List<Element> lista2, Namespace namespace, ConsultarLoteRpsResposta c) {
        if (lista2 != null && !lista2.isEmpty()) {
            for (Element e : lista2) {
                ListaMensagemRetorno listaMensagemRetorno = c.getListaMensagemRetorno();
                List retornos = e.getChildren("MensagemRetorno", namespace);
                if (retornos != null && !retornos.isEmpty()) {
                    for (Element ee : retornos) {
                        TcMensagemRetorno m = new TcMensagemRetorno();
                        List mensagens = ee.getChildren();
                        if (mensagens != null && !mensagens.isEmpty()) {
                            for (Element eee : mensagens) {
                                if (eee.getName().equals("IdentificacaoRps")) continue;
                                if (eee.getName().equals("Mensagem")) {
                                    m.setMensagem(eee.getText());
                                    continue;
                                }
                                if (!eee.getName().equals("Codigo")) continue;
                                m.setCodigo(eee.getText());
                            }
                        }
                        listaMensagemRetorno.getMensagemRetorno().add(m);
                    }
                }
                c.setListaMensagemRetorno(listaMensagemRetorno);
            }
        }
    }

    private void getListaNfse(List<Element> lista2, Namespace namespace, ConsultarLoteRpsResposta c) {
        if (lista2 != null && !lista2.isEmpty()) {
            for (Element e : lista2) {
                ConsultarLoteRpsResposta.ListaNfse listaNFse = new ConsultarLoteRpsResposta.ListaNfse();
                List notas = e.getChild("CompNfse", namespace).getChildren("Nfse", namespace);
                if (notas != null && !notas.isEmpty()) {
                    for (Element ee : notas) {
                        TcCompNfse m = new TcCompNfse();
                        List mensagens = ee.getChildren();
                        if (mensagens != null && !mensagens.isEmpty()) {
                            for (Element eee : mensagens) {
                                if (!eee.getName().equals("InfNfse")) continue;
                                m.setNfse(this.getNfse(eee, namespace));
                            }
                        }
                        listaNFse.getCompNfse().add(m);
                    }
                }
                c.setListaNfse(listaNFse);
            }
        }
    }

    private TcNfse getNfse(Element infNfse, Namespace n) {
        TcNfse t = new TcNfse();
        t.setInfNfse(null);
        TcInfNfse ti = new TcInfNfse();
        String numeroNota = infNfse.getChild("Numero", n).getText();
        ti.setNumero(new BigInteger(numeroNota));
        String codigoVerificacao = infNfse.getChild("CodigoVerificacao", n).getText();
        ti.setCodigoVerificacao(codigoVerificacao);
        Element identificacaoRps = infNfse.getChild("IdentificacaoRps", n);
        String numero = identificacaoRps.getChildText("Numero", n);
        String serie = identificacaoRps.getChildText("Serie", n);
        String tipo = identificacaoRps.getChildText("Tipo", n);
        TcIdentificacaoRps tr = new TcIdentificacaoRps();
        tr.setNumero(new BigInteger(numero));
        tr.setSerie(serie);
        tr.setTipo(new Byte(tipo));
        t.setInfNfse(ti);
        return t;
    }

    public static class EncapsuledMessageRec {
        private String xmlSend;
        private String xmlReceive;
        private URL urlToSend;
        private ConsultarLoteRpsEnvio toSend;
        private ConsultarLoteRpsResposta toReceive;
        private String msgProcesada;
        private Object auxiliar;

        public String getXmlSend() {
            return this.xmlSend;
        }

        public String getXmlReceive() {
            return this.xmlReceive;
        }

        public URL getUrlToSend() {
            return this.urlToSend;
        }

        public ConsultarLoteRpsEnvio getToSend() {
            return this.toSend;
        }

        public ConsultarLoteRpsResposta getToReceive() {
            return this.toReceive;
        }

        public String getMsgProcesada() {
            return this.msgProcesada;
        }

        public void setMsgProcesada(String msgProcesada) {
            this.msgProcesada = msgProcesada;
        }

        public Object getAuxiliar() {
            return this.auxiliar;
        }

        public void setAuxiliar(Object auxiliar) {
            this.auxiliar = auxiliar;
        }
    }

    public static class EncapsuledMessageRecV3 {
        private String xmlSend;
        private String xmlReceive;
        private URL urlToSend;
        private ConsultarLoteRpsEnvio toSend;
        private ConsultarLoteRpsResposta toReceive;
        private String msgProcesada;
        private Object auxiliar;

        public String getXmlSend() {
            return this.xmlSend;
        }

        public String getXmlReceive() {
            return this.xmlReceive;
        }

        public URL getUrlToSend() {
            return this.urlToSend;
        }

        public ConsultarLoteRpsEnvio getToSend() {
            return this.toSend;
        }

        public ConsultarLoteRpsResposta getToReceive() {
            return this.toReceive;
        }

        public String getMsgProcesada() {
            return this.msgProcesada;
        }

        public void setMsgProcesada(String msgProcesada) {
            this.msgProcesada = msgProcesada;
        }

        public Object getAuxiliar() {
            return this.auxiliar;
        }

        public void setAuxiliar(Object auxiliar) {
            this.auxiliar = auxiliar;
        }
    }
}

