/*
 * Decompiled with CFR 0.152.
 */
package nfse.nfsev_ipm.service;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.bind.JAXBException;
import nfse.exception.NFseException;
import nfse.nfsev_ipm.certificate.NFSeSignature;
import nfse.nfsev_ipm.model.nfse;
import nfse.nfsev_ipm.model.retorno;
import nfse.nfsev_ipm.webservicestubs.NfseIpmService;
import nfse.util.NFSeFileUtil;
import utilities.MarshallerUtil;
import utilities.StringUtil;

public class NFSeRecepcao {
    public EncapsuledMessageRec prepareMessage(nfse n, String url) throws MalformedURLException, Exception {
        URL u = new URL(url);
        String xml = this.toXLMLoteRps(n);
        EncapsuledMessageRec e = new EncapsuledMessageRec();
        e.toSend = n;
        e.urlToSend = u;
        e.xmlSend = xml;
        this.saveFile(xml, e);
        return e;
    }

    private void saveFile(String xml, EncapsuledMessageRec e) throws IOException {
        File file = new File(System.getProperty("user.dir"));
        File arquivo = new File(file, "envio.xml");
        arquivo.createNewFile();
        FileWriter fileWriter = new FileWriter(arquivo, false);
        PrintWriter p = new PrintWriter(fileWriter);
        e.caminho = arquivo;
        p.append(xml);
        p.close();
    }

    public void recepcaoLote(EncapsuledMessageRec e, String url, String login, String senha, String cidade) throws NFseException, IOException, Throwable {
        new NFSeFileUtil().beforeEnvioLoteNFSe(e.getXmlSend());
        String result = this.enviarLoteRPSIpm(e.getCaminho(), url, login, senha, cidade);
        new NFSeFileUtil().afterEnvioLoteNFSe(result);
        result = this.corrigeResposta(result);
        try {
            retorno ret;
            e.toReceive = ret = (retorno)MarshallerUtil.umarshall(result, retorno.class);
        }
        catch (Throwable tr) {
            tr.printStackTrace();
            throw tr;
        }
        e.xmlReceive = result;
    }

    private String corrigeResposta(String result) {
        result = result.replaceAll("xmlns:ns3=\"http://www.abrasf.org.br/nfse.xsd\"", "");
        result = result.replaceAll("xmlns:ns2=\"http://www.w3.org/2000/09/xmldsig#\"", "xmlns=\"http://www.w3.org/2000/09/xmldsig#\"");
        return StringUtil.clearStringXml(result);
    }

    private String enviarLoteRPSIpm(File caminho, String url, String login, String senha, String cidade) throws IOException {
        return new NfseIpmService().conexaoWebServiceNfseIpmEnvio(caminho, url, login, senha, cidade);
    }

    public String toXLMLoteRps(nfse e) throws JAXBException, Exception {
        String xml = MarshallerUtil.mashall(e);
        xml = xml.replaceAll(" standalone=\"yes\"", "");
        xml = xml.replaceAll(" xmlns=\"http://www.w3.org/2000/09/xmldsig#\"", " xmlns=\"http://www.abrasf.org.br/nfse.xsd\"");
        xml = new NFSeSignature().assinarXMLNota(StringUtil.clearStringXml(xml));
        return xml;
    }

    public static class EncapsuledMessageRec {
        private String xmlSend;
        private String xmlReceive;
        private URL urlToSend;
        private nfse toSend;
        private retorno toReceive;
        private String msgProcesada;
        private Object auxiliar;
        private File caminho;

        public String getXmlSend() {
            return this.xmlSend;
        }

        public void setXmlSend(String xmlSend) {
            this.xmlSend = xmlSend;
        }

        public File getCaminho() {
            return this.caminho;
        }

        public void setCaminho(File caminho) {
            this.caminho = caminho;
        }

        public String getXmlReceive() {
            return this.xmlReceive;
        }

        public void setXmlReceive(String xmlReceive) {
            this.xmlReceive = xmlReceive;
        }

        public URL getUrlToSend() {
            return this.urlToSend;
        }

        public void setUrlToSend(URL urlToSend) {
            this.urlToSend = urlToSend;
        }

        public nfse getToSend() {
            return this.toSend;
        }

        public void setToSend(nfse toSend) {
            this.toSend = toSend;
        }

        public retorno getToReceive() {
            return this.toReceive;
        }

        public void setToReceive(retorno toReceive) {
            this.toReceive = toReceive;
        }

        public String getMsgProcesada() {
            return this.msgProcesada;
        }

        public void setMsgProcesada(String msgProcesada) {
            this.msgProcesada = msgProcesada;
        }

        public Object getAuxiliar() {
            return this.auxiliar;
        }

        public void setAuxiliar(Object auxiliar) {
            this.auxiliar = auxiliar;
        }
    }
}

