/*
 * Decompiled with CFR 0.152.
 */
package nfse.nfsev_issnet.service;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import nfse.exception.NFseException;
import nfse.nfsev_issnet.model.TcCompNfse;
import nfse.nfsev_issnet.model.TcIdentificacaoRps;
import nfse.nfsev_issnet.model.TcInfNfse;
import nfse.nfsev_issnet.model.TcMensagemRetorno;
import nfse.nfsev_issnet.model.TcNfse;
import nfse.nfsev_issnet.model.consultarnfserpsenvio.ConsultarNfseRpsEnvio;
import nfse.nfsev_issnet.model.consultarnfserpsresposta.ConsultarNfseRpsResposta;
import nfse.nfsev_issnet.service.NFSeConsultaLote;
import nfse.nfsev_issnet.webservicestubs.ServicosStub;
import nfse.util.NFSeFileUtil;
import org.apache.axis2.AxisFault;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import utilities.MarshallerUtil;
import utilities.StringUtil;

public class NFSeConsultaRPS {
    public void consultaRPSNFSe(EncapsuledMessageRec e) throws MalformedURLException, JAXBException, RemoteException, NFseException {
        ConsultarNfseRpsResposta ret;
        new NFSeFileUtil().beforeConsultaRPSNFSe(e.getToSend().getIdentificacaoRps().getNumero().toString());
        String result = this.enviarConsultaEnvioLoteRPS(e.getUrlToSend(), e.getXmlSend());
        System.out.println(result);
        new NFSeFileUtil().afterConsultaRPSNFSe(result);
        result = this.corrigeXMLRecepcaoV3(result);
        e.toReceive = ret = this.transformerResultEmXML(result);
        e.xmlReceive = result;
    }

    private String corrigeXMLRecepcaoV3(String result) {
        result = result.replaceAll("<tc:", "<");
        result = result.replaceAll("</tc:", "</");
        return StringUtil.clearStringXml(result);
    }

    public EncapsuledMessageRec prepareMessage(ConsultarNfseRpsEnvio t, String url) throws MalformedURLException, JAXBException, NFseException {
        URL u = new URL(url);
        String xml = MarshallerUtil.mashall(t);
        xml = this.corrigeXMLConsultaEnvioV3(xml);
        EncapsuledMessageRec e = new EncapsuledMessageRec();
        e.toSend = t;
        e.urlToSend = u;
        e.xmlSend = xml;
        return e;
    }

    private String corrigeXMLConsultaEnvioV3(String xml) {
        xml = xml.replaceAll("xmlns=\"http://www.issnetonline.com.br/webserviceabrasf/vsd/servico_consultar_nfse_rps_envio.xsd\"", "");
        xml = xml.replaceAll("xmlns=\"http://www.w3.org/2000/09/xmldsig#\"", " xmlns=\"http://www.issnetonline.com.br/webserviceabrasf/vsd/servico_consultar_nfse_rps_envio.xsd\" xmlns:tc=\"http://www.issnetonline.com.br/webserviceabrasf/vsd/tipos_complexos.xsd\" xmlns:ts=\"http://www.issnetonline.com.br/webserviceabrasf/vsd/tipos_simples.xsd\"");
        xml = xml.replaceAll("<CpfCnpj", "<tc:CpfCnpj");
        xml = xml.replaceAll("</CpfCnpj", "</tc:CpfCnpj");
        xml = xml.replaceAll("<Cnpj", "<tc:Cnpj");
        xml = xml.replaceAll("</Cnpj", "</tc:Cnpj");
        xml = xml.replaceAll("<Cpf", "<tc:Cpf");
        xml = xml.replaceAll("</Cpf", "</tc:Cpf");
        xml = xml.replaceAll("<Numero", "<tc:Numero");
        xml = xml.replaceAll("</Numero", "</tc:Numero");
        xml = xml.replaceAll("<Serie", "<tc:Serie");
        xml = xml.replaceAll("</Serie", "</tc:Serie");
        xml = xml.replaceAll("<Tipo", "<tc:Tipo");
        xml = xml.replaceAll("</Tipo", "</tc:Tipo");
        xml = xml.replaceAll("<InscricaoMunicipal", "<tc:InscricaoMunicipal");
        xml = xml.replaceAll("</InscricaoMunicipal", "</tc:InscricaoMunicipal");
        return xml;
    }

    private String enviarConsultaEnvioLoteRPS(URL u, String conteudo) throws AxisFault, RemoteException, NFseException {
        ServicosStub stub = new ServicosStub(u.toString());
        ServicosStub.ConsultarNFSePorRPS r = new ServicosStub.ConsultarNFSePorRPS();
        r.setXml(conteudo);
        return stub.consultarNFSePorRPS(r).getConsultarNFSePorRPSResult();
    }

    private ConsultarNfseRpsResposta transformerResultEmXML(String result) {
        try {
            Namespace namespace = Namespace.getNamespace((String)"http://www.issnetonline.com.br/webserviceabrasf/vsd/servico_consultar_nfse_rps_resposta.xsd");
            SAXBuilder sb = new SAXBuilder();
            Document d = null;
            d = sb.build((InputStream)new ByteArrayInputStream(StringUtil.clearStringXml(result).getBytes()));
            List listaRejeicao = d.getRootElement().getChildren("ListaMensagemRetorno", namespace);
            List listaNfse = d.getRootElement().getChildren("CompNfse", namespace);
            ConsultarNfseRpsResposta c = new ConsultarNfseRpsResposta();
            this.getListaMensagemRetornoRPS(listaRejeicao, namespace, c);
            this.getListaNfse(listaNfse, namespace, c);
            return c;
        }
        catch (IOException | JDOMException ex) {
            Logger.getLogger(NFSeConsultaLote.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private TcIdentificacaoRps getIdentificacaoRps(Element eee, Namespace n) {
        TcIdentificacaoRps t = new TcIdentificacaoRps();
        eee.getAttribute("Numero");
        String numero = eee.getChild("Numero", n).getText();
        t.setNumero(new BigInteger(numero));
        String serie = eee.getChild("Serie", n).getText();
        t.setSerie(serie);
        String tipo = eee.getChild("Tipo", n).getText();
        t.setTipo(new Byte(tipo));
        return t;
    }

    private void getListaMensagemRetornoRPS(List<Element> lista2, Namespace namespace, ConsultarNfseRpsResposta c) {
        if (lista2 != null && !lista2.isEmpty()) {
            for (Element e : lista2) {
                ConsultarNfseRpsResposta.ListaMensagemRetorno listaMensagemRetorno = new ConsultarNfseRpsResposta.ListaMensagemRetorno();
                List retornos = e.getChildren("MensagemRetorno", namespace);
                if (retornos != null && !retornos.isEmpty()) {
                    for (Element ee : retornos) {
                        TcMensagemRetorno m = new TcMensagemRetorno();
                        List mensagens = ee.getChildren();
                        if (mensagens != null && !mensagens.isEmpty()) {
                            for (Element eee : mensagens) {
                                if (eee.getName().equals("Correcao")) {
                                    m.setCorrecao(eee.getText());
                                    continue;
                                }
                                if (eee.getName().equals("Mensagem")) {
                                    m.setMensagem(eee.getText());
                                    continue;
                                }
                                if (!eee.getName().equals("Codigo")) continue;
                                m.setCodigo(eee.getText());
                            }
                        }
                        listaMensagemRetorno.getMensagemRetorno().add(m);
                    }
                }
                c.setListaMensagemRetorno(listaMensagemRetorno);
            }
        }
    }

    private void getListaNfse(List<Element> lista2, Namespace namespace, ConsultarNfseRpsResposta c) {
        if (lista2 != null && !lista2.isEmpty()) {
            for (Element e : lista2) {
                List notas = e.getChildren("Nfse", namespace);
                if (notas == null || notas.isEmpty()) continue;
                for (Element ee : notas) {
                    TcCompNfse m = new TcCompNfse();
                    List mensagens = ee.getChildren();
                    if (mensagens != null && !mensagens.isEmpty()) {
                        for (Element eee : mensagens) {
                            if (!eee.getName().equals("InfNfse")) continue;
                            m.setNfse(this.getNfse(eee, namespace));
                        }
                    }
                    c.setCompNfse(m);
                }
            }
        }
    }

    private TcNfse getNfse(Element infNfse, Namespace n) {
        TcNfse t = new TcNfse();
        t.setInfNfse(null);
        TcInfNfse ti = new TcInfNfse();
        String numeroNota = infNfse.getChild("Numero", n).getText();
        ti.setNumero(new BigInteger(numeroNota));
        String codigoVerificacao = infNfse.getChild("CodigoVerificacao", n).getText();
        ti.setCodigoVerificacao(codigoVerificacao);
        Element identificacaoRps = infNfse.getChild("IdentificacaoRps", n);
        String numero = identificacaoRps.getChildText("Numero", n);
        String serie = identificacaoRps.getChildText("Serie", n);
        String tipo = identificacaoRps.getChildText("Tipo", n);
        TcIdentificacaoRps tr = new TcIdentificacaoRps();
        tr.setNumero(new BigInteger(numero));
        tr.setSerie(serie);
        tr.setTipo(new Byte(tipo));
        ti.setIdentificacaoRps(tr);
        t.setInfNfse(ti);
        return t;
    }

    public static class EncapsuledMessageRec {
        private String xmlSend;
        private String xmlReceive;
        private URL urlToSend;
        private ConsultarNfseRpsEnvio toSend;
        private ConsultarNfseRpsResposta toReceive;
        private String msgProcesada;
        private Object auxiliar;

        public String getXmlSend() {
            return this.xmlSend;
        }

        public String getXmlReceive() {
            return this.xmlReceive;
        }

        public URL getUrlToSend() {
            return this.urlToSend;
        }

        public ConsultarNfseRpsEnvio getToSend() {
            return this.toSend;
        }

        public ConsultarNfseRpsResposta getToReceive() {
            return this.toReceive;
        }

        public String getMsgProcesada() {
            return this.msgProcesada;
        }

        public void setMsgProcesada(String msgProcesada) {
            this.msgProcesada = msgProcesada;
        }

        public Object getAuxiliar() {
            return this.auxiliar;
        }

        public void setAuxiliar(Object auxiliar) {
            this.auxiliar = auxiliar;
        }
    }
}

