/*
 * Decompiled with CFR 0.152.
 */
package nfse.nfsev_notacarioca.service;

import java.io.File;
import java.io.FileOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import javax.xml.bind.JAXBException;
import nfse.exception.NFseException;
import nfse.nfsev_notacarioca.certificate.NFseAssinaturaXML;
import nfse.nfsev_notacarioca.model.ConsultarLoteRpsEnvio;
import nfse.nfsev_notacarioca.model.ConsultarLoteRpsResposta;
import nfse.util.NFSeFileUtil;
import org.apache.axis2.AxisFault;
import utilities.MarshallerUtil;
import utilities.StringUtil;

public class NFSeConsultaLote {
    public void recepcaoLote(EncapsuledMessageRec e) throws MalformedURLException, JAXBException, RemoteException, NFseException {
        ConsultarLoteRpsResposta ret;
        new NFSeFileUtil().beforeConsultaLoteNFSe(e.getToSend().getProtocolo());
        String result = this.enviarConsultaEnvioLoteRPS(e.getUrlToSend(), e.getXmlSend());
        new NFSeFileUtil().afterConsultaEnvioLoteNFSe(result);
        e.toReceive = ret = (ConsultarLoteRpsResposta)MarshallerUtil.umarshall(result, ConsultarLoteRpsResposta.class);
        e.xmlReceive = result;
    }

    public void consultaLoteV3(EncapsuledMessageRecV3 e) throws MalformedURLException, JAXBException, RemoteException, NFseException {
        new NFSeFileUtil().beforeConsultaLoteNFSe(e.getToSend().getProtocolo());
        String result = this.enviarConsultaEnvioLoteRPSV3(e.getUrlToSend(), e.getXmlSend());
        System.out.println(result);
        new NFSeFileUtil().afterConsultaEnvioLoteNFSe(result);
        result = this.corrigeXMLRecepcaoV3(StringUtil.clearStringXml(result));
        this.saveArquivo("RETORNO.xml", result);
        ConsultarLoteRpsResposta ret = null;
        e.toReceive = ret = (ConsultarLoteRpsResposta)MarshallerUtil.umarshall(result, ConsultarLoteRpsResposta.class);
        e.xmlReceive = result;
    }

    private String corrigeXMLRecepcaoV3(String result) {
        result = result.replaceAll("ns3:", "");
        result = result.replaceAll("ns2:", "");
        result = result.replaceAll("ns4:", "");
        result = result.replaceAll("ns5:", "");
        result = result.replaceAll("xmlns:ns2=\"http://www.ginfes.com.br/tipos_v03.xsd\"", "");
        result = result.replaceAll("xmlns:tipos=\"http://www.ginfes.com.br/tipos_v03.xsd\"", "");
        result = result.replaceAll("xmlns:ns2=\"http://www.ginfes.com.br/tipos_v03.xsd\"", "");
        result = result.replaceAll("xmlns:ns3=\"http://www.ginfes.com.br/servico_consultar_lote_rps_resposta_v03.xsd\"", "xmlns=\"http://www.w3.org/2000/09/xmldsig#\"");
        result = result.replaceAll("tipos:", "");
        result = result.replaceAll("<ConsultarSituacaoLoteRpsResposta  >", "<ConsultarSituacaoLoteRpsResposta>");
        return StringUtil.clearStringXml(result);
    }

    public EncapsuledMessageRec prepareMessage(ConsultarLoteRpsEnvio t, String url) throws MalformedURLException, JAXBException, NFseException {
        URL u = new URL(url);
        String xml = MarshallerUtil.mashall(t);
        EncapsuledMessageRec e = new EncapsuledMessageRec();
        e.toSend = t;
        e.urlToSend = u;
        e.xmlSend = xml;
        return e;
    }

    public EncapsuledMessageRecV3 prepareMessageV3(ConsultarLoteRpsEnvio t, String url) throws MalformedURLException, JAXBException, NFseException {
        URL u = new URL(url);
        String xml = MarshallerUtil.mashall(t);
        EncapsuledMessageRecV3 e = new EncapsuledMessageRecV3();
        try {
            xml = new NFseAssinaturaXML().assinarXMLConsultaLoteRPS(xml);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new NFseException(ex);
        }
        this.saveArquivo("CONSULTA.xml", xml);
        e.toSend = t;
        e.urlToSend = u;
        e.xmlSend = xml;
        return e;
    }

    private void saveArquivo(String name, String xml) {
        try {
            File f = new File(name);
            f.createNewFile();
            FileOutputStream bos = new FileOutputStream(f);
            bos.write(xml.getBytes());
            bos.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String enviarConsultaEnvioLoteRPS(URL u, String conteudo) throws AxisFault, RemoteException, NFseException {
        return null;
    }

    private String enviarConsultaEnvioLoteRPSV3(URL u, String conteudo) throws AxisFault, RemoteException, NFseException {
        return null;
    }

    public static class EncapsuledMessageRec {
        private String xmlSend;
        private String xmlReceive;
        private URL urlToSend;
        private ConsultarLoteRpsEnvio toSend;
        private ConsultarLoteRpsResposta toReceive;
        private String msgProcesada;
        private Object auxiliar;

        public String getXmlSend() {
            return this.xmlSend;
        }

        public String getXmlReceive() {
            return this.xmlReceive;
        }

        public URL getUrlToSend() {
            return this.urlToSend;
        }

        public ConsultarLoteRpsEnvio getToSend() {
            return this.toSend;
        }

        public ConsultarLoteRpsResposta getToReceive() {
            return this.toReceive;
        }

        public String getMsgProcesada() {
            return this.msgProcesada;
        }

        public void setMsgProcesada(String msgProcesada) {
            this.msgProcesada = msgProcesada;
        }

        public Object getAuxiliar() {
            return this.auxiliar;
        }

        public void setAuxiliar(Object auxiliar) {
            this.auxiliar = auxiliar;
        }
    }

    public static class EncapsuledMessageRecV3 {
        private String xmlSend;
        private String xmlReceive;
        private URL urlToSend;
        private ConsultarLoteRpsEnvio toSend;
        private ConsultarLoteRpsResposta toReceive;
        private String msgProcesada;
        private Object auxiliar;

        public String getXmlSend() {
            return this.xmlSend;
        }

        public String getXmlReceive() {
            return this.xmlReceive;
        }

        public URL getUrlToSend() {
            return this.urlToSend;
        }

        public ConsultarLoteRpsEnvio getToSend() {
            return this.toSend;
        }

        public ConsultarLoteRpsResposta getToReceive() {
            return this.toReceive;
        }

        public String getMsgProcesada() {
            return this.msgProcesada;
        }

        public void setMsgProcesada(String msgProcesada) {
            this.msgProcesada = msgProcesada;
        }

        public Object getAuxiliar() {
            return this.auxiliar;
        }

        public void setAuxiliar(Object auxiliar) {
            this.auxiliar = auxiliar;
        }
    }
}

