/*
 * Decompiled with CFR 0.152.
 */
package nfse.nfsev_quasar.service;

import com.touchcomp.basementorlogger.TLogger;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import javax.xml.bind.JAXBException;
import nfse.exception.NFseException;
import nfse.nfsev_quasar.model.EnviarLoteRpsEnvio;
import nfse.nfsev_quasar.model.EnviarLoteRpsResposta;
import nfse.nfsev_quasar.webservicestubs.IssDigitalControllerServiceStub;
import nfse.util.NFSeFileUtil;
import org.apache.axis2.AxisFault;
import utilities.MarshallerUtil;
import utilities.StringUtil;

public class NFSeRecepcaoLote {
    private static TLogger logger = TLogger.get(NFSeRecepcaoLote.class);

    public EncapsuledMessageRecV2 prepareMessageV2(EnviarLoteRpsEnvio t, String url) throws MalformedURLException, JAXBException, NFseException, Exception {
        URL u = new URL(url);
        String xml = MarshallerUtil.mashall(t);
        xml = xml.replaceAll(" standalone=\"yes\"", "");
        xml = xml.replaceAll(" xmlns=\"http://www.w3.org/2000/09/xmldsig#\"", " xmlns=\"http://www.abrasf.org.br/nfse.xsd\"");
        EncapsuledMessageRecV2 e = new EncapsuledMessageRecV2();
        e.toSend = t;
        e.urlToSend = u;
        e.xmlSend = xml;
        this.saveFile(xml);
        return e;
    }

    private void saveFile(String xml) {
        try {
            File file = new File(System.getProperty("user.dir"));
            File arquivo = new File(file, "envio.xml");
            arquivo.createNewFile();
            FileWriter fileWriter = new FileWriter(arquivo, false);
            PrintWriter p = new PrintWriter(fileWriter);
            p.append(xml);
            p.close();
        }
        catch (IOException ex) {
            logger.error(ex.getClass(), (Throwable)ex);
        }
    }

    public void recepcaoLoteV2(EncapsuledMessageRecV2 e) throws MalformedURLException, JAXBException, RemoteException, NFseException {
        new NFSeFileUtil().beforeEnvioLoteNFSe(e.getToSend().getLoteRps().getId());
        String result = this.enviarLoteRPSQuasar(e.getXmlSend());
        new NFSeFileUtil().afterEnvioLoteNFSe(result);
        result = this.corrigeResposta(result);
        System.out.println(result);
        try {
            EnviarLoteRpsResposta ret;
            e.toReceive = ret = (EnviarLoteRpsResposta)MarshallerUtil.umarshall(result, EnviarLoteRpsResposta.class);
        }
        catch (Throwable tr) {
            tr.printStackTrace();
            throw tr;
        }
        e.xmlReceive = result;
    }

    private String corrigeResposta(String result) {
        result = result.replaceAll("xmlns:ns3=\"http://www.abrasf.org.br/nfse.xsd\"", "");
        result = result.replaceAll("xmlns:ns2=\"http://www.w3.org/2000/09/xmldsig#\"", "xmlns=\"http://www.w3.org/2000/09/xmldsig#\"");
        result = result.replaceAll("<EnviarLoteRpsResposta  >", "<EnviarLoteRpsResposta>");
        return StringUtil.clearStringXml(result);
    }

    private String enviarLoteRPSQuasar(String conteudo) throws AxisFault, RemoteException, NFseException {
        IssDigitalControllerServiceStub s = new IssDigitalControllerServiceStub();
        IssDigitalControllerServiceStub.RecepcionarLoteRpsE rec = new IssDigitalControllerServiceStub.RecepcionarLoteRpsE();
        IssDigitalControllerServiceStub.RecepcionarLoteRps rec2 = new IssDigitalControllerServiceStub.RecepcionarLoteRps();
        rec2.setXml(conteudo);
        rec.setRecepcionarLoteRps(rec2);
        IssDigitalControllerServiceStub.RecepcionarLoteRpsResponseE r = s.recepcionarLoteRps(rec);
        String retorno2 = r.getRecepcionarLoteRpsResponse().get_return();
        return retorno2;
    }

    public String toXLMLoteRps(EnviarLoteRpsEnvio lote) throws JAXBException {
        return this.getXMLLoteRPS(lote);
    }

    private String getXMLLoteRPS(EnviarLoteRpsEnvio t) throws JAXBException {
        String xml = MarshallerUtil.mashall(t);
        xml = xml.replaceAll(" xmlns:ns2=\"http://www.w3.org/2000/09/xmldsig#\"", "");
        return xml;
    }

    public static class EncapsuledMessageRecV2 {
        private String xmlSend;
        private String xmlReceive;
        private URL urlToSend;
        private EnviarLoteRpsEnvio toSend;
        private EnviarLoteRpsResposta toReceive;
        private String msgProcesada;
        private Object auxiliar;

        public String getXmlSend() {
            return this.xmlSend;
        }

        public void setXmlSend(String xmlSend) {
            this.xmlSend = xmlSend;
        }

        public String getXmlReceive() {
            return this.xmlReceive;
        }

        public void setXmlReceive(String xmlReceive) {
            this.xmlReceive = xmlReceive;
        }

        public URL getUrlToSend() {
            return this.urlToSend;
        }

        public void setUrlToSend(URL urlToSend) {
            this.urlToSend = urlToSend;
        }

        public EnviarLoteRpsEnvio getToSend() {
            return this.toSend;
        }

        public void setToSend(EnviarLoteRpsEnvio toSend) {
            this.toSend = toSend;
        }

        public EnviarLoteRpsResposta getToReceive() {
            return this.toReceive;
        }

        public void setToReceive(EnviarLoteRpsResposta toReceive) {
            this.toReceive = toReceive;
        }

        public String getMsgProcesada() {
            return this.msgProcesada;
        }

        public void setMsgProcesada(String msgProcesada) {
            this.msgProcesada = msgProcesada;
        }

        public Object getAuxiliar() {
            return this.auxiliar;
        }

        public void setAuxiliar(Object auxiliar) {
            this.auxiliar = auxiliar;
        }
    }
}

