/*
 * Decompiled with CFR 0.152.
 */
package nfse.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import nfse.exception.NFseException;

public class NFSeFileUtil {
    public void beforeEnvioLoteNFSe(String texto) throws NFseException {
        try {
            this.writeInFileResult(texto, this.getPathNFSeEnv() + this.dateToString(new Date(), "yyyyMMdd") + "T" + this.dateToString(new Date(), "hhmmss") + "-env-lot.xml");
        }
        catch (FileNotFoundException ex) {
            throw new NFseException("Nao foi possivel escrever o arquivo/backup de envio de nfe.", ex);
        }
    }

    public void afterEnvioLoteNFSe(String texto) throws NFseException {
        try {
            this.writeInFileResult(texto, this.getPathNFSeEnv() + this.dateToString(new Date(), "yyyyMMdd") + "T" + this.dateToString(new Date(), "hhmmss") + "-resp-lot.xml");
        }
        catch (FileNotFoundException ex) {
            throw new NFseException("Nao foi possivel escrever o arquivo/backup de envio de nfe.", ex);
        }
    }

    public void beforeConsultaLoteNFSe(String texto) throws NFseException {
        try {
            this.writeInFileResult(texto, this.getPathNFSeEnv() + this.dateToString(new Date(), "yyyyMMdd") + "T" + this.dateToString(new Date(), "hhmmss") + "-cons-env-lot.xml");
        }
        catch (FileNotFoundException ex) {
            throw new NFseException("Nao foi possivel escrever o arquivo/backup de envio de nfe.", ex);
        }
    }

    public void afterConsultaEnvioLoteNFSe(String texto) throws NFseException {
        try {
            this.writeInFileResult(texto, this.getPathNFSeEnv() + this.dateToString(new Date(), "yyyyMMdd") + "T" + this.dateToString(new Date(), "hhmmss") + "-resp-cons-env-lot.xml");
        }
        catch (FileNotFoundException ex) {
            throw new NFseException("Nao foi possivel escrever o arquivo/backup de envio de nfe.", ex);
        }
    }

    public void beforeConsultaRPSNFSe(String texto) throws NFseException {
        try {
            this.writeInFileResult(texto, this.getPathConsultaRPS() + this.dateToString(new Date(), "yyyyMMdd") + "T" + this.dateToString(new Date(), "hhmmss") + "-cons-env-rps.xml");
        }
        catch (FileNotFoundException ex) {
            throw new NFseException("Nao foi possivel escrever o arquivo/backup de envio de nfe.", ex);
        }
    }

    public void afterConsultaRPSNFSe(String texto) throws NFseException {
        try {
            this.writeInFileResult(texto, this.getPathConsultaRPS() + this.dateToString(new Date(), "yyyyMMdd") + "T" + this.dateToString(new Date(), "hhmmss") + "-resp-cons-rps.xml");
        }
        catch (FileNotFoundException ex) {
            throw new NFseException("Nao foi possivel escrever o arquivo/backup de envio de nfe.", ex);
        }
    }

    public void beforeCancelaRPSNFSe(String texto) throws NFseException {
        try {
            this.writeInFileResult(texto, this.getPathCancelaRPS() + this.dateToString(new Date(), "yyyyMMdd") + "T" + this.dateToString(new Date(), "hhmmss") + "-canc-rps.xml");
        }
        catch (FileNotFoundException ex) {
            throw new NFseException("Nao foi possivel escrever o arquivo/backup de envio de nfe.", ex);
        }
    }

    public void afterCancelaRPSNFSe(String texto) throws NFseException {
        try {
            this.writeInFileResult(texto, this.getPathCancelaRPS() + this.dateToString(new Date(), "yyyyMMdd") + "T" + this.dateToString(new Date(), "hhmmss") + "-resp-canc-rps.xml");
        }
        catch (FileNotFoundException ex) {
            throw new NFseException("Nao foi possivel escrever o arquivo/backup de envio de nfe.", ex);
        }
    }

    private String getPathNFSeEnv() {
        return System.getProperty("user.dir") + "/nfse/loterps";
    }

    private String getPathConsultaRPS() {
        return System.getProperty("user.dir") + "/nfse/consultarps";
    }

    private String getPathCancelaRPS() {
        return System.getProperty("user.dir") + "/nfse/cancelarps";
    }

    private void writeInFileResult(String xml, String file) throws FileNotFoundException {
        File f = new File(file);
        f.getParentFile().mkdirs();
        PrintWriter p = new PrintWriter(f);
        p.write(xml);
        p.flush();
        p.close();
    }

    private String dateToString(Date date, String format) {
        SimpleDateFormat simple = new SimpleDateFormat(format);
        return simple.format(date);
    }
}

