/*
 * Decompiled with CFR 0.152.
 */
package nfse.validacao;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.TypeInfoProvider;
import javax.xml.validation.ValidatorHandler;
import nfse.exception.NFseValidadeException;
import org.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.xs.XSAnnotation;
import org.apache.xerces.xs.XSObjectList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class EnvNFseValidate
extends DefaultHandler {
    private TypeInfoProvider provider;
    private XSSimpleTypeDecl currentInfoSimpleElement;
    private XSComplexTypeDecl currentInfoComplexElement;
    private String currentTag;

    public void validarXML(String xml) throws NFseValidadeException {
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = factory.newSchema(this.getClass().getResource("/nfse/validacao/versao107/servico_enviar_lote_rps_envio.xsd"));
            ValidatorHandler vHandler = schema.newValidatorHandler();
            this.provider = vHandler.getTypeInfoProvider();
            vHandler.setContentHandler(this);
            XMLReader parser = XMLReaderFactory.createXMLReader();
            parser.setContentHandler(vHandler);
            parser.parse(new InputSource(new ByteArrayInputStream(xml.getBytes())));
        }
        catch (IOException ex) {
            Logger.getLogger(EnvNFseValidate.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SAXException ex) {
            ex.printStackTrace();
            this.trataMensagem(ex);
        }
    }

    @Override
    public void startElement(String namespace, String localName, String qualifiedName, Attributes atts) throws SAXException {
        if (this.provider.getElementTypeInfo() instanceof XSSimpleTypeDecl) {
            this.currentInfoSimpleElement = (XSSimpleTypeDecl)this.provider.getElementTypeInfo();
        } else if (this.provider.getElementTypeInfo() instanceof XSComplexTypeDecl) {
            this.currentInfoComplexElement = (XSComplexTypeDecl)this.provider.getElementTypeInfo();
        }
        this.currentTag = qualifiedName;
        String type = this.provider.getElementTypeInfo().getTypeName();
        System.out.println(qualifiedName + ": " + type);
    }

    private void trataMensagem(SAXException ex) throws NFseValidadeException {
        Object msg = "Erro ao validar o XML do lote de notas fiscais. Verifique as seguintes Observacoes nas NFs:\n ";
        msg = (String)msg + ex.getMessage();
        throw new NFseValidadeException((String)msg);
    }

    private String getFormattedAnnotation(XSObjectList ann) {
        Object msg = "";
        for (int j = 0; j < ann.getLength(); ++j) {
            msg = (String)msg + this.clearMensagem(((XSAnnotation)ann.item(j)).getAnnotationString());
            msg = (String)msg + "\n";
        }
        return msg;
    }

    private String clearMensagem(String msg) {
        if (msg == null) {
            return "";
        }
        int indexStart = msg.indexOf("<xs:documentation>");
        int indexEnd = msg.indexOf("</xs:documentation>");
        if (indexStart > -1) {
            msg = msg.substring(indexStart + 18, indexEnd);
        }
        return msg;
    }
}

