/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.io.File;
import java.util.HashMap;
import java.util.Scanner;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FileUtilities
extends DefaultHandler {
    StringBuffer current = new StringBuffer();
    HashMap defaultValues = null;
    String currentKey = "";

    public static String getTextOfXMLFile(File f, HashMap defaultValues) throws Exception {
        StringBuffer current = new StringBuffer();
        Scanner scanner = new Scanner(f);
        while (scanner.hasNext()) {
            current.append(scanner.nextLine());
        }
        return current.toString();
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.currentKey = localName;
        this.current.append("<");
        this.current.append(localName);
        if (uri != null) {
            this.current.append(" xmlns=\"" + uri + "\"");
        }
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                this.current.append(" ");
                String name = attributes.getQName(i);
                String value = attributes.getValue(i);
                this.current.append(name + "=\"");
                this.current.append(value + "\"");
            }
        }
        this.current.append(">");
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.current.append("</" + localName + ">");
        this.currentKey = null;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentKey != null && this.defaultValues.containsKey(this.currentKey)) {
            String value = (String)this.defaultValues.get(this.currentKey);
            if (value != null) {
                this.current.append(value.toString());
            }
        } else {
            this.current.append(String.copyValueOf(ch, start, start + length));
        }
    }
}

