/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;

public class StringUtil {
    public static String refina(String cadastro) {
        Object cadastroRefinado = "";
        if (cadastro == null) {
            return "";
        }
        for (int i = 0; i < cadastro.length(); ++i) {
            char carac = cadastro.charAt(i);
            if (carac == '/' || carac == '.' || carac == '-' || carac == ' ' || carac == ',') continue;
            cadastroRefinado = (String)cadastroRefinado + String.valueOf(carac);
        }
        return cadastroRefinado;
    }

    public static String preencheString(String valor, int tamanho, char simbolo, boolean completaEsquerda) {
        StringBuffer sb = null;
        if (valor == null) {
            valor = "";
        }
        sb = new StringBuffer(valor);
        for (int i = valor.length(); i < tamanho; ++i) {
            if (completaEsquerda) {
                sb.insert(0, simbolo);
                continue;
            }
            sb.append(simbolo);
        }
        return sb.toString();
    }

    public static String completaEspacos(String valor, int tamanho, boolean completaEsquerda) {
        if (valor != null && valor.length() > tamanho) {
            return valor.substring(0, tamanho);
        }
        return StringUtil.preencheString(valor, tamanho, ' ', completaEsquerda);
    }

    public static String completaEspacos(String valor, int tamanho) {
        return StringUtil.completaEspacos(valor, tamanho, false);
    }

    public static String completaZeros(String valor, int tamanho, boolean completaEsquerda) {
        return StringUtil.preencheString(valor, tamanho, '0', completaEsquerda);
    }

    public static String completaZeros(String valor, int tamanho) {
        return StringUtil.completaZeros(valor, tamanho, false);
    }

    public static String clearInvalidUTF8Char(String input) {
        StringBuilder ret = new StringBuilder();
        for (char c : input.toCharArray()) {
            String str = String.valueOf(c);
            if (StringUtil.isUTF8MisInterpreted(str)) {
                ret.append(str);
                continue;
            }
            System.out.println("Invalid UTF-8 Char: " + str);
        }
        return ret.toString();
    }

    public static boolean isUTF8MisInterpreted(String input) {
        return StringUtil.isUTF8MisInterpreted(input, "Windows-1252");
    }

    public static boolean isUTF8MisInterpreted(String input, String encoding) {
        ByteBuffer tmp;
        CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder();
        CharsetEncoder encoder = Charset.forName(encoding).newEncoder();
        try {
            tmp = encoder.encode(CharBuffer.wrap(input));
        }
        catch (CharacterCodingException e) {
            return false;
        }
        try {
            decoder.decode(tmp);
            return true;
        }
        catch (CharacterCodingException e) {
            return false;
        }
    }

    public static void main(String[] args) {
        System.out.println(StringUtil.clearInvalidUTF8Char("\u00e1\u00e1\u00c1"));
    }

    public static String clearStringXml(String toClear) {
        if (toClear == null) {
            return "";
        }
        char[] c = toClear.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < c.length; ++i) {
            char a = c[i];
            char ch = a;
            if (ch == '\u00e7') {
                sb.append('c');
                continue;
            }
            if (ch == '\u00c1' || ch == '\u00c3' || ch == '\u00c2') {
                sb.append('A');
                continue;
            }
            if (ch == '\u00c7' || ch == '\u00e7') {
                sb.append('C');
                continue;
            }
            if (ch == '\u00c9' || ch == '\u00ca') {
                sb.append('E');
                continue;
            }
            if (ch == '\u00cd' || ch == '\u00ce') {
                sb.append('I');
                continue;
            }
            if (ch == '\u00d3' || ch == '\u00d4' || ch == '\u00d5') {
                sb.append('O');
                continue;
            }
            if (ch == '\u00da' || ch == '\u00db') {
                sb.append('U');
                continue;
            }
            if (ch == '\u00e1' || ch == '\u00e3' || ch == '\u00e2' || ch == '\u00dc') {
                sb.append('a');
                continue;
            }
            if (ch == '\u00e9' || ch == '\u00ea') {
                sb.append('e');
                continue;
            }
            if (ch == '\u00ed' || ch == '\u00ee') {
                sb.append('i');
                continue;
            }
            if (ch == '\u00f3' || ch == '\u00f5' || ch == '\u00f4') {
                sb.append('o');
                continue;
            }
            if (ch == '\u00fa' || ch == '\u00fb' || ch == '\u00fc') {
                sb.append('u');
                continue;
            }
            if (ch == '\u00b0' || ch == '\u00ba' || ch == '\u00a7' || ch == '&' || ch == '\n' || ch == '\t' || ch == '\r') continue;
            sb.append(a);
        }
        return StringUtil.clearEspacosInicioFim(sb);
    }

    private static String clearEspacosInicioFim(StringBuilder sb) {
        if (sb.length() > 0) {
            int i;
            for (i = 0; sb.length() > i && sb.charAt(i) == ' '; ++i) {
            }
            String result = sb.substring(i);
            for (i = result.length() - 1; i >= 0 && result.charAt(i) == ' '; --i) {
            }
            result = result.substring(0, i + 1);
            return StringUtil.clearInvalidUTF8Char(result);
        }
        return StringUtil.clearInvalidUTF8Char(sb.toString());
    }
}

