/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.template;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.ODSingleXMLDocument;
import org.jopendocument.dom.template.TemplateException;
import org.jopendocument.dom.template.engine.DataModel;
import org.jopendocument.dom.template.engine.Material;
import org.jopendocument.dom.template.engine.Parsed;

public class Template {
    protected final Parsed<ODPackage> contentTemplate;

    public Template(InputStream inputStream) throws IOException, TemplateException {
        this(new ODPackage(inputStream));
    }

    public Template(File file) throws IOException, TemplateException {
        this(new ODPackage(file));
    }

    public Template(ODPackage oDPackage) throws IOException, TemplateException {
        oDPackage.toSingle();
        this.contentTemplate = new Parsed<ODPackage>(Material.from(oDPackage));
    }

    public void createDocument(DataModel dataModel, OutputStream outputStream) throws IOException, TemplateException {
        this.execute(dataModel).save(outputStream);
    }

    public ODSingleXMLDocument createDocument(DataModel dataModel) throws TemplateException {
        return (ODSingleXMLDocument)this.execute(dataModel).getContent();
    }

    private ODPackage execute(DataModel dataModel) throws TemplateException {
        return this.contentTemplate.execute(dataModel);
    }
}

