/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jopendocument.util.CollectionUtils;
import org.jopendocument.util.ExceptionUtils;
import org.jopendocument.util.RecursionType;
import org.jopendocument.util.StreamUtils;
import org.jopendocument.util.StringUtils;
import org.jopendocument.util.cc.ExnTransformer;
import org.jopendocument.util.cc.IClosure;

public final class FileUtils {
    public static final Set<String> VersionControl = CollectionUtils.createSet(".svn", "CVS");
    private static final Map<URL, File> files = new HashMap<URL, File>();
    private static final Map<String, String> ext2mime = new HashMap<String, String>();
    public static final Collection<Character> INVALID_CHARS;
    public static final StringUtils.Escaper FILENAME_ESCAPER;
    public static final FileFilter DIR_FILTER;
    public static final FileFilter REGULAR_FILE_FILTER;

    private FileUtils() {
    }

    public static List<String> listR(File file) {
        return FileUtils.listR_rec(file, ".");
    }

    private static List<String> listR_rec(File file, String string) {
        if (!file.isDirectory()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            String string2 = string + "/" + fileArray[i].getName();
            if (fileArray[i].isFile()) {
                arrayList.add(string2);
                continue;
            }
            if (!fileArray[i].isDirectory()) continue;
            arrayList.addAll(FileUtils.listR_rec(fileArray[i], string2));
        }
        return arrayList;
    }

    public static void walk(File file, IClosure<File> iClosure) {
        FileUtils.walk(file, iClosure, RecursionType.BREADTH_FIRST);
    }

    public static void walk(File file, IClosure<File> iClosure, RecursionType recursionType) {
        if (recursionType == RecursionType.BREADTH_FIRST) {
            iClosure.executeChecked(file);
        }
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                FileUtils.walk(file2, iClosure, recursionType);
            }
        }
        if (recursionType == RecursionType.DEPTH_FIRST) {
            iClosure.executeChecked(file);
        }
    }

    public static final List<File> list(File file, int n) {
        return FileUtils.list(file, n, null);
    }

    public static final List<File> list(File file, int n, FileFilter fileFilter) {
        if (!file.exists()) {
            return Collections.emptyList();
        }
        if (n == 0) {
            return fileFilter.accept(file) ? Collections.singletonList(file) : Collections.emptyList();
        }
        if (n == 1) {
            File[] fileArray = file.listFiles(fileFilter);
            if (fileArray == null) {
                throw new IllegalStateException("cannot list " + file);
            }
            return Arrays.asList(fileArray);
        }
        File[] fileArray = file.listFiles(DIR_FILTER);
        if (fileArray == null) {
            throw new IllegalStateException("cannot list " + file);
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file2 : fileArray) {
            arrayList.addAll(FileUtils.list(file2, n - 1, fileFilter));
        }
        return arrayList;
    }

    public static final String relative(File file, File file2) throws IOException {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(file + " is not a directory");
        }
        File file3 = file.getCanonicalFile();
        File file4 = file2.getCanonicalFile();
        List<File> list = FileUtils.getAncestors(file4);
        List<File> list2 = FileUtils.getAncestors(file3);
        if (!list.get(0).equals(list2.get(0))) {
            throw new IllegalArgumentException("'" + file3 + "' and '" + file4 + "' have no common ancestor");
        }
        int n = Math.min(list.size(), list2.size()) - 1;
        boolean bl = false;
        while (n >= 0 && !bl) {
            bl = list2.get(n).equals(list.get(n));
            if (bl) continue;
            --n;
        }
        ArrayList<String> arrayList = new ArrayList<String>(Collections.nCopies(list2.size() - 1 - n, ".."));
        if (arrayList.isEmpty()) {
            arrayList.add(".");
        }
        for (File file5 : list.subList(n + 1, list.size())) {
            arrayList.add(file5.getName());
        }
        return CollectionUtils.join(arrayList, File.separator);
    }

    public static final List<File> getAncestors(File file) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file2 = file; file2 != null; file2 = file2.getParentFile()) {
            arrayList.add(0, file2);
        }
        return arrayList;
    }

    public static final File addSuffix(File file, String string) {
        return new File(file.getParentFile(), file.getName() + string);
    }

    public static String mv(File file, File file2) {
        File file3;
        File file4;
        try {
            file4 = file.getCanonicalFile();
            file3 = file2.getCanonicalFile();
        }
        catch (IOException iOException) {
            return ExceptionUtils.getStackTrace(iOException);
        }
        if (file4.equals(file3)) {
            return null;
        }
        if (file3.isDirectory()) {
            file3 = new File(file3, file4.getName());
        }
        if (file3.exists()) {
            return file3 + " exists";
        }
        if (!file3.getParentFile().exists()) {
            return "parent of " + file3 + " does not exist";
        }
        File file5 = file3;
        if (!file4.renameTo(file5)) {
            try {
                FileUtils.copyDirectory(file4, file5);
                if (file5.exists()) {
                    FileUtils.rmR(file4);
                }
            }
            catch (IOException iOException) {
                return ExceptionUtils.getStackTrace(iOException);
            }
        }
        return null;
    }

    public static void copyFile(File file, File file2) throws IOException {
        FileChannel fileChannel = new FileInputStream(file).getChannel();
        FileChannel fileChannel2 = new FileOutputStream(file2).getChannel();
        fileChannel.transferTo(0L, fileChannel.size(), fileChannel2);
        fileChannel.close();
        fileChannel2.close();
    }

    public static void copyDirectory(File file, File file2) throws IOException {
        FileUtils.copyDirectory(file, file2, Collections.<String>emptySet());
    }

    public static void copyDirectory(File file, File file2, Set<String> set) throws IOException {
        if (set.contains(file.getName())) {
            return;
        }
        if (file.isDirectory()) {
            if (!file2.exists()) {
                file2.mkdir();
            }
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                FileUtils.copyDirectory(new File(file, stringArray[i]), new File(file2, stringArray[i]), set);
            }
        } else if (!file.getName().equals("Thumbs.db")) {
            FileUtils.copyFile(file, file2);
        }
    }

    public static boolean rmR(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                boolean bl = FileUtils.rmR(fileArray[i]);
                if (bl) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static final File mkdir_p(File file) throws IOException {
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("cannot create directory " + file);
        }
        return file;
    }

    public static final String read(File file) throws IOException {
        return FileUtils.read(file, null);
    }

    public static final String read(File file, String string) throws IOException {
        return FileUtils.read(new FileInputStream(file), string);
    }

    public static final String read(InputStream inputStream, String string) throws IOException {
        InputStreamReader inputStreamReader = string == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string);
        return FileUtils.read(inputStreamReader);
    }

    public static final String read(Reader reader) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(reader);
        String string2 = "";
        while ((string = bufferedReader.readLine()) != null) {
            string2 = string2 + string + "\n";
        }
        bufferedReader.close();
        return string2;
    }

    public static final byte[] readBytes(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        if (file.length() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("file longer than Integer.MAX_VALUE" + file.length());
        }
        byte[] byArray = new byte[(int)file.length()];
        ((InputStream)fileInputStream).read(byArray);
        ((InputStream)fileInputStream).close();
        return byArray;
    }

    public static void write(String string, File file) throws IOException {
        FileUtils.write(string, file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(String string, File file, boolean bl) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file, bl)));
        try {
            bufferedWriter.write(string);
        }
        finally {
            bufferedWriter.close();
        }
    }

    public static final <T> T doWithLock(File file, ExnTransformer<RandomAccessFile, T, ?> exnTransformer) throws Exception {
        RandomAccessFile randomAccessFile = null;
        try {
            FileUtils.mkdir_p(file.getParentFile());
            randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.getChannel().lock();
            T t = exnTransformer.transformChecked(randomAccessFile);
            randomAccessFile.close();
            randomAccessFile = null;
            return t;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {
                    exception2 = ExceptionUtils.createExn(IOException.class, "couldn't close: " + iOException.getMessage(), exception);
                }
            }
            throw exception2;
        }
    }

    private static final File getShortCutFile() throws IOException {
        return FileUtils.getFile(FileUtils.class.getResource("shortcut.vbs"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final File getFile(URL uRL) throws IOException {
        File file;
        File file2 = files.get(uRL);
        if (file2 == null || !file2.exists()) {
            file = File.createTempFile("windowsIsLame", ".vbs");
            file.deleteOnExit();
            files.put(uRL, file);
            InputStream inputStream = uRL.openStream();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                StreamUtils.copy(inputStream, fileOutputStream);
            }
            finally {
                fileOutputStream.close();
                inputStream.close();
            }
        } else {
            file = file2;
        }
        return file;
    }

    public static final File ln(File file, File file2) throws IOException {
        File file3;
        Process process;
        String string = System.getProperty("os.name");
        if (string.startsWith("Windows")) {
            process = Runtime.getRuntime().exec(new String[]{"cscript", FileUtils.getShortCutFile().getAbsolutePath(), file2.getAbsolutePath(), file.getCanonicalPath()});
            file3 = new File(file2.getParentFile(), file2.getName() + ".LNK");
        } else {
            String string2 = FileUtils.relative(file2.getAbsoluteFile().getParentFile(), file);
            String[] stringArray = new String[]{"ln", "-sfn", string2, file2.getAbsolutePath()};
            process = Runtime.getRuntime().exec(stringArray);
            file3 = file2;
        }
        try {
            int n = process.waitFor();
            if (n == 0) {
                return file3;
            }
            throw new IOException("Abnormal exit value: " + n);
        }
        catch (InterruptedException interruptedException) {
            throw ExceptionUtils.createExn(IOException.class, "interrupted", interruptedException);
        }
    }

    public static final File readlink(File file) throws IOException {
        String string = System.getProperty("os.name");
        Process process = string.startsWith("Windows") ? Runtime.getRuntime().exec(new String[]{"cscript", "//NoLogo", FileUtils.getShortCutFile().getAbsolutePath(), file.getAbsolutePath()}) : Runtime.getRuntime().exec(new String[]{"readlink", "-f", file.getAbsolutePath()});
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string2 = bufferedReader.readLine();
            bufferedReader.close();
            if (process.waitFor() != 0 || string2 == null || string2.length() == 0) {
                return null;
            }
            return new File(string2);
        }
        catch (InterruptedException interruptedException) {
            throw ExceptionUtils.createExn(IOException.class, "interrupted", interruptedException);
        }
    }

    public static final void open(File file, String[] stringArray) throws IOException {
        try {
            FileUtils.openNative(file);
        }
        catch (IOException iOException) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                try {
                    Runtime.getRuntime().exec(new String[]{string, file.getCanonicalPath()});
                    return;
                }
                catch (IOException iOException2) {
                    continue;
                }
            }
            throw ExceptionUtils.createExn(IOException.class, "unable to open " + file + " with: " + Arrays.asList(stringArray), iOException);
        }
    }

    private static final void openNative(File file) throws IOException {
        String[] stringArray;
        String string = System.getProperty("os.name");
        if (string.startsWith("Windows")) {
            stringArray = new String[]{"cmd", "/c", "start", "\"\"", file.getCanonicalPath()};
        } else if (string.startsWith("Mac OS")) {
            stringArray = new String[]{"open", file.getCanonicalPath()};
        } else if (string.startsWith("Linux")) {
            stringArray = new String[]{"xdg-open", file.getCanonicalPath()};
        } else {
            throw new IOException("unknown way to open " + file);
        }
        try {
            int n = Runtime.getRuntime().exec(stringArray).waitFor();
            if (n != 0) {
                throw new IOException("error (" + n + ") executing " + Arrays.asList(stringArray));
            }
        }
        catch (InterruptedException interruptedException) {
            throw ExceptionUtils.createExn(IOException.class, "interrupted waiting for " + Arrays.asList(stringArray), interruptedException);
        }
    }

    static final boolean gnomeRunning() {
        try {
            return Runtime.getRuntime().exec(new String[]{"pgrep", "-u", System.getProperty("user.name"), "nautilus"}).waitFor() == 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static final String findMimeType(String string) {
        for (Map.Entry<String, String> entry : ext2mime.entrySet()) {
            if (!string.toLowerCase().endsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public static final FileFilter createEndFileFilter(final String string) {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && file.getName().endsWith(string);
            }
        };
    }

    static {
        ext2mime.put(".xml", "text/xml");
        ext2mime.put(".jpg", "image/jpeg");
        ext2mime.put(".png", "image/png");
        ext2mime.put(".tiff", "image/tiff");
        FILENAME_ESCAPER = new StringUtils.Escaper('\'', 'Q');
        FILENAME_ESCAPER.add('\"', 'D').add(':', 'C').add('/', 'S').add('\\', 'A');
        FILENAME_ESCAPER.add('<', 'L').add('>', 'G').add('*', 'R').add('|', 'P').add('?', 'M');
        INVALID_CHARS = FILENAME_ESCAPER.getEscapedChars();
        DIR_FILTER = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        };
        REGULAR_FILE_FILTER = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile();
            }
        };
    }
}

