/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.renderers;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.type.ImageTypeEnum;
import net.sf.jasperreports.engine.util.JRImageLoader;
import net.sf.jasperreports.renderers.AbstractRenderToImageAwareRenderer;
import net.sf.jasperreports.renderers.DataRenderable;
import net.sf.jasperreports.renderers.DimensionRenderable;
import net.sf.jasperreports.renderers.Graphics2DRenderable;

public abstract class AbstractRenderToImageDataRenderer
extends AbstractRenderToImageAwareRenderer
implements Graphics2DRenderable,
DataRenderable,
DimensionRenderable {
    private static final long serialVersionUID = 10200L;
    public static final String EXCEPTION_MESSAGE_KEY_DIMENSION_MUST_OVERRIDE = "engine.renderable.svg.dimension.must.override";
    public static final String EXCEPTION_MESSAGE_KEY_DIMENSION_NULL_NOT_ALLOWED = "engine.renderable.svg.dimension.null.not.allowed";

    @Override
    public Dimension2D getDimension(JasperReportsContext jasperReportsContext) throws JRException {
        throw new JRException(EXCEPTION_MESSAGE_KEY_DIMENSION_MUST_OVERRIDE, new Object[]{this.getClass().getName()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getData(JasperReportsContext jasperReportsContext) throws JRException {
        Dimension2D dimension = this.getDimension(jasperReportsContext);
        if (dimension == null) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_DIMENSION_NULL_NOT_ALLOWED, (Object[])null);
        }
        int dpi = this.getImageDataDPI(jasperReportsContext);
        double scale = (double)dpi / 72.0;
        BufferedImage bi = new BufferedImage((int)(scale * dimension.getWidth()), (int)(scale * dimension.getHeight()), 2);
        Graphics2D g = this.createGraphics(bi);
        try {
            g.scale(scale, scale);
            Color backcolor = this.getBackcolor();
            if (backcolor != null) {
                g.setColor(backcolor);
                g.fillRect(0, 0, (int)dimension.getWidth(), (int)dimension.getHeight());
            }
            this.render(jasperReportsContext, g, new Rectangle((int)dimension.getWidth(), (int)dimension.getHeight()));
        }
        finally {
            g.dispose();
        }
        return JRImageLoader.getInstance(jasperReportsContext).loadBytesFromAwtImage(bi, ImageTypeEnum.PNG);
    }

    protected Color getBackcolor() {
        return null;
    }
}

