/*
 * Decompiled with CFR 0.152.
 */
package com.sanctionco.jmail;

import com.sanctionco.jmail.Email;
import com.sanctionco.jmail.InvalidEmailException;
import com.sanctionco.jmail.JMail;
import com.sanctionco.jmail.TopLevelDomain;
import com.sanctionco.jmail.ValidationRules;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class EmailValidator {
    private static final Predicate<Email> DISALLOW_IP_DOMAIN_PREDICATE = ValidationRules::disallowIpDomain;
    private static final Predicate<Email> REQUIRE_TOP_LEVEL_DOMAIN_PREDICATE = ValidationRules::requireTopLevelDomain;
    private static final Predicate<Email> DISALLOW_EXPLICIT_SOURCE_ROUTING = ValidationRules::disallowExplicitSourceRouting;
    private static final Predicate<Email> DISALLOW_QUOTED_IDENTIFIERS = ValidationRules::disallowQuotedIdentifiers;
    private static final Predicate<Email> DISALLOW_RESERVED_DOMAINS_PREDICATE = ValidationRules::disallowReservedDomains;
    private static final Predicate<Email> DISALLOW_OBSOLETE_WHITESPACE_PREDICATE = ValidationRules::disallowObsoleteWhitespace;
    private final Set<Predicate<Email>> validationPredicates;

    EmailValidator(Set<Predicate<Email>> validationPredicates) {
        this.validationPredicates = Collections.unmodifiableSet(validationPredicates);
    }

    EmailValidator() {
        this(new HashSet<Predicate<Email>>());
    }

    public EmailValidator withRules(Collection<Predicate<Email>> rules) {
        HashSet<Predicate<Email>> ruleSet = new HashSet<Predicate<Email>>(this.validationPredicates);
        ruleSet.addAll(rules);
        return new EmailValidator(ruleSet);
    }

    public EmailValidator withRule(Predicate<Email> rule) {
        return this.withRules(Collections.singletonList(rule));
    }

    public EmailValidator disallowIpDomain() {
        return this.withRule(DISALLOW_IP_DOMAIN_PREDICATE);
    }

    public EmailValidator requireTopLevelDomain() {
        return this.withRule(REQUIRE_TOP_LEVEL_DOMAIN_PREDICATE);
    }

    public EmailValidator disallowExplicitSourceRouting() {
        return this.withRule(DISALLOW_EXPLICIT_SOURCE_ROUTING);
    }

    public EmailValidator disallowQuotedIdentifiers() {
        return this.withRule(DISALLOW_QUOTED_IDENTIFIERS);
    }

    public EmailValidator disallowReservedDomains() {
        return this.withRule(DISALLOW_RESERVED_DOMAINS_PREDICATE);
    }

    public EmailValidator requireOnlyTopLevelDomains(TopLevelDomain ... allowed) {
        return this.withRule(email -> ValidationRules.requireOnlyTopLevelDomains(email, Arrays.stream(allowed).collect(Collectors.toSet())));
    }

    public EmailValidator disallowObsoleteWhitespace() {
        return this.withRule(DISALLOW_OBSOLETE_WHITESPACE_PREDICATE);
    }

    public boolean isValid(String email) {
        return JMail.tryParse(email).filter(this::passesPredicates).isPresent();
    }

    public boolean isInvalid(String email) {
        return !this.isValid(email);
    }

    public void enforceValid(String email) throws InvalidEmailException {
        if (!this.isValid(email)) {
            throw new InvalidEmailException();
        }
    }

    public Optional<Email> tryParse(String email) {
        return JMail.tryParse(email).filter(this::passesPredicates);
    }

    private boolean passesPredicates(Email email) {
        return this.validationPredicates.stream().allMatch(rule -> rule.test(email));
    }

    public String toString() {
        return new StringJoiner(", ", EmailValidator.class.getSimpleName() + "[", "]").add("validationRuleCount=" + this.validationPredicates.size()).toString();
    }
}

