/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.examples;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.undo.UndoManager;
import org.dts.spell.SpellChecker;
import org.dts.spell.dictionary.OpenOfficeSpellDictionary;
import org.dts.spell.dictionary.SpellDictionary;
import org.dts.spell.swing.JTextComponentSpellChecker;
import org.dts.spell.swing.utils.ErrorMsgBox;

public class JMySpellApplet
extends JApplet {
    private JTextComponentSpellChecker textSpellChecker = null;
    private JTextArea textArea = null;
    private UndoManager undoManager = null;
    private SpellChecker checker = null;
    private Action newAction;
    private Action checkAction;
    private Action realTimeCheckAction;
    private Action copyAction;
    private Action cutAction;
    private Action pasteAction;
    private Action selectAllAction;
    private Action undoAction;
    private Action redoAction;
    private static final ResourceBundle messages = ResourceBundle.getBundle("org/dts/spell/examples/messages");

    private Icon getIcon(String name) {
        return new ImageIcon(this.getClass().getResource(name));
    }

    private SpellDictionary getDictionary() throws IOException {
        return this.getDictionary(this.getParameter("dictionary.1"));
    }

    private SpellDictionary getDictionary(String dict) throws IOException {
        URL url = new URL(this.getCodeBase(), dict);
        return new OpenOfficeSpellDictionary(url.openStream(), (File)null);
    }

    private JTextArea createTextArea() {
        JTextArea result = new JTextArea();
        result.setWrapStyleWord(true);
        result.setLineWrap(true);
        this.undoManager = new UndoManager();
        result.getDocument().addUndoableEditListener(this.undoManager);
        return result;
    }

    private Action createNewAction() {
        AbstractAction result = new AbstractAction(messages.getString("NEW_ACTION_NAME"), this.getIcon("images/stock_new.png")){

            public void actionPerformed(ActionEvent e) {
                JMySpellApplet.this.stop();
                JMySpellApplet.this.textArea.setText("");
                System.gc();
                JMySpellApplet.this.start();
            }
        };
        result.putValue("MnemonicKey", JMySpellApplet.getMNemonic("NEW_ACTION_MNEMONIC"));
        result.putValue("AcceleratorKey", KeyStroke.getKeyStroke(messages.getString("NEW_ACTION_ACCELERATOR")));
        result.putValue("ShortDescription", messages.getString("NEW_ACTION_TOOLTIP"));
        return result;
    }

    private Action createCheckAction() {
        AbstractAction result = new AbstractAction(messages.getString("SPELL_CHECK_ACTION_NAME"), this.getIcon("images/stock_spellcheck.png")){

            public void actionPerformed(ActionEvent e) {
                if (JMySpellApplet.this.textSpellChecker.spellCheck(JMySpellApplet.this.textArea)) {
                    JOptionPane.showMessageDialog(JMySpellApplet.this.textArea, messages.getString("TEXT_IS_OK_MSG"));
                }
                JMySpellApplet.this.textArea.requestFocusInWindow();
            }
        };
        result.putValue("MnemonicKey", JMySpellApplet.getMNemonic("SPELL_CHECK_ACTION_MNEMONIC"));
        result.putValue("AcceleratorKey", KeyStroke.getKeyStroke(messages.getString("SPELL_CHECK_ACTION_ACCELERATOR")));
        result.putValue("ShortDescription", messages.getString("SPELL_CHECK_ACTION_TOOLTIP"));
        return result;
    }

    private Action createRealTimeCheckAction() {
        AbstractAction result = new AbstractAction(messages.getString("REALTIME_CHECK_ACTION_NAME"), this.getIcon("images/stock_autospellcheck.png")){

            public void actionPerformed(ActionEvent e) {
                PropertyChangeListenerForToggleActions.setSelected(this, !PropertyChangeListenerForToggleActions.isSelected(this));
                if (PropertyChangeListenerForToggleActions.isSelected(this)) {
                    JMySpellApplet.this.textSpellChecker.startRealtimeMarkErrors(JMySpellApplet.this.textArea);
                } else {
                    JMySpellApplet.this.textSpellChecker.stopRealtimeMarkErrors();
                }
                JMySpellApplet.this.textArea.requestFocusInWindow();
            }
        };
        result.putValue("MnemonicKey", JMySpellApplet.getMNemonic("REALTIME_CHECK_ACTION_MNEMONIC"));
        result.putValue("ShortDescription", messages.getString("REALTIME_CHECK_ACTION_TOOLTIP"));
        return result;
    }

    private Action findAction(String name) {
        Action[] actions = this.textArea.getActions();
        for (int i = 0; i < actions.length; ++i) {
            if (actions[i].getValue("Name") != name) continue;
            KeyStroke[] accelerator = this.textArea.getKeymap().getKeyStrokesForAction(actions[i]);
            if (null != accelerator && accelerator.length > 0) {
                actions[i].putValue("AcceleratorKey", accelerator[0]);
            }
            return actions[i];
        }
        return null;
    }

    private Action createCopyAction() {
        Action result = this.findAction("copy-to-clipboard");
        result.putValue("SmallIcon", this.getIcon("images/stock_copy.png"));
        result.putValue("Name", messages.getString("COPY_ACTION_NAME"));
        result.putValue("MnemonicKey", JMySpellApplet.getMNemonic("COPY_ACTION_MNEMONIC"));
        result.putValue("ShortDescription", messages.getString("COPY_ACTION_TOOLTIP"));
        if (result.getValue("AcceleratorKey") == null) {
            result.putValue("AcceleratorKey", KeyStroke.getKeyStroke(messages.getString("COPY_ACTION_ACCELERATOR")));
        }
        return result;
    }

    private Action createCutAction() {
        Action result = this.findAction("cut-to-clipboard");
        result.putValue("SmallIcon", this.getIcon("images/stock_cut.png"));
        result.putValue("Name", messages.getString("CUT_ACTION_NAME"));
        result.putValue("MnemonicKey", JMySpellApplet.getMNemonic("CUT_ACTION_MNEMONIC"));
        result.putValue("ShortDescription", messages.getString("CUT_ACTION_TOOLTIP"));
        if (result.getValue("AcceleratorKey") == null) {
            result.putValue("AcceleratorKey", KeyStroke.getKeyStroke(messages.getString("CUT_ACTION_ACCELERATOR")));
        }
        return result;
    }

    private Action createPasteAction() {
        Action result = this.findAction("paste-from-clipboard");
        result.putValue("SmallIcon", this.getIcon("images/stock_paste.png"));
        result.putValue("Name", messages.getString("PASTE_ACTION_NAME"));
        result.putValue("MnemonicKey", JMySpellApplet.getMNemonic("PASTE_ACTION_MNEMONIC"));
        result.putValue("ShortDescription", messages.getString("PASTE_ACTION_TOOLTIP"));
        if (result.getValue("AcceleratorKey") == null) {
            result.putValue("AcceleratorKey", KeyStroke.getKeyStroke(messages.getString("PASTE_ACTION_ACCELERATOR")));
        }
        return result;
    }

    private Action createSelectAllAction() {
        Action result = this.findAction("select-all");
        result.putValue("Name", messages.getString("SELECT_ALL_ACTION_NAME"));
        result.putValue("MnemonicKey", JMySpellApplet.getMNemonic("SELECT_ALL_ACTION_MNEMONIC"));
        result.putValue("ShortDescription", messages.getString("SELECT_ALL_ACTION_TOOLTIP"));
        if (result.getValue("AcceleratorKey") == null) {
            result.putValue("AcceleratorKey", KeyStroke.getKeyStroke(messages.getString("SELECT_ALL_ACTION_ACCELERATOR")));
        }
        return result;
    }

    private Action createUndoAction() {
        AbstractAction result = new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    if (JMySpellApplet.this.undoManager.canUndo()) {
                        JMySpellApplet.this.undoManager.undo();
                    }
                }
                catch (Exception ex) {
                    ErrorMsgBox.show((Component)JMySpellApplet.this, ex);
                }
            }
        };
        result.putValue("SmallIcon", this.getIcon("images/stock_undo.png"));
        result.putValue("AcceleratorKey", KeyStroke.getKeyStroke(messages.getString("UNDO_ACTION_ACCELERATOR")));
        return result;
    }

    private Action createRedoAction() {
        AbstractAction result = new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    if (JMySpellApplet.this.undoManager.canRedo()) {
                        JMySpellApplet.this.undoManager.redo();
                    }
                }
                catch (Exception ex) {
                    ErrorMsgBox.show((Component)JMySpellApplet.this, ex);
                }
            }
        };
        result.putValue("SmallIcon", this.getIcon("images/stock_redo.png"));
        result.putValue("AcceleratorKey", KeyStroke.getKeyStroke(messages.getString("REDO_ACTION_ACCELERATOR")));
        return result;
    }

    private void createActions() {
        this.newAction = this.createNewAction();
        this.checkAction = this.createCheckAction();
        this.realTimeCheckAction = this.createRealTimeCheckAction();
        this.copyAction = this.createCopyAction();
        this.cutAction = this.createCutAction();
        this.pasteAction = this.createPasteAction();
        this.selectAllAction = this.createSelectAllAction();
        this.undoAction = this.createUndoAction();
        this.redoAction = this.createRedoAction();
        this.textArea.getDocument().addDocumentListener(new ContentDependActionUptater());
        this.textArea.addCaretListener(new SelectionActionUpdater());
    }

    private JPanel createDictionaries() {
        JPanel result = new JPanel(new BorderLayout());
        result.setOpaque(false);
        JComboBox<String> combo = new JComboBox<String>();
        String baseName = "dictionary";
        int i = 1;
        String dict = this.getParameter(baseName + "." + i);
        while (null != dict) {
            combo.addItem(dict);
            dict = this.getParameter(baseName + "." + ++i);
        }
        combo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    try {
                        String newDictName = (String)e.getItem();
                        SpellDictionary newDict = JMySpellApplet.this.getDictionary(newDictName);
                        JMySpellApplet.this.stop();
                        JMySpellApplet.this.checker.setDictionary(newDict);
                        JMySpellApplet.this.start();
                    }
                    catch (IOException ex) {
                        ErrorMsgBox.show((Component)JMySpellApplet.this, ex);
                    }
                }
            }
        });
        combo.setFocusable(true);
        result.add(combo, "South");
        JLabel label = new JLabel(messages.getString("DICTIONARY_LABEL"));
        label.setLabelFor(combo);
        label.setDisplayedMnemonic(JMySpellApplet.getMNemonic("DICTIONARY_LABEL_MNEMONIC"));
        result.add((Component)label, "North");
        return result;
    }

    private AbstractButton createToolBarButton(Action action, boolean toggle) {
        AbstractButton result = toggle ? new JActionToggleButton() : new JButton();
        result.putClientProperty("hideActionText", Boolean.TRUE);
        result.setAction(action);
        result.setFocusable(false);
        return result;
    }

    private JComponent createToolBar() {
        JToolBar result = new JToolBar(messages.getString("TOOLBAR_TITLE"));
        result.add(this.createToolBarButton(this.newAction, false));
        result.addSeparator();
        result.add(this.createToolBarButton(this.checkAction, false));
        result.add(this.createToolBarButton(this.realTimeCheckAction, true));
        result.addSeparator();
        result.add(this.createToolBarButton(this.undoAction, false));
        result.add(this.createToolBarButton(this.redoAction, false));
        result.addSeparator();
        result.add(this.createToolBarButton(this.cutAction, false));
        result.add(this.createToolBarButton(this.copyAction, false));
        result.add(this.createToolBarButton(this.pasteAction, false));
        result.addSeparator();
        result.add(this.createDictionaries());
        result.setFloatable(false);
        result.setFocusable(false);
        return result;
    }

    private JPopupMenu createContextEditMenu() {
        JPopupMenu result = new JPopupMenu(messages.getString("EDIT_MENU"));
        result.add(new JMenuItem(this.undoAction));
        result.add(new JMenuItem(this.redoAction));
        result.addSeparator();
        result.add(new JMenuItem(this.cutAction));
        result.add(new JMenuItem(this.copyAction));
        result.add(new JMenuItem(this.pasteAction));
        result.addSeparator();
        result.add(new JMenuItem(this.selectAllAction));
        return result;
    }

    private JMenuBar createMenuBar() {
        JMenuBar result = new JMenuBar();
        JMenu fileMenu = new JMenu(messages.getString("FILE_MENU"));
        fileMenu.setMnemonic(JMySpellApplet.getMNemonic("FILE_MENU_MNEMONIC"));
        fileMenu.add(new JMenuItem(this.newAction));
        result.add(fileMenu);
        JMenu editMenu = new JMenu(messages.getString("EDIT_MENU"));
        editMenu.setMnemonic(JMySpellApplet.getMNemonic("EDIT_MENU_MNEMONIC"));
        editMenu.add(new JMenuItem(this.undoAction));
        editMenu.add(new JMenuItem(this.redoAction));
        editMenu.addSeparator();
        editMenu.add(new JMenuItem(this.cutAction));
        editMenu.add(new JMenuItem(this.copyAction));
        editMenu.add(new JMenuItem(this.pasteAction));
        editMenu.addSeparator();
        editMenu.add(new JMenuItem(this.selectAllAction));
        result.add(editMenu);
        JMenu spellMenu = new JMenu(messages.getString("SPELL_MENU"));
        spellMenu.setMnemonic(JMySpellApplet.getMNemonic("SPELL_MENU_MNEMONIC"));
        spellMenu.add(new JMenuItem(this.checkAction));
        spellMenu.add(new JActionCheckBoxButton(this.realTimeCheckAction));
        result.add(spellMenu);
        return result;
    }

    public void init() {
        try {
            SpellDictionary dict = this.getDictionary();
            this.checker = new SpellChecker(dict);
            this.textSpellChecker = new JTextComponentSpellChecker(this.checker);
            this.textArea = this.createTextArea();
            this.createActions();
            this.setJMenuBar(this.createMenuBar());
            this.textArea.setComponentPopupMenu(this.createContextEditMenu());
            this.add((Component)this.createToolBar(), "North");
            this.add((Component)new JScrollPane(this.textArea), "Center");
            this.textArea.requestFocusInWindow();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorMsgBox.show(ex);
        }
    }

    public void start() {
        if (PropertyChangeListenerForToggleActions.isSelected(this.realTimeCheckAction)) {
            this.textSpellChecker.startRealtimeMarkErrors(this.textArea);
        }
        this.textArea.requestFocusInWindow();
    }

    public void stop() {
        if (PropertyChangeListenerForToggleActions.isSelected(this.realTimeCheckAction)) {
            this.textSpellChecker.stopRealtimeMarkErrors();
        }
    }

    private static Integer getMNemonic(String key) {
        String mnemonic = messages.getString(key);
        if (null != mnemonic) {
            return new Integer(mnemonic.charAt(0));
        }
        return null;
    }

    private static class JActionCheckBoxButton
    extends JCheckBoxMenuItem {
        private PropertyChangeListenerForToggleActions listener;

        public JActionCheckBoxButton(Action action) {
            super(action);
        }

        public void removeActionListener(ActionListener l) {
            if (l == this.getAction()) {
                this.listener.removeListener();
            }
            super.removeActionListener(l);
        }

        protected void configurePropertiesFromAction(Action a) {
            super.configurePropertiesFromAction(a);
            PropertyChangeListenerForToggleActions.configureFromAction(this, a);
        }

        protected PropertyChangeListener createActionPropertyChangeListener(Action a) {
            this.listener = new PropertyChangeListenerForToggleActions(this, super.createActionPropertyChangeListener(a));
            return this.listener;
        }
    }

    private static class JActionToggleButton
    extends JToggleButton {
        private PropertyChangeListenerForToggleActions listener;

        public void removeActionListener(ActionListener l) {
            if (l == this.getAction()) {
                this.listener.removeListener();
            }
            super.removeActionListener(l);
        }

        protected void configurePropertiesFromAction(Action a) {
            super.configurePropertiesFromAction(a);
            PropertyChangeListenerForToggleActions.configureFromAction(this, a);
        }

        protected PropertyChangeListener createActionPropertyChangeListener(Action a) {
            this.listener = new PropertyChangeListenerForToggleActions(this, super.createActionPropertyChangeListener(a));
            return this.listener;
        }
    }

    private class ContentDependActionUptater
    implements DocumentListener {
        public ContentDependActionUptater() {
            this.update(JMySpellApplet.this.textArea.getDocument().getLength());
        }

        private void updateUndo() {
            String name = JMySpellApplet.this.undoManager.getUndoPresentationName();
            JMySpellApplet.this.undoAction.setEnabled(JMySpellApplet.this.undoManager.canUndo());
            JMySpellApplet.this.undoAction.putValue("Name", name);
            JMySpellApplet.this.undoAction.putValue("ShortDescription", name);
            JMySpellApplet.this.undoAction.putValue("MnemonicKey", new Integer(name.charAt(0)));
        }

        private void updateRedo() {
            String name = JMySpellApplet.this.undoManager.getRedoPresentationName();
            JMySpellApplet.this.redoAction.setEnabled(JMySpellApplet.this.undoManager.canRedo());
            JMySpellApplet.this.redoAction.putValue("Name", name);
            JMySpellApplet.this.redoAction.putValue("ShortDescription", name);
            JMySpellApplet.this.redoAction.putValue("MnemonicKey", new Integer(name.charAt(0)));
        }

        private void update(int nChars) {
            this.updateUndo();
            this.updateRedo();
            JMySpellApplet.this.checkAction.setEnabled(nChars > 0);
            JMySpellApplet.this.newAction.setEnabled(nChars > 0);
        }

        public void insertUpdate(DocumentEvent e) {
            this.update(e.getDocument().getLength());
        }

        public void removeUpdate(DocumentEvent e) {
            this.update(e.getDocument().getLength());
        }

        public void changedUpdate(DocumentEvent e) {
        }
    }

    private class SelectionActionUpdater
    implements CaretListener {
        public SelectionActionUpdater() {
            this.updateActions(JMySpellApplet.this.textArea.getSelectionStart(), JMySpellApplet.this.textArea.getSelectionEnd());
        }

        private void updateActions(int starSelc, int endSelc) {
            boolean hasSelection = starSelc != endSelc;
            boolean isAllSelection = Math.abs(endSelc - starSelc) == JMySpellApplet.this.textArea.getDocument().getLength();
            JMySpellApplet.this.copyAction.setEnabled(hasSelection);
            JMySpellApplet.this.cutAction.setEnabled(hasSelection);
            JMySpellApplet.this.selectAllAction.setEnabled(!isAllSelection);
        }

        public void caretUpdate(CaretEvent e) {
            this.updateActions(e.getDot(), e.getMark());
        }
    }

    private static class PropertyChangeListenerForToggleActions
    implements PropertyChangeListener {
        public static final String SELECTED_STATE = "SELECTED_STATE";
        private PropertyChangeListener delegateListener;
        private AbstractButton button;

        public PropertyChangeListenerForToggleActions(AbstractButton b, PropertyChangeListener listener) {
            this.delegateListener = listener;
            this.button = b;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            this.delegateListener.propertyChange(evt);
            if (evt.getPropertyName() == SELECTED_STATE) {
                this.button.setSelected((Boolean)evt.getNewValue());
            }
        }

        public static void configureFromAction(AbstractButton b, Action action) {
            b.setSelected(PropertyChangeListenerForToggleActions.isSelected(action));
        }

        public static boolean isSelected(Action action) {
            Boolean selected = (Boolean)action.getValue(SELECTED_STATE);
            if (null != selected) {
                return selected;
            }
            return false;
        }

        public static void setSelected(Action action, boolean s) {
            if (s) {
                action.putValue(SELECTED_STATE, Boolean.TRUE);
            } else {
                action.putValue(SELECTED_STATE, Boolean.FALSE);
            }
        }

        public void removeListener() {
            this.delegateListener = null;
            this.button = null;
        }
    }
}

