/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.swing.event;

import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.dts.spell.ErrorInfo;
import org.dts.spell.event.SpellCheckEvent;
import org.dts.spell.finder.Word;
import org.dts.spell.swing.JSpellDialog;
import org.dts.spell.swing.event.UISpellCheckListener;
import org.dts.spell.swing.utils.ErrorMarker;
import org.dts.spell.swing.utils.ErrorMsgBox;

public class UIErrorMarkerListener
extends UISpellCheckListener {
    private ErrorMarker errorMarker = new ErrorMarker();
    private Cursor oldCursor;

    public UIErrorMarkerListener() {
        this(null);
    }

    public UIErrorMarkerListener(JSpellDialog spellDialog) {
        super(spellDialog);
    }

    public void setTextComponent(JTextComponent textComp) {
        this.errorMarker.setTextComponent(textComp);
    }

    public void quitTextComponent() {
        this.errorMarker.quitTextComponent();
    }

    public boolean isSelectError() {
        return this.errorMarker.isSelectError();
    }

    public void setSelectError(boolean selectError) {
        this.errorMarker.setSelectError(selectError);
    }

    public void beginChecking(SpellCheckEvent event) {
        if (this.getSpellDialog() == null) {
            Window window = SwingUtilities.getWindowAncestor(this.errorMarker.getTextComponent());
            JSpellDialog dlg = window instanceof Frame ? new JSpellDialog((Frame)window) : (window instanceof Dialog ? new JSpellDialog((Dialog)window) : null);
            this.setSpellDialog(dlg);
            this.oldCursor = window.getCursor();
            window.setCursor(Cursor.getPredefinedCursor(3));
        }
        super.beginChecking(event);
    }

    public void spellingError(SpellCheckEvent event) {
        this.markError(event, ErrorInfo.getSpellingErrorInfo(event));
        super.spellingError(event);
    }

    public void badCaseError(SpellCheckEvent event) {
        this.markError(event, ErrorInfo.getBadCaseErrorInfo(event));
        super.badCaseError(event);
    }

    public void repeatWordError(SpellCheckEvent event) {
        this.markError(event, ErrorInfo.getRepeatWordErrorInfo(event));
        super.repeatWordError(event);
    }

    private void markError(SpellCheckEvent event, ErrorInfo info) {
        try {
            Word word = event.getCurrentWord();
            this.errorMarker.unMarkAllErrors();
            this.errorMarker.markError(word.getStart(), word.getEnd(), info, true);
        }
        catch (Exception ex) {
            ErrorMsgBox.show(ex);
            System.out.println(ex);
        }
    }

    public void endChecking(SpellCheckEvent event) {
        Window window = SwingUtilities.getWindowAncestor(this.errorMarker.getTextComponent());
        window.setCursor(this.oldCursor);
        this.errorMarker.unMarkAllErrors();
        super.endChecking(event);
    }
}

