/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.swing.event;

import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.text.MessageFormat;
import javax.swing.JDialog;
import org.dts.spell.event.SpellCheckAdapter;
import org.dts.spell.event.SpellCheckEvent;
import org.dts.spell.finder.Word;
import org.dts.spell.swing.JSpellDialog;
import org.dts.spell.swing.utils.ErrorMsgBox;
import org.dts.spell.swing.utils.Messages;

public class UISpellCheckListener
extends SpellCheckAdapter {
    private JSpellDialog spellDialog;

    public JSpellDialog getSpellDialog() {
        return this.spellDialog;
    }

    public void relocateDialog(Rectangle wordRect, JDialog dialog) {
        Rectangle bounds = dialog.getBounds();
        int orgX = bounds.x;
        int orgY = bounds.y;
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle screenBounds = env.getMaximumWindowBounds();
        if (bounds.intersects(wordRect)) {
            double ratio = 0.95;
            if (screenBounds.getWidth() - wordRect.getWidth() < bounds.getWidth()) {
                orgY = wordRect.getMinY() > screenBounds.getHeight() - wordRect.getMaxY() ? (int)(screenBounds.getMinY() + (wordRect.getMinY() - bounds.getHeight()) * (1.0 - ratio)) : (int)(wordRect.getMaxY() + (screenBounds.getMaxY() - wordRect.getMaxY() - bounds.getHeight()) * ratio);
            } else {
                orgX = wordRect.getMinX() > screenBounds.getWidth() - wordRect.getMaxX() ? (int)(screenBounds.getMinX() + (wordRect.getMinX() - bounds.getWidth()) * (1.0 - ratio)) : (int)(wordRect.getMaxX() + (screenBounds.getMaxX() - wordRect.getMaxX() - bounds.getWidth()) * ratio);
            }
            if (orgX < 0) {
                orgX = 0;
            } else if ((double)(orgX + bounds.width) > screenBounds.getMaxX()) {
                orgX = (int)(screenBounds.getMaxX() - bounds.getWidth());
            }
            if (orgY < 0) {
                orgY = 0;
            } else if ((double)(orgY + bounds.height) > screenBounds.getMaxY()) {
                orgY = (int)(screenBounds.getMaxY() - bounds.getHeight());
            }
            dialog.setLocation(orgX, orgY);
        }
    }

    public void initDialogPosition(JDialog dialog) {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle screenBounds = env.getMaximumWindowBounds();
        dialog.pack();
        Rectangle dlgRect = dialog.getBounds();
        int orgX = (int)(screenBounds.getMaxX() - dlgRect.getWidth());
        int orgY = (int)(screenBounds.getMaxY() - dlgRect.getHeight());
        dialog.setLocation(orgX, orgY);
    }

    public void relocateDialog(Rectangle wordRect) {
        this.relocateDialog(wordRect, this.getSpellDialog());
    }

    public void setSpellDialog(JSpellDialog spellDialog) {
        this.spellDialog = spellDialog;
        if (null != spellDialog) {
            this.initDialogPosition(spellDialog);
        }
    }

    public UISpellCheckListener() {
        this(null);
    }

    public UISpellCheckListener(JSpellDialog spellDialog) {
        this.setSpellDialog(spellDialog);
    }

    public void beginChecking(SpellCheckEvent event) {
        if (this.getSpellDialog() == null) {
            this.setSpellDialog(new JSpellDialog());
        }
        this.initDialogPosition(this.getSpellDialog());
    }

    public void spellingError(SpellCheckEvent event) {
        JSpellDialog dlg = this.getSpellDialog();
        if (!dlg.showDialog(event.getSpellChecker(), event.getWordFinder())) {
            event.cancel();
        }
    }

    public void badCaseError(SpellCheckEvent event) {
        Word word = event.getCurrentWord();
        String newWord = word.getStartSentenceWordCase();
        String msg = MessageFormat.format(Messages.getString("ERROR_CAPITALIZATION_STRING"), word, newWord);
        int result = ErrorMsgBox.yesNoCancelMsg(Messages.getString("ERROR_CAPITALIZATION_TITLE_STRING"), msg);
        switch (result) {
            case 0: {
                event.getWordFinder().replace(newWord);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                event.cancel();
            }
        }
    }

    public void repeatWordError(SpellCheckEvent event) {
        Word word = event.getCurrentWord();
        String msg = MessageFormat.format(Messages.getString("ERROR_REPEAT_WORD_STRING"), word);
        int result = ErrorMsgBox.yesNoCancelMsg(Messages.getString("ERROR_REPEAT_WORD_TITLE_STRING"), msg);
        switch (result) {
            case 0: {
                event.getWordFinder().replace("");
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                event.cancel();
            }
        }
    }
}

