/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.swing.finder;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.dts.spell.finder.CharSequenceWordFinder;
import org.dts.spell.finder.Word;
import org.dts.spell.swing.finder.DocumentCharSequence;
import org.dts.spell.tokenizer.WordTokenizer;

public class DocumentWordFinder
extends CharSequenceWordFinder {
    public DocumentWordFinder(WordTokenizer tokenizer) {
        super(new DocumentCharSequence(), tokenizer);
    }

    public DocumentWordFinder() {
        super(new DocumentCharSequence());
    }

    public DocumentWordFinder(Document text, WordTokenizer tokenizer) {
        super(new DocumentCharSequence(text), tokenizer);
    }

    protected DocumentWordFinder(CharSequence text, WordTokenizer tokenizer) {
        super(text, tokenizer);
    }

    public DocumentWordFinder(Document text) {
        super(new DocumentCharSequence(text));
    }

    protected void replace(String newWord, Word currentWord) {
        int start = currentWord.getStart();
        Document document = this.getDocument();
        try {
            document.remove(start, currentWord.length());
            this.updateCharSequence(start, start + currentWord.length(), 1);
            if (newWord.length() > 0) {
                document.insertString(start, newWord, null);
                this.updateCharSequence(start, start + newWord.length(), 0);
            }
        }
        catch (BadLocationException e) {
            throw new IndexOutOfBoundsException(e.getLocalizedMessage());
        }
    }

    public Word getWordAt(int index) {
        return this.getTokenizer().currentWord(index);
    }

    public Word getPreviousWord(int index) {
        return this.getTokenizer().previousWord(index);
    }

    public Word getNextWord(int index) {
        return this.getTokenizer().nextWord(index);
    }

    public void setDocument(Document document) {
        this.getDocumentCharSequence().setDocument(document);
        this.updateCharSequence(0, document.getLength(), 2);
        this.init();
    }

    public void quitDocument() {
        this.getDocumentCharSequence().setDocument(null);
        this.updateCharSequence(0, 0, 2);
        this.init();
    }

    public DocumentCharSequence getDocumentCharSequence() {
        return (DocumentCharSequence)this.getCharSequence();
    }

    public Document getDocument() {
        return this.getDocumentCharSequence().getDocument();
    }

    protected void updateCharSequence(int start, int end, int cause) {
        super.updateCharSequence(start, end, cause);
        this.getDocumentCharSequence().updateFromDocument(this.getDocument());
    }
}

