/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.jsonassert;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.skyscreamer.jsonassert.JSONCompare;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.skyscreamer.jsonassert.JSONCompareResult;
import org.skyscreamer.jsonassert.JSONParser;
import org.skyscreamer.jsonassert.comparator.JSONComparator;

public class JSONAssert {
    private JSONAssert() {
    }

    public static void assertEquals(String expectedStr, JSONObject actual, boolean strict) throws JSONException {
        JSONAssert.assertEquals(expectedStr, actual, strict ? JSONCompareMode.STRICT : JSONCompareMode.LENIENT);
    }

    public static void assertEquals(String message, String expectedStr, JSONObject actual, boolean strict) throws JSONException {
        JSONAssert.assertEquals(message, expectedStr, actual, strict ? JSONCompareMode.STRICT : JSONCompareMode.LENIENT);
    }

    public static void assertNotEquals(String expectedStr, JSONObject actual, boolean strict) throws JSONException {
        JSONAssert.assertNotEquals(expectedStr, actual, strict ? JSONCompareMode.STRICT : JSONCompareMode.LENIENT);
    }

    public static void assertNotEquals(String message, String expectedStr, JSONObject actual, boolean strict) throws JSONException {
        JSONAssert.assertNotEquals(message, expectedStr, actual, strict ? JSONCompareMode.STRICT : JSONCompareMode.LENIENT);
    }

    public static void assertEquals(String expectedStr, JSONObject actual, JSONCompareMode compareMode) throws JSONException {
        JSONAssert.assertEquals("", expectedStr, actual, compareMode);
    }

    public static void assertEquals(String message, String expectedStr, JSONObject actual, JSONCompareMode compareMode) throws JSONException {
        Object expected = JSONParser.parseJSON(expectedStr);
        if (!(expected instanceof JSONObject)) {
            throw new AssertionError((Object)"Expecting a JSON array, but passing in a JSON object");
        }
        JSONAssert.assertEquals(message, (JSONObject)expected, actual, compareMode);
    }

    public static void assertNotEquals(String expectedStr, JSONObject actual, JSONCompareMode compareMode) throws JSONException {
        JSONAssert.assertNotEquals("", expectedStr, actual, compareMode);
    }

    public static void assertNotEquals(String message, String expectedStr, JSONObject actual, JSONCompareMode compareMode) throws JSONException {
        Object expected = JSONParser.parseJSON(expectedStr);
        if (!(expected instanceof JSONObject)) {
            throw new AssertionError((Object)"Expecting a JSON array, but passing in a JSON object");
        }
        JSONAssert.assertNotEquals(message, (JSONObject)expected, actual, compareMode);
    }

    public static void assertEquals(String expectedStr, JSONArray actual, boolean strict) throws JSONException {
        JSONAssert.assertEquals(expectedStr, actual, strict ? JSONCompareMode.STRICT : JSONCompareMode.LENIENT);
    }

    public static void assertEquals(String message, String expectedStr, JSONArray actual, boolean strict) throws JSONException {
        JSONAssert.assertEquals(message, expectedStr, actual, strict ? JSONCompareMode.STRICT : JSONCompareMode.LENIENT);
    }

    public static void assertNotEquals(String expectedStr, JSONArray actual, boolean strict) throws JSONException {
        JSONAssert.assertNotEquals(expectedStr, actual, strict ? JSONCompareMode.STRICT : JSONCompareMode.LENIENT);
    }

    public static void assertNotEquals(String message, String expectedStr, JSONArray actual, boolean strict) throws JSONException {
        JSONAssert.assertNotEquals(message, expectedStr, actual, strict ? JSONCompareMode.STRICT : JSONCompareMode.LENIENT);
    }

    public static void assertEquals(String expectedStr, JSONArray actual, JSONCompareMode compareMode) throws JSONException {
        JSONAssert.assertEquals("", expectedStr, actual, compareMode);
    }

    public static void assertEquals(String message, String expectedStr, JSONArray actual, JSONCompareMode compareMode) throws JSONException {
        Object expected = JSONParser.parseJSON(expectedStr);
        if (!(expected instanceof JSONArray)) {
            throw new AssertionError((Object)"Expecting a JSON object, but passing in a JSON array");
        }
        JSONAssert.assertEquals(message, (JSONArray)expected, actual, compareMode);
    }

    public static void assertNotEquals(String expectedStr, JSONArray actual, JSONCompareMode compareMode) throws JSONException {
        Object expected = JSONParser.parseJSON(expectedStr);
        if (!(expected instanceof JSONArray)) {
            throw new AssertionError((Object)"Expecting a JSON object, but passing in a JSON array");
        }
        JSONAssert.assertNotEquals((JSONArray)expected, actual, compareMode);
    }

    public static void assertNotEquals(String message, String expectedStr, JSONArray actual, JSONCompareMode compareMode) throws JSONException {
        Object expected = JSONParser.parseJSON(expectedStr);
        if (!(expected instanceof JSONArray)) {
            throw new AssertionError((Object)"Expecting a JSON object, but passing in a JSON array");
        }
        JSONAssert.assertNotEquals(message, (JSONArray)expected, actual, compareMode);
    }

    public static void assertEquals(String expectedStr, String actualStr, boolean strict) throws JSONException {
        JSONAssert.assertEquals(expectedStr, actualStr, strict ? JSONCompareMode.STRICT : JSONCompareMode.LENIENT);
    }

    public static void assertEquals(String message, String expectedStr, String actualStr, boolean strict) throws JSONException {
        JSONAssert.assertEquals(message, expectedStr, actualStr, strict ? JSONCompareMode.STRICT : JSONCompareMode.LENIENT);
    }

    public static void assertNotEquals(String expectedStr, String actualStr, boolean strict) throws JSONException {
        JSONAssert.assertNotEquals(expectedStr, actualStr, strict ? JSONCompareMode.STRICT : JSONCompareMode.LENIENT);
    }

    public static void assertNotEquals(String message, String expectedStr, String actualStr, boolean strict) throws JSONException {
        JSONAssert.assertNotEquals(message, expectedStr, actualStr, strict ? JSONCompareMode.STRICT : JSONCompareMode.LENIENT);
    }

    public static void assertEquals(String expectedStr, String actualStr, JSONCompareMode compareMode) throws JSONException {
        JSONAssert.assertEquals("", expectedStr, actualStr, compareMode);
    }

    public static void assertEquals(String message, String expectedStr, String actualStr, JSONCompareMode compareMode) throws JSONException {
        if (expectedStr == actualStr) {
            return;
        }
        if (expectedStr == null) {
            throw new AssertionError((Object)"Expected string is null.");
        }
        if (actualStr == null) {
            throw new AssertionError((Object)"Actual string is null.");
        }
        JSONCompareResult result = JSONCompare.compareJSON(expectedStr, actualStr, compareMode);
        if (result.failed()) {
            throw new AssertionError((Object)JSONAssert.getCombinedMessage(message, result.getMessage()));
        }
    }

    public static void assertNotEquals(String expectedStr, String actualStr, JSONCompareMode compareMode) throws JSONException {
        JSONAssert.assertNotEquals("", expectedStr, actualStr, compareMode);
    }

    public static void assertNotEquals(String message, String expectedStr, String actualStr, JSONCompareMode compareMode) throws JSONException {
        JSONCompareResult result = JSONCompare.compareJSON(expectedStr, actualStr, compareMode);
        if (result.passed()) {
            throw new AssertionError((Object)JSONAssert.getCombinedMessage(message, result.getMessage()));
        }
    }

    public static void assertEquals(String expectedStr, String actualStr, JSONComparator comparator) throws JSONException {
        JSONAssert.assertEquals("", expectedStr, actualStr, comparator);
    }

    public static void assertEquals(String message, String expectedStr, String actualStr, JSONComparator comparator) throws JSONException {
        JSONCompareResult result = JSONCompare.compareJSON(expectedStr, actualStr, comparator);
        if (result.failed()) {
            throw new AssertionError((Object)JSONAssert.getCombinedMessage(message, result.getMessage()));
        }
    }

    public static void assertNotEquals(String expectedStr, String actualStr, JSONComparator comparator) throws JSONException {
        JSONAssert.assertNotEquals("", expectedStr, actualStr, comparator);
    }

    public static void assertNotEquals(String message, String expectedStr, String actualStr, JSONComparator comparator) throws JSONException {
        JSONCompareResult result = JSONCompare.compareJSON(expectedStr, actualStr, comparator);
        if (result.passed()) {
            throw new AssertionError((Object)JSONAssert.getCombinedMessage(message, result.getMessage()));
        }
    }

    public static void assertEquals(JSONObject expected, JSONObject actual, JSONComparator comparator) throws JSONException {
        JSONAssert.assertEquals("", expected, actual, comparator);
    }

    public static void assertEquals(String message, JSONObject expected, JSONObject actual, JSONComparator comparator) throws JSONException {
        JSONCompareResult result = JSONCompare.compareJSON(expected, actual, comparator);
        if (result.failed()) {
            throw new AssertionError((Object)JSONAssert.getCombinedMessage(message, result.getMessage()));
        }
    }

    public static void assertNotEquals(JSONObject expected, JSONObject actual, JSONComparator comparator) throws JSONException {
        JSONAssert.assertNotEquals("", expected, actual, comparator);
    }

    public static void assertNotEquals(String message, JSONObject expected, JSONObject actual, JSONComparator comparator) throws JSONException {
        JSONCompareResult result = JSONCompare.compareJSON(expected, actual, comparator);
        if (result.passed()) {
            throw new AssertionError((Object)JSONAssert.getCombinedMessage(message, result.getMessage()));
        }
    }

    public static void assertEquals(JSONObject expected, JSONObject actual, boolean strict) throws JSONException {
        JSONAssert.assertEquals(expected, actual, strict ? JSONCompareMode.STRICT : JSONCompareMode.LENIENT);
    }

    public static void assertEquals(String message, JSONObject expected, JSONObject actual, boolean strict) throws JSONException {
        JSONAssert.assertEquals(message, expected, actual, strict ? JSONCompareMode.STRICT : JSONCompareMode.LENIENT);
    }

    public static void assertNotEquals(JSONObject expected, JSONObject actual, boolean strict) throws JSONException {
        JSONAssert.assertNotEquals(expected, actual, strict ? JSONCompareMode.STRICT : JSONCompareMode.LENIENT);
    }

    public static void assertNotEquals(String message, JSONObject expected, JSONObject actual, boolean strict) throws JSONException {
        JSONAssert.assertNotEquals(message, expected, actual, strict ? JSONCompareMode.STRICT : JSONCompareMode.LENIENT);
    }

    public static void assertEquals(JSONObject expected, JSONObject actual, JSONCompareMode compareMode) throws JSONException {
        JSONAssert.assertEquals("", expected, actual, compareMode);
    }

    public static void assertEquals(String message, JSONObject expected, JSONObject actual, JSONCompareMode compareMode) throws JSONException {
        JSONCompareResult result = JSONCompare.compareJSON(expected, actual, compareMode);
        if (result.failed()) {
            throw new AssertionError((Object)JSONAssert.getCombinedMessage(message, result.getMessage()));
        }
    }

    public static void assertNotEquals(JSONObject expected, JSONObject actual, JSONCompareMode compareMode) throws JSONException {
        JSONAssert.assertNotEquals("", expected, actual, compareMode);
    }

    public static void assertNotEquals(String message, JSONObject expected, JSONObject actual, JSONCompareMode compareMode) throws JSONException {
        JSONCompareResult result = JSONCompare.compareJSON(expected, actual, compareMode);
        if (result.passed()) {
            throw new AssertionError((Object)JSONAssert.getCombinedMessage(message, result.getMessage()));
        }
    }

    public static void assertEquals(JSONArray expected, JSONArray actual, boolean strict) throws JSONException {
        JSONAssert.assertEquals("", expected, actual, strict ? JSONCompareMode.STRICT : JSONCompareMode.LENIENT);
    }

    public static void assertEquals(String message, JSONArray expected, JSONArray actual, boolean strict) throws JSONException {
        JSONAssert.assertEquals(message, expected, actual, strict ? JSONCompareMode.STRICT : JSONCompareMode.LENIENT);
    }

    public static void assertNotEquals(JSONArray expected, JSONArray actual, boolean strict) throws JSONException {
        JSONAssert.assertNotEquals(expected, actual, strict ? JSONCompareMode.STRICT : JSONCompareMode.LENIENT);
    }

    public static void assertNotEquals(String message, JSONArray expected, JSONArray actual, boolean strict) throws JSONException {
        JSONAssert.assertNotEquals(message, expected, actual, strict ? JSONCompareMode.STRICT : JSONCompareMode.LENIENT);
    }

    public static void assertEquals(JSONArray expected, JSONArray actual, JSONCompareMode compareMode) throws JSONException {
        JSONAssert.assertEquals("", expected, actual, compareMode);
    }

    public static void assertEquals(String message, JSONArray expected, JSONArray actual, JSONCompareMode compareMode) throws JSONException {
        JSONCompareResult result = JSONCompare.compareJSON(expected, actual, compareMode);
        if (result.failed()) {
            throw new AssertionError((Object)JSONAssert.getCombinedMessage(message, result.getMessage()));
        }
    }

    public static void assertNotEquals(JSONArray expected, JSONArray actual, JSONCompareMode compareMode) throws JSONException {
        JSONAssert.assertNotEquals("", expected, actual, compareMode);
    }

    public static void assertNotEquals(String message, JSONArray expected, JSONArray actual, JSONCompareMode compareMode) throws JSONException {
        JSONCompareResult result = JSONCompare.compareJSON(expected, actual, compareMode);
        if (result.passed()) {
            throw new AssertionError((Object)JSONAssert.getCombinedMessage(message, result.getMessage()));
        }
    }

    private static String getCombinedMessage(String message1, String message2) {
        String combinedMessage = "";
        combinedMessage = message1 == null || "".equals(message1) ? message2 : message1 + " " + message2;
        return combinedMessage;
    }
}

