/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common.distance;

import org.apache.mahout.common.distance.WeightedDistanceMeasure;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.Functions;

public class TanimotoDistanceMeasure
extends WeightedDistanceMeasure {
    @Override
    public double distance(Vector a, Vector b) {
        double denominator;
        double ab;
        if (this.getWeights() != null) {
            ab = a.times(b).aggregate(this.getWeights(), Functions.PLUS, Functions.MULT);
            denominator = a.aggregate(this.getWeights(), Functions.PLUS, Functions.MULT_SQUARE_LEFT) + b.aggregate(this.getWeights(), Functions.PLUS, Functions.MULT_SQUARE_LEFT) - ab;
        } else {
            ab = b.dot(a);
            denominator = a.getLengthSquared() + b.getLengthSquared() - ab;
        }
        if (denominator < ab) {
            denominator = ab;
        }
        if (denominator > 0.0) {
            return 1.0 - ab / denominator;
        }
        return 0.0;
    }

    @Override
    public double distance(double centroidLengthSquare, Vector centroid, Vector v) {
        return this.distance(centroid, v);
    }
}

