/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.iterator.sequencefile.PathFilters;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirIterator;
import org.apache.mahout.math.CardinalityException;
import org.apache.mahout.math.MatrixSlice;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorIterable;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.hadoop.MatrixColumnMeansJob;
import org.apache.mahout.math.hadoop.MatrixMultiplicationJob;
import org.apache.mahout.math.hadoop.TimesSquaredJob;
import org.apache.mahout.math.hadoop.TransposeJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedRowMatrix
implements VectorIterable,
Configurable {
    public static final String KEEP_TEMP_FILES = "DistributedMatrix.keep.temp.files";
    private static final Logger log = LoggerFactory.getLogger(DistributedRowMatrix.class);
    private final Path inputPath;
    private final Path outputTmpPath;
    private Configuration conf;
    private Path rowPath;
    private Path outputTmpBasePath;
    private final int numRows;
    private final int numCols;
    private boolean keepTempFiles;

    public DistributedRowMatrix(Path inputPath, Path outputTmpPath, int numRows, int numCols) {
        this(inputPath, outputTmpPath, numRows, numCols, false);
    }

    public DistributedRowMatrix(Path inputPath, Path outputTmpPath, int numRows, int numCols, boolean keepTempFiles) {
        this.inputPath = inputPath;
        this.outputTmpPath = outputTmpPath;
        this.numRows = numRows;
        this.numCols = numCols;
        this.keepTempFiles = keepTempFiles;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        try {
            FileSystem fs = FileSystem.get((URI)this.inputPath.toUri(), (Configuration)conf);
            this.rowPath = fs.makeQualified(this.inputPath);
            this.outputTmpBasePath = fs.makeQualified(this.outputTmpPath);
            this.keepTempFiles = conf.getBoolean(KEEP_TEMP_FILES, false);
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
    }

    public Path getRowPath() {
        return this.rowPath;
    }

    public Path getOutputTempPath() {
        return this.outputTmpBasePath;
    }

    public void setOutputTempPathString(String outPathString) {
        try {
            this.outputTmpBasePath = FileSystem.get((Configuration)this.conf).makeQualified(new Path(outPathString));
        }
        catch (IOException ioe) {
            log.warn("Unable to set outputBasePath to {}, leaving as {}", (Object)outPathString, (Object)this.outputTmpBasePath);
        }
    }

    public Iterator<MatrixSlice> iterateAll() {
        try {
            Path pathPattern = this.rowPath;
            if (FileSystem.get((Configuration)this.conf).getFileStatus(this.rowPath).isDir()) {
                pathPattern = new Path(this.rowPath, "*");
            }
            return Iterators.transform(new SequenceFileDirIterator(pathPattern, PathType.GLOB, PathFilters.logsCRCFilter(), null, true, this.conf), (Function)new Function<Pair<IntWritable, VectorWritable>, MatrixSlice>(){

                public MatrixSlice apply(Pair<IntWritable, VectorWritable> from) {
                    return new MatrixSlice(from.getSecond().get(), from.getFirst().get());
                }
            });
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
    }

    public int numSlices() {
        return this.numRows();
    }

    public int numRows() {
        return this.numRows;
    }

    public int numCols() {
        return this.numCols;
    }

    public DistributedRowMatrix times(DistributedRowMatrix other) throws IOException {
        return this.times(other, new Path(this.outputTmpBasePath.getParent(), "productWith-" + (System.nanoTime() & 0xFFL)));
    }

    public DistributedRowMatrix times(DistributedRowMatrix other, Path outPath) throws IOException {
        if (this.numRows != other.numRows()) {
            throw new CardinalityException(this.numRows, other.numRows());
        }
        Configuration initialConf = this.getConf() == null ? new Configuration() : this.getConf();
        Configuration conf = MatrixMultiplicationJob.createMatrixMultiplyJobConf(initialConf, this.rowPath, other.rowPath, outPath, other.numCols);
        JobClient.runJob((JobConf)new JobConf(conf));
        DistributedRowMatrix out = new DistributedRowMatrix(outPath, this.outputTmpPath, this.numCols, other.numCols());
        out.setConf(conf);
        return out;
    }

    public Vector columnMeans() throws IOException {
        return this.columnMeans("SequentialAccessSparseVector");
    }

    public Vector columnMeans(String vectorClass) throws IOException {
        Path outputVectorTmpPath = new Path(this.outputTmpBasePath, new Path(Long.toString(System.nanoTime())));
        Configuration initialConf = this.getConf() == null ? new Configuration() : this.getConf();
        String vectorClassFull = "org.apache.mahout.math." + vectorClass;
        Vector mean = MatrixColumnMeansJob.run(initialConf, this.rowPath, outputVectorTmpPath, vectorClassFull);
        if (!this.keepTempFiles) {
            FileSystem fs = outputVectorTmpPath.getFileSystem(this.conf);
            fs.delete(outputVectorTmpPath, true);
        }
        return mean;
    }

    public DistributedRowMatrix transpose() throws IOException {
        Path outputPath = new Path(this.rowPath.getParent(), "transpose-" + (System.nanoTime() & 0xFFL));
        Configuration initialConf = this.getConf() == null ? new Configuration() : this.getConf();
        Configuration conf = TransposeJob.buildTransposeJobConf(initialConf, this.rowPath, outputPath, this.numRows);
        JobClient.runJob((JobConf)new JobConf(conf));
        DistributedRowMatrix m = new DistributedRowMatrix(outputPath, this.outputTmpPath, this.numCols, this.numRows);
        m.setConf(this.conf);
        return m;
    }

    public Vector times(Vector v) {
        try {
            Configuration initialConf = this.getConf() == null ? new Configuration() : this.getConf();
            Path outputVectorTmpPath = new Path(this.outputTmpBasePath, new Path(Long.toString(System.nanoTime())));
            Configuration conf = TimesSquaredJob.createTimesJobConf(initialConf, v, this.numRows, this.rowPath, outputVectorTmpPath);
            JobClient.runJob((JobConf)new JobConf(conf));
            Vector result = TimesSquaredJob.retrieveTimesSquaredOutputVector(conf);
            if (!this.keepTempFiles) {
                FileSystem fs = outputVectorTmpPath.getFileSystem(conf);
                fs.delete(outputVectorTmpPath, true);
            }
            return result;
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
    }

    public Vector timesSquared(Vector v) {
        try {
            Configuration initialConf = this.getConf() == null ? new Configuration() : this.getConf();
            Path outputVectorTmpPath = new Path(this.outputTmpBasePath, new Path(Long.toString(System.nanoTime())));
            Configuration conf = TimesSquaredJob.createTimesSquaredJobConf(initialConf, v, this.rowPath, outputVectorTmpPath);
            JobClient.runJob((JobConf)new JobConf(conf));
            Vector result = TimesSquaredJob.retrieveTimesSquaredOutputVector(conf);
            if (!this.keepTempFiles) {
                FileSystem fs = outputVectorTmpPath.getFileSystem(conf);
                fs.delete(outputVectorTmpPath, true);
            }
            return result;
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
    }

    public Iterator<MatrixSlice> iterator() {
        return this.iterateAll();
    }

    public static class MatrixEntryWritable
    implements WritableComparable<MatrixEntryWritable> {
        private int row;
        private int col;
        private double val;

        public int getRow() {
            return this.row;
        }

        public void setRow(int row) {
            this.row = row;
        }

        public int getCol() {
            return this.col;
        }

        public void setCol(int col) {
            this.col = col;
        }

        public double getVal() {
            return this.val;
        }

        public void setVal(double val) {
            this.val = val;
        }

        public int compareTo(MatrixEntryWritable o) {
            if (this.row > o.row) {
                return 1;
            }
            if (this.row < o.row) {
                return -1;
            }
            if (this.col > o.col) {
                return 1;
            }
            if (this.col < o.col) {
                return -1;
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof MatrixEntryWritable)) {
                return false;
            }
            MatrixEntryWritable other = (MatrixEntryWritable)o;
            return this.row == other.row && this.col == other.col;
        }

        public int hashCode() {
            return this.row + 31 * this.col;
        }

        public void write(DataOutput out) throws IOException {
            out.writeInt(this.row);
            out.writeInt(this.col);
            out.writeDouble(this.val);
        }

        public void readFields(DataInput in) throws IOException {
            this.row = in.readInt();
            this.col = in.readInt();
            this.val = in.readDouble();
        }

        public String toString() {
            return "(" + this.row + ',' + this.col + "):" + this.val;
        }
    }
}

