/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.similarity;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.common.ClassUtils;
import org.apache.mahout.common.StringTuple;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.math.NamedVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.hadoop.similarity.SeedVectorUtil;

public final class VectorDistanceMapper
extends Mapper<WritableComparable<?>, VectorWritable, StringTuple, DoubleWritable> {
    private DistanceMeasure measure;
    private List<NamedVector> seedVectors;
    private boolean usesThreshold = false;
    private double maxDistance;

    protected void map(WritableComparable<?> key, VectorWritable value, Mapper.Context context) throws IOException, InterruptedException {
        Vector valVec = value.get();
        String keyName = valVec instanceof NamedVector ? ((NamedVector)valVec).getName() : key.toString();
        for (NamedVector seedVector : this.seedVectors) {
            double distance = this.measure.distance((Vector)seedVector, valVec);
            if (this.usesThreshold && !(distance <= this.maxDistance)) continue;
            StringTuple outKey = new StringTuple();
            outKey.add(seedVector.getName());
            outKey.add(keyName);
            context.write((Object)outKey, (Object)new DoubleWritable(distance));
        }
    }

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Configuration conf = context.getConfiguration();
        String maxDistanceParam = conf.get("maxDistance");
        if (maxDistanceParam != null) {
            this.usesThreshold = true;
            this.maxDistance = Double.parseDouble(maxDistanceParam);
        }
        this.measure = ClassUtils.instantiateAs(conf.get("vectorDistSim.measure"), DistanceMeasure.class);
        this.measure.configure(conf);
        this.seedVectors = SeedVectorUtil.loadSeedVectors(conf);
    }
}

