/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.vectorizer.tfidf;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileIterable;
import org.apache.mahout.math.NamedVector;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.SequentialAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.map.OpenIntLongHashMap;
import org.apache.mahout.vectorizer.TFIDF;

public class TFIDFPartialVectorReducer
extends Reducer<WritableComparable<?>, VectorWritable, WritableComparable<?>, VectorWritable> {
    private final OpenIntLongHashMap dictionary = new OpenIntLongHashMap();
    private final TFIDF tfidf = new TFIDF();
    private int minDf = 1;
    private long maxDf = -1L;
    private long vectorCount = 1L;
    private long featureCount;
    private boolean sequentialAccess;
    private boolean namedVector;

    protected void reduce(WritableComparable<?> key, Iterable<VectorWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        Iterator<VectorWritable> it = values.iterator();
        if (!it.hasNext()) {
            return;
        }
        Vector value = it.next().get();
        RandomAccessSparseVector vector = new RandomAccessSparseVector((int)this.featureCount, value.getNumNondefaultElements());
        for (Vector.Element e : value.nonZeroes()) {
            if (!this.dictionary.containsKey(e.index())) continue;
            long df = this.dictionary.get(e.index());
            if (this.maxDf > -1L && 100.0 * (double)df / (double)this.vectorCount > (double)this.maxDf) continue;
            if (df < (long)this.minDf) {
                df = this.minDf;
            }
            vector.setQuick(e.index(), this.tfidf.calculate((int)e.get(), (int)df, (int)this.featureCount, (int)this.vectorCount));
        }
        if (this.sequentialAccess) {
            vector = new SequentialAccessSparseVector((Vector)vector);
        }
        if (this.namedVector) {
            vector = new NamedVector((Vector)vector, key.toString());
        }
        VectorWritable vectorWritable = new VectorWritable((Vector)vector);
        context.write(key, (Object)vectorWritable);
    }

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Configuration conf = context.getConfiguration();
        this.vectorCount = conf.getLong("vector.count", 1L);
        this.featureCount = conf.getLong("feature.count", 1L);
        this.minDf = conf.getInt("min.df", 1);
        this.maxDf = conf.getLong("max.df", -1L);
        this.sequentialAccess = conf.getBoolean("vector.sequentialAccess", false);
        this.namedVector = conf.getBoolean("vector.named", false);
        Path dictionaryFile = HadoopUtil.getSingleCachedFile(conf);
        for (Pair record : new SequenceFileIterable(dictionaryFile, true, conf)) {
            this.dictionary.put(((IntWritable)record.getFirst()).get(), ((LongWritable)record.getSecond()).get());
        }
    }
}

