/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.mahout.math.Sorting;
import org.apache.mahout.math.Swapper;
import org.apache.mahout.math.function.IntComparator;
import org.apache.mahout.math.function.ObjectCharProcedure;
import org.apache.mahout.math.function.ObjectProcedure;
import org.apache.mahout.math.list.CharArrayList;
import org.apache.mahout.math.set.AbstractSet;
import org.apache.mahout.math.set.HashUtils;

public abstract class AbstractObjectCharMap<T>
extends AbstractSet {
    public boolean containsKey(final T key) {
        return !this.forEachKey(new ObjectProcedure<T>(){

            @Override
            public boolean apply(T iterKey) {
                return key != iterKey;
            }
        });
    }

    public boolean containsValue(final char value) {
        return !this.forEachPair(new ObjectCharProcedure<T>(){

            @Override
            public boolean apply(T iterKey, char iterValue) {
                return value != iterValue;
            }
        });
    }

    public AbstractObjectCharMap<T> copy() {
        return (AbstractObjectCharMap)this.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractObjectCharMap)) {
            return false;
        }
        final AbstractObjectCharMap other = (AbstractObjectCharMap)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new ObjectCharProcedure<T>(){

            @Override
            public boolean apply(T key, char value) {
                return other.containsKey(key) && other.get(key) == value;
            }
        }) && other.forEachPair(new ObjectCharProcedure<T>(){

            @Override
            public boolean apply(T key, char value) {
                return AbstractObjectCharMap.this.containsKey(key) && AbstractObjectCharMap.this.get(key) == value;
            }
        });
    }

    public int hashCode() {
        final int[] buf = new int[this.size()];
        this.forEachPair(new ObjectCharProcedure(){
            int i = 0;

            public boolean apply(Object key, char value) {
                buf[this.i++] = key.hashCode() ^ HashUtils.hash(value);
                return true;
            }
        });
        Arrays.sort(buf);
        return IntBuffer.wrap(buf).hashCode();
    }

    public abstract boolean forEachKey(ObjectProcedure<T> var1);

    public boolean forEachPair(final ObjectCharProcedure<T> procedure) {
        return this.forEachKey(new ObjectProcedure<T>(){

            @Override
            public boolean apply(T key) {
                return procedure.apply(key, AbstractObjectCharMap.this.get(key));
            }
        });
    }

    public abstract char get(T var1);

    public List<T> keys() {
        ArrayList list = new ArrayList(this.size());
        this.keys(list);
        return list;
    }

    public void keys(final List<T> list) {
        list.clear();
        this.forEachKey(new ObjectProcedure<T>(){

            @Override
            public boolean apply(T key) {
                list.add(key);
                return true;
            }
        });
    }

    public void keysSortedByValue(List<T> keyList) {
        this.pairsSortedByValue(keyList, new CharArrayList(this.size()));
    }

    public void pairsMatching(final ObjectCharProcedure<T> condition, final List<T> keyList, final CharArrayList valueList) {
        keyList.clear();
        valueList.clear();
        this.forEachPair(new ObjectCharProcedure<T>(){

            @Override
            public boolean apply(T key, char value) {
                if (condition.apply(key, value)) {
                    keyList.add(key);
                    valueList.add(value);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(List<T> keyList, CharArrayList valueList) {
        this.keys(keyList);
        if (keyList.isEmpty()) {
            return;
        }
        T k = keyList.get(0);
        if (!(k instanceof Comparable)) {
            throw new UnsupportedOperationException("The key type for this map does not implement comparable");
        }
        Collections.sort(keyList);
        valueList.setSize(keyList.size());
        int i = keyList.size();
        while (--i >= 0) {
            valueList.setQuick(i, this.get(keyList.get(i)));
        }
    }

    public void pairsSortedByValue(final List<T> keyList, CharArrayList valueList) {
        this.keys(keyList);
        this.values(valueList);
        final char[] v = valueList.elements();
        Swapper swapper = new Swapper(){

            @Override
            public void swap(int a, int b) {
                char t1 = v[a];
                v[a] = v[b];
                v[b] = t1;
                Object t2 = keyList.get(a);
                keyList.set(a, keyList.get(b));
                keyList.set(b, t2);
            }
        };
        IntComparator comp = new IntComparator(){

            @Override
            public int compare(int a, int b) {
                return v[a] < v[b] ? -1 : (v[a] > v[b] ? 1 : 0);
            }
        };
        Sorting.quickSort(0, keyList.size(), comp, swapper);
    }

    public abstract boolean put(T var1, char var2);

    public abstract boolean removeKey(T var1);

    public String toString() {
        List<T> theKeys = this.keys();
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            T key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public String toStringByValue() {
        ArrayList theKeys = new ArrayList();
        this.keysSortedByValue(theKeys);
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            Object key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public CharArrayList values() {
        CharArrayList list = new CharArrayList(this.size());
        this.values(list);
        return list;
    }

    public void values(final CharArrayList list) {
        list.clear();
        this.forEachKey(new ObjectProcedure<T>(){

            @Override
            public boolean apply(T key) {
                list.add(AbstractObjectCharMap.this.get(key));
                return true;
            }
        });
    }

    public char adjustOrPutValue(T key, char newValue, char incrValue) {
        boolean present = this.containsKey(key);
        if (present) {
            newValue = (char)(this.get(key) + incrValue);
            this.put(key, newValue);
        } else {
            this.put(key, newValue);
        }
        return newValue;
    }
}

